/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.HashSet;
import java.util.Set;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoBounds;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.TileFactory;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public final class GeoUtil {
    public static Dimension getMapSize(int zoom, TileFactoryInfo info) {
        return new Dimension(info.getMapWidthInTilesAtZoom(zoom), info.getMapWidthInTilesAtZoom(zoom));
    }

    public static boolean isValidTile(int x, int y, int zoomLevel, TileFactoryInfo info) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getX() * 2.0 <= (double)(x * info.getTileSize(zoomLevel))) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getY() * 2.0 <= (double)(y * info.getTileSize(zoomLevel))) {
            return false;
        }
        return zoomLevel >= info.getMinimumZoomLevel() && zoomLevel <= info.getMaximumZoomLevel();
    }

    public static Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel, TileFactoryInfo info) {
        return GeoUtil.getBitmapCoordinate(c.getLatitude(), c.getLongitude(), zoomLevel, info);
    }

    public static Point2D getBitmapCoordinate(double latitude, double longitude, int zoomLevel, TileFactoryInfo info) {
        double x = info.getMapCenterInPixelsAtZoom(zoomLevel).getX() + longitude * info.getLongitudeDegreeWidthInPixels(zoomLevel);
        double e = Math.sin(latitude * (Math.PI / 180));
        if (e > 0.9999) {
            e = 0.9999;
        }
        if (e < -0.9999) {
            e = -0.9999;
        }
        double y = info.getMapCenterInPixelsAtZoom(zoomLevel).getY() + 0.5 * Math.log((1.0 + e) / (1.0 - e)) * -1.0 * info.getLongitudeRadianWidthInPixels(zoomLevel);
        return new Point2D.Double(x, y);
    }

    public static GeoPosition getPosition(Point2D pixelCoordinate, int zoom, TileFactoryInfo info) {
        double e2;
        double wx = pixelCoordinate.getX();
        double wy = pixelCoordinate.getY();
        double flon = (wx - info.getMapCenterInPixelsAtZoom(zoom).getX()) / info.getLongitudeDegreeWidthInPixels(zoom);
        double e1 = (wy - info.getMapCenterInPixelsAtZoom(zoom).getY()) / (-1.0 * info.getLongitudeRadianWidthInPixels(zoom));
        double flat = e2 = (2.0 * Math.atan(Math.exp(e1)) - 1.5707963267948966) / (Math.PI / 180);
        GeoPosition wc = new GeoPosition(flat, flon);
        return wc;
    }

    public static GeoBounds getMapBounds(JXMapViewer mapViewer) {
        return new GeoBounds(GeoUtil.getMapGeoBounds(mapViewer));
    }

    private static Set<GeoPosition> getMapGeoBounds(JXMapViewer mapViewer) {
        HashSet<GeoPosition> set = new HashSet<GeoPosition>();
        TileFactory tileFactory = mapViewer.getTileFactory();
        int zoom = mapViewer.getZoom();
        Rectangle bounds = mapViewer.getViewportBounds();
        Point2D.Double pt = new Point2D.Double(((RectangularShape)bounds).getX(), ((RectangularShape)bounds).getY());
        set.add(tileFactory.pixelToGeo(pt, zoom));
        pt = new Point2D.Double(((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight());
        set.add(tileFactory.pixelToGeo(pt, zoom));
        return set;
    }
}

