/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.DefaultWaypointRenderer;
import main.java.org.jdesktop.swingx.mapviewer.Waypoint;
import main.java.org.jdesktop.swingx.mapviewer.WaypointRenderer;
import main.java.org.jdesktop.swingx.painter.AbstractPainter;

public class WaypointPainter<W extends Waypoint>
extends AbstractPainter<JXMapViewer> {
    private WaypointRenderer<? super W> renderer = new DefaultWaypointRenderer();
    private Set<W> waypoints = new HashSet<W>();

    public WaypointPainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public void setRenderer(WaypointRenderer<W> r) {
        this.renderer = r;
    }

    public Set<W> getWaypoints() {
        return Collections.unmodifiableSet(this.waypoints);
    }

    public void setWaypoints(Set<? extends W> waypoints) {
        this.waypoints.clear();
        this.waypoints.addAll(waypoints);
    }

    @Override
    protected void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        if (this.renderer == null) {
            return;
        }
        GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
        Rectangle viewportBounds = map.getViewportBounds();
        g.translate(-viewportBounds.getX(), -viewportBounds.getY());
        for (Waypoint w : this.getWaypoints()) {
            this.renderer.paintWaypoint(g, map, w);
        }
        g.translate(viewportBounds.getX(), viewportBounds.getY());
    }

    public WaypointRenderer<? super W> getRenderer() {
        return this.renderer;
    }
}

