/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer;

import java.awt.geom.Point2D;
import main.java.guru.vfrflight.bean.theme.ColorTheme;
import main.java.guru.vfrflight.bean.theme.DefaultColorTheme;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;

public class TileFactoryInfo {
    private int minimumZoomLevel;
    private int maximumZoomLevel;
    private int totalMapZoom;
    private int tileSize = 256;
    private int[] mapWidthInTilesAtZoom;
    private Point2D[] mapCenterInPixelsAtZoom;
    private double[] longitudeDegreeWidthInPixels;
    private double[] longitudeRadianWidthInPixels;
    protected final String baseURL;
    private String xparam;
    private String yparam;
    private String zparam;
    private boolean xr2l = true;
    private boolean yt2b = true;
    private int defaultZoomLevel;
    private String name;

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this("name not provided", minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, xparam, yparam, zparam);
    }

    public TileFactoryInfo(String name, int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, String baseURL, String xparam, String yparam, String zparam) {
        this.name = name;
        this.minimumZoomLevel = minimumZoomLevel;
        this.maximumZoomLevel = maximumZoomLevel;
        this.totalMapZoom = totalMapZoom;
        this.baseURL = baseURL;
        this.xparam = xparam;
        this.yparam = yparam;
        this.zparam = zparam;
        this.setXr2l(xr2l);
        this.setYt2b(yt2b);
        this.tileSize = tileSize;
        int tilesize = this.getTileSize(0);
        this.longitudeDegreeWidthInPixels = new double[totalMapZoom + 1];
        this.longitudeRadianWidthInPixels = new double[totalMapZoom + 1];
        this.mapCenterInPixelsAtZoom = new Point2D.Double[totalMapZoom + 1];
        this.mapWidthInTilesAtZoom = new int[totalMapZoom + 1];
        for (int z = totalMapZoom; z >= 0; --z) {
            this.longitudeDegreeWidthInPixels[z] = (double)tilesize / 360.0;
            this.longitudeRadianWidthInPixels[z] = (double)tilesize / (Math.PI * 2);
            int t2 = tilesize / 2;
            this.mapCenterInPixelsAtZoom[z] = new Point2D.Double(t2, t2);
            this.mapWidthInTilesAtZoom[z] = tilesize / this.getTileSize(z);
            tilesize *= 2;
        }
    }

    public int getMinimumZoomLevel() {
        return this.minimumZoomLevel;
    }

    public int getMaximumZoomLevel() {
        return this.maximumZoomLevel;
    }

    public int getTotalMapZoom() {
        return this.totalMapZoom;
    }

    public int getMapWidthInTilesAtZoom(int zoom) {
        return this.mapWidthInTilesAtZoom[zoom];
    }

    public Point2D getMapCenterInPixelsAtZoom(int zoom) {
        return this.mapCenterInPixelsAtZoom[zoom];
    }

    public String[] getTileUrl(int x, int y, int zoom) {
        String ypart = "&" + this.yparam + "=" + y;
        if (!this.yt2b) {
            int tilemax = this.getMapWidthInTilesAtZoom(zoom);
            ypart = "&" + this.yparam + "=" + (tilemax / 2 - y - 1);
        }
        String url = this.baseURL + "&" + this.xparam + "=" + x + ypart + "&" + this.zparam + "=" + zoom;
        return new String[]{url};
    }

    public int getTileSize(int zoom) {
        return this.tileSize;
    }

    public double getLongitudeDegreeWidthInPixels(int zoom) {
        return this.longitudeDegreeWidthInPixels[zoom];
    }

    public double getLongitudeRadianWidthInPixels(int zoom) {
        return this.longitudeRadianWidthInPixels[zoom];
    }

    public boolean isXr2l() {
        return this.xr2l;
    }

    public void setXr2l(boolean xr2l) {
        this.xr2l = xr2l;
    }

    public boolean isYt2b() {
        return this.yt2b;
    }

    public void setYt2b(boolean yt2b) {
        this.yt2b = yt2b;
    }

    public int getDefaultZoomLevel() {
        return this.defaultZoomLevel;
    }

    public void setDefaultZoomLevel(int defaultZoomLevel) {
        this.defaultZoomLevel = defaultZoomLevel;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getCopyrightNotice() {
        return null;
    }

    public String getCopyrightLink() {
        return null;
    }

    public ColorTheme getColorTheme() {
        return new DefaultColorTheme();
    }

    public TileFactoryInfoType getType() {
        return null;
    }
}

