/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.Tile;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import main.java.org.jdesktop.swingx.mapviewer.TileListener;
import main.java.org.jdesktop.swingx.mapviewer.util.GeoUtil;

public abstract class TileFactory {
    private TileFactoryInfo info;
    private List<TileListener> tileListeners = new ArrayList<TileListener>();

    protected TileFactory(TileFactoryInfo info) {
        this.info = info;
    }

    public int getTileSize(int zoom) {
        return this.getInfo().getTileSize(zoom);
    }

    public Dimension getMapSize(int zoom) {
        return GeoUtil.getMapSize(zoom, this.getInfo());
    }

    public abstract Tile getTile(int var1, int var2, int var3);

    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        return GeoUtil.getPosition(pixelCoordinate, zoom, this.getInfo());
    }

    public Point2D geoToPixel(GeoPosition c, int zoomLevel) {
        return GeoUtil.getBitmapCoordinate(c, zoomLevel, this.getInfo());
    }

    public TileFactoryInfo getInfo() {
        return this.info;
    }

    public void addTileListener(TileListener listener) {
        this.tileListeners.add(listener);
    }

    public void removeTileListener(TileListener listener) {
        this.tileListeners.remove(listener);
    }

    public abstract void dispose();

    protected void fireTileLoadedEvent(Tile tile) {
        for (TileListener listener : this.tileListeners) {
            listener.tileLoaded(tile);
        }
    }

    protected abstract void startLoading(Tile var1);
}

