/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class TileCache {
    private static final Logger log = Logger.getLogger(TileCache.class);
    private Map<String, BufferedImage> imgmap = new HashMap<String, BufferedImage>();
    private LinkedList<String> imgmapAccessQueue = new LinkedList();
    private int imagesize = 0;
    private Map<String, byte[]> bytemap = new HashMap<String, byte[]>();
    private LinkedList<String> bytemapAccessQueue = new LinkedList();
    private int bytesize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String uri, byte[] bimg, BufferedImage img) {
        Map<String, byte[]> map = this.bytemap;
        synchronized (map) {
            while (this.bytesize > 50000000) {
                String olduri = this.bytemapAccessQueue.removeFirst();
                byte[] oldbimg = this.bytemap.remove(olduri);
                this.bytesize -= oldbimg.length;
            }
            this.bytemap.put(uri, bimg);
            this.bytesize += bimg.length;
            this.bytemapAccessQueue.addLast(uri);
        }
        this.addToImageCache(uri, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(String uri) throws IOException {
        Map<String, BufferedImage> map = this.imgmap;
        synchronized (map) {
            if (this.imgmap.containsKey(uri)) {
                this.imgmapAccessQueue.remove(uri);
                this.imgmapAccessQueue.addLast(uri);
                return this.imgmap.get(uri);
            }
        }
        map = this.bytemap;
        synchronized (map) {
            if (this.bytemap.containsKey(uri)) {
                this.bytemapAccessQueue.remove(uri);
                this.bytemapAccessQueue.addLast(uri);
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(this.bytemap.get(uri)));
                this.addToImageCache(uri, img);
                return img;
            }
        }
        return null;
    }

    public void needMoreMemory() {
        this.imgmap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToImageCache(String uri, BufferedImage img) {
        Map<String, BufferedImage> map = this.imgmap;
        synchronized (map) {
            try {
                while (this.imagesize > 50000000) {
                    String olduri = this.imgmapAccessQueue.removeFirst();
                    BufferedImage oldimg = this.imgmap.remove(olduri);
                    this.imagesize -= oldimg.getWidth() * oldimg.getHeight() * 4;
                }
                this.imgmap.put(uri, img);
                this.imagesize += img.getWidth() * img.getHeight() * 4;
                this.imgmapAccessQueue.addLast(uri);
            }
            catch (Exception ex) {
                log.debug("Failed to load tile at URL. Tile is null");
            }
        }
    }
}

