/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.Waypoint;
import main.java.org.jdesktop.swingx.mapviewer.WaypointRenderer;

public class DefaultWaypointRenderer
implements WaypointRenderer<Waypoint> {
    private BufferedImage img = null;

    public DefaultWaypointRenderer() {
        try {
            this.img = ImageIO.read(this.getClass().getResource("resources/standard_waypoint.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint w) {
        if (this.img == null) {
            return;
        }
        Point2D point = map.getTileFactory().geoToPixel(w.getPosition(), map.getZoom());
        int x = (int)point.getX() - this.img.getWidth() / 2;
        int y = (int)point.getY() - this.img.getHeight();
        g.drawImage((Image)this.img, x, y, null);
    }
}

