/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.mapviewer;

import com.google.common.cache.Cache;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.CacheUtil;
import main.java.org.jdesktop.swingx.mapviewer.Tile;
import main.java.org.jdesktop.swingx.mapviewer.TileFactory;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import main.java.org.jdesktop.swingx.mapviewer.util.GeoUtil;

public abstract class AbstractTileFactory
extends TileFactory {
    private int threadPoolSize = 8;
    private ExecutorService service;
    private Map<String, Tile> tileMap = new HashMap<String, Tile>();
    private static BlockingQueue<Tile> tileQueue = new PriorityBlockingQueue<Tile>(5, new Comparator<Tile>(){

        @Override
        public int compare(Tile o1, Tile o2) {
            if (o1.getPriority() == Tile.Priority.Low && o2.getPriority() == Tile.Priority.High) {
                return 1;
            }
            if (o1.getPriority() == Tile.Priority.High && o2.getPriority() == Tile.Priority.Low) {
                return -1;
            }
            return 0;
        }
    });

    public AbstractTileFactory(TileFactoryInfo info) {
        super(info);
    }

    @Override
    public Tile getTile(int x, int y, int zoom) {
        return this.getTile(x, y, zoom, true);
    }

    private Tile getTile(int tpx, int tpy, int zoom, boolean eagerLoad) {
        int tileX = tpx;
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
        }
        int tileY = tpy;
        String[] url = this.getInfo().getTileUrl(tileX %= numTilesWide, tileY, zoom);
        Tile.Priority pri = Tile.Priority.High;
        if (!eagerLoad) {
            pri = Tile.Priority.Low;
        }
        Tile tile = null;
        String urlHash = CacheUtil.getUrlHash(url);
        if (!this.tileMap.containsKey(urlHash)) {
            if (!GeoUtil.isValidTile(tileX, tileY, zoom, this.getInfo())) {
                tile = new Tile(tileX, tileY, zoom);
            } else {
                tile = new Tile(tileX, tileY, zoom, url, pri, this);
                this.startLoading(tile);
            }
            this.tileMap.put(urlHash, tile);
        } else {
            tile = this.tileMap.get(urlHash);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return tile;
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "tile-pool-" + this.count++);
                    t.setPriority(1);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    @Override
    public void dispose() {
        if (this.service != null) {
            this.service.shutdown();
            this.service = null;
        }
    }

    public void setThreadPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size invalid: " + size + ". The size of the threadpool must be greater than 0.");
        }
        this.threadPoolSize = size;
    }

    @Override
    protected synchronized void startLoading(Tile tile) {
        if (tile.isLoading()) {
            return;
        }
        tile.setLoading(true);
        try {
            tileQueue.put(tile);
            this.getService().submit(this.createTileRunner(tile));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Runnable createTileRunner(Tile tile) {
        return new TileRunner();
    }

    public synchronized void promote(Tile tile) {
        if (tileQueue.contains(tile)) {
            try {
                tileQueue.remove(tile);
                tile.setPriority(Tile.Priority.High);
                tileQueue.put(tile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TileRunner
    implements Runnable {
        private TileRunner() {
        }

        @Override
        public void run() {
            final Tile tile = (Tile)tileQueue.remove();
            int trys = 3;
            Cache<String, BufferedImage> cache = MapFrame.getInstance().getMapViewer().getTilesCache();
            while (!tile.isLoaded() && trys > 0) {
                try {
                    BufferedImage img = null;
                    String urlHash = CacheUtil.getUrlHash(tile.getURL());
                    img = (BufferedImage)cache.asMap().get(urlHash);
                    if (img == null) {
                        if (tile.getURL().length == 1) {
                            URI uri = new URI(tile.getURL()[0]);
                            img = ImageIO.read(new ByteArrayInputStream(this.cacheInputStream(uri.toURL())));
                            cache.asMap().put(urlHash, img);
                            img = (BufferedImage)cache.asMap().get(urlHash);
                        } else {
                            img = new BufferedImage(AbstractTileFactory.this.getInfo().getTileSize(0), AbstractTileFactory.this.getInfo().getTileSize(0), 2);
                            for (int i = 0; i < tile.getURL().length; ++i) {
                                URI uri = new URI(tile.getURL()[i]);
                                BufferedImage partialImg = ImageIO.read(new ByteArrayInputStream(this.cacheInputStream(uri.toURL())));
                                Graphics2D g = img.createGraphics();
                                if (i > 0) {
                                    g.setComposite(AlphaComposite.getInstance(3, 0.35f));
                                }
                                g.drawImage((Image)partialImg, 0, 0, null);
                                g.dispose();
                            }
                            cache.asMap().put(urlHash, img);
                            img = (BufferedImage)cache.asMap().get(urlHash);
                        }
                    }
                    if (img == null) {
                        --trys;
                        continue;
                    }
                    final BufferedImage i = img;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            tile.image = new SoftReference<BufferedImage>(i);
                            tile.setLoaded(true);
                            AbstractTileFactory.this.fireTileLoadedEvent(tile);
                        }
                    });
                }
                catch (Throwable e) {
                    if (trys <= 0) continue;
                    --trys;
                }
            }
            tile.setLoading(false);
        }

        private byte[] cacheInputStream(URL url) throws IOException {
            int n;
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0");
            InputStream ins = connection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = ins.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            return bout.toByteArray();
        }
    }
}

