/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx.input;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class ZoomMouseWheelListenerCursor
implements MouseWheelListener {
    private JXMapViewer viewer;

    public ZoomMouseWheelListenerCursor(JXMapViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        Point current = evt.getPoint();
        Rectangle bound = this.viewer.getViewportBounds();
        double dx = current.x - bound.width / 2;
        double dy = current.y - bound.height / 2;
        Dimension oldMapSize = this.viewer.getTileFactory().getMapSize(this.viewer.getZoom());
        this.viewer.setZoom(this.viewer.getZoom() + evt.getWheelRotation());
        Dimension mapSize = this.viewer.getTileFactory().getMapSize(this.viewer.getZoom());
        Point2D center = this.viewer.getCenter();
        double dzw = mapSize.getWidth() / oldMapSize.getWidth();
        double dzh = mapSize.getHeight() / oldMapSize.getHeight();
        double x = center.getX() + dx * (dzw - 1.0);
        double y = center.getY() + dy * (dzh - 1.0);
        this.viewer.setCenter(new Point2D.Double(x, y));
    }
}

