/*
 * Decompiled with CFR 0.152.
 */
package main.java.org.jdesktop.swingx;

import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.theme.ColorTheme;
import main.java.guru.vfrflight.bean.theme.DefaultColorTheme;
import main.java.guru.vfrflight.bean.theme.SatelliteColorTheme;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class VirtualEarthTileFactoryInfo
extends TileFactoryInfo {
    public static final MVEMode MAP = new MVEMode("map", "map", "r", ".png");
    public static final MVEMode SATELLITE = new MVEMode("satellite", "satellite", "a", ".jpeg");
    public static final MVEMode HYBRID = new MVEMode("hybrid", "hybrid", "h", ".jpeg");
    private final String copyrightNotice;
    private final String copyrightLink;
    private static final int TOP_ZOOM_LEVEL = 19;
    private static final int MAX_ZOOM_LEVEL = 17;
    private static final int MIN_ZOOM_LEVEL = 2;
    private static final int TILE_SIZE = 256;
    private final MVEMode mode;

    public VirtualEarthTileFactoryInfo(String name, MVEMode mode, String copyrightNotice, String copyrightLink) {
        super(name, 2, 17, 19, 256, false, false, "", "", "", "");
        this.mode = mode;
        this.copyrightLink = copyrightLink;
        this.copyrightNotice = copyrightNotice;
    }

    public String getModeName() {
        return this.mode.name;
    }

    public String getModeLabel() {
        return this.mode.label;
    }

    @Override
    public String[] getTileUrl(int x, int y, int zoom) {
        String quad = this.tileToQuadKey(x, y, 19 - zoom);
        StringBuffer url = new StringBuffer();
        url.append("http://");
        url.append(this.mode.type);
        url.append(quad.charAt(quad.length() - 1));
        url.append(".ortho.tiles.virtualearth.net/tiles/");
        url.append(this.mode.type);
        url.append(quad);
        url.append(this.mode.ext);
        url.append("?g=1");
        return new String[]{url.toString()};
    }

    private String tileToQuadKey(int tx, int ty, int zl) {
        StringBuffer quad = new StringBuffer();
        for (int i = zl; i > 0; --i) {
            int mask = 1 << i - 1;
            int cell = 0;
            if ((tx & mask) != 0) {
                ++cell;
            }
            if ((ty & mask) != 0) {
                cell += 2;
            }
            quad.append(cell);
        }
        return quad.toString();
    }

    @Override
    public String getCopyrightNotice() {
        return this.copyrightNotice == null ? Messages.getInstance().get("openstreetmap_copyright") : this.copyrightNotice;
    }

    @Override
    public String getCopyrightLink() {
        return this.copyrightLink == null ? Messages.getInstance().get("openstreetmap_copyright_link") : this.copyrightLink;
    }

    @Override
    public ColorTheme getColorTheme() {
        return SATELLITE.equals(this.mode) ? new SatelliteColorTheme() : new DefaultColorTheme();
    }

    @Override
    public TileFactoryInfoType getType() {
        if (SATELLITE.equals(this.mode)) {
            return TileFactoryInfoType.VIRTUAL_EARTH_SATELLITE;
        }
        return MAP.equals(this.mode) ? TileFactoryInfoType.VIRTUAL_EARTH_MAP : TileFactoryInfoType.VIRTUAL_EARTH_HYBRID;
    }

    public static class MVEMode {
        private String type;
        private String ext;
        private String name;
        private String label;

        private MVEMode(String name, String label, String type, String ext) {
            this.type = type;
            this.ext = ext;
            this.name = name;
            this.label = label;
        }
    }
}

