/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.xpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class XPlaneConnect {
    private static final Logger log = Logger.getLogger(XPlaneConnect.class);
    private DatagramSocket socket;
    private InetAddress xplaneAddr;
    private int xplanePort;

    public XPlaneConnect(String xpHost, int xpPort, int port) throws SocketException, UnknownHostException {
        this(xpHost, xpPort, port, 100);
    }

    public XPlaneConnect(String xpHost, int xpPort, int port, int timeout) throws SocketException, UnknownHostException {
        this.socket = new DatagramSocket(port);
        this.xplaneAddr = InetAddress.getByName(xpHost);
        this.xplanePort = xpPort;
        this.socket.setSoTimeout(timeout);
        log.info("Opening connection for " + this.xplaneAddr + ":" + this.xplanePort);
    }

    public void close() {
        if (this.socket != null) {
            log.info("Closing connection for " + this.xplaneAddr + ":" + this.xplanePort);
            this.socket.close();
            this.socket = null;
        }
    }

    private byte[] readUDP() throws IOException {
        byte[] buffer = new byte[65536];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.socket.receive(packet);
            return Arrays.copyOf(buffer, packet.getLength());
        }
        catch (SocketTimeoutException ex) {
            return new byte[0];
        }
    }

    private void sendUDP(byte[] buffer) throws IOException {
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.xplaneAddr, this.xplanePort);
        this.socket.send(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getData(int ac, int expectedNumber) throws IOException {
        try (ByteArrayOutputStream os = null;){
            os = new ByteArrayOutputStream();
            os.write("GETC".getBytes(StandardCharsets.UTF_8));
            os.write(255);
            os.write(ac);
            this.sendUDP(os.toByteArray());
            byte[] data = this.readUDP();
            if (data.length == 0) {
                throw new IOException("No response received.");
            }
            if (data.length != 9 + expectedNumber * 4) {
                throw new IOException("Unexpected data length (" + data.length + ")");
            }
            int num = (data.length - 9) / 4;
            float[] result = new float[num];
            ByteBuffer bb = ByteBuffer.wrap(data);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < num; ++i) {
                result[i] = bb.getFloat(9 + i * 4);
            }
            float[] fArray = result;
            return fArray;
        }
    }

    public float[][] readData() throws IOException {
        byte[] buffer = this.readUDP();
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        int cur = 5;
        int len = bb.get(cur++);
        float[][] result = new float[bb.get(len)][9];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < 9; ++j) {
                result[i][j] = bb.getFloat(cur);
                cur += 4;
            }
        }
        return result;
    }
}

