/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.xpc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.xpc.XPCBean;
import main.java.guru.vfrflight.xpc.XPlaneConnect;
import org.apache.log4j.Logger;

public class XPCUtil {
    private static final Logger log = Logger.getLogger(XPCUtil.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final int CLIENT_TO_XP_PORT = 49002;
    private static final int PLAYER_AIRCRAFT_NUMBER = 0;

    public static XPlaneConnect getConnection(String ip, int port) throws IOException {
        return new XPlaneConnect(ip, 49002, port);
    }

    public static XPlaneConnect getConnection(int port) throws IOException {
        return new XPlaneConnect(LOCALHOST, 49002, port);
    }

    public static XPCBean getData(XPlaneConnect xpc) throws IOException {
        float[] values = xpc.getData(0, 26);
        XPCBean bean = new XPCBean();
        bean.setVindInKt(Float.valueOf(values[0]));
        bean.setGsInKt(Float.valueOf(values[3]));
        bean.setPitch(Float.valueOf(-values[9]));
        bean.setRoll(Float.valueOf(-values[10]));
        bean.setMagHeading(Float.valueOf(values[11]));
        bean.setTrueHeading(Float.valueOf(values[12]));
        bean.setLat(Float.valueOf(values[18]));
        bean.setLon(Float.valueOf(values[19]));
        bean.setAltMslInFt(Float.valueOf(values[20]));
        bean.setAltAglInFt(Float.valueOf(values[21]));
        bean.setOnRunway(!NumberUtil.floatEqualsZero(values[22]));
        bean.setAltIndInFt(Float.valueOf(values[23]));
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Map<String, String> readPrfConfig(String filename) {
        HashMap<String, String> results = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            String line = null;
            br.readLine();
            br.readLine();
            while ((line = br.readLine()) != null) {
                results.put(XPCUtil.getPrfKey(line), XPCUtil.getPrfValue(line));
            }
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't load prf file " + filename, e);
            Map<String, String> map = null;
            IOUtil.closeQuietly(br);
            return map;
        }
        catch (IOException e2) {
            log.error("Couldn't load prf file " + filename, e2);
            Map<String, String> map = null;
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
            return map;
        }
        IOUtil.closeQuietly(br);
        return results;
    }

    private static String getPrfValue(String line) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" ");
        if (split.length <= 1) {
            return null;
        }
        return line.substring(split[0].length()).trim();
    }

    private static String getPrfKey(String line) {
        if (line == null) {
            return null;
        }
        String[] split = line.split(" ");
        return split[0];
    }
}

