/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.xpc;

import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.NumberUtil;

public class XPCBean
implements ExtConnectBean {
    private Float lat;
    private Float lon;
    private Float altMslInFt;
    private Float altIndInFt;
    private Float altAglInFt;
    private Float vindInKt;
    private Float gsInKt;
    private Float magHeading;
    private Float trueHeading;
    private Float pitch;
    private Float roll;
    private Boolean onRunway;

    @Override
    public XPCBean clone() {
        XPCBean bean = new XPCBean();
        bean.setAltAglInFt(this.altAglInFt);
        bean.setAltIndInFt(this.altIndInFt);
        bean.setAltMslInFt(this.altMslInFt);
        bean.setGsInKt(this.gsInKt);
        bean.setLat(this.lat);
        bean.setLon(this.lon);
        bean.setMagHeading(this.magHeading);
        bean.setOnRunway(this.onRunway);
        bean.setPitch(this.pitch);
        bean.setRoll(this.roll);
        bean.setTrueHeading(this.trueHeading);
        bean.setVindInKt(this.vindInKt);
        return bean;
    }

    public void setLat(Float lat) {
        this.lat = lat;
    }

    public void setLon(Float lon) {
        this.lon = lon;
    }

    public void setAltMslInFt(Float altMslInFt) {
        this.altMslInFt = altMslInFt;
    }

    public void setGsInKt(Float gsInKt) {
        this.gsInKt = gsInKt;
    }

    public void setMagHeading(Float magHeading) {
        this.magHeading = magHeading;
    }

    public void setTrueHeading(Float trueHeading) {
        this.trueHeading = trueHeading;
    }

    public void setPitch(Float pitch) {
        this.pitch = pitch;
    }

    public void setRoll(Float roll) {
        this.roll = roll;
    }

    public void setAltIndInFt(Float altIndInFt) {
        this.altIndInFt = altIndInFt;
    }

    public void setAltAglInFt(Float altAglInFt) {
        this.altAglInFt = altAglInFt;
    }

    public void setVindInKt(Float vindInKt) {
        this.vindInKt = vindInKt;
    }

    public void setOnRunway(Boolean onRunway) {
        this.onRunway = onRunway;
    }

    @Override
    public boolean positionEquals(ExtConnectBean bean) {
        if (bean == null || !(bean instanceof XPCBean)) {
            return false;
        }
        XPCBean other = (XPCBean)bean;
        return NumberUtil.doubleEqualsDouble(this.getUserLat().floatValue(), other.getUserLat().floatValue(), 5) && NumberUtil.doubleEqualsDouble(this.getUserLon().floatValue(), other.getUserLon().floatValue(), 5);
    }

    @Override
    public Float getUserLat() {
        return this.lat;
    }

    @Override
    public Float getUserLon() {
        return this.lon;
    }

    @Override
    public Float getUserAlt() {
        return this.altMslInFt;
    }

    @Override
    public Float getUserIndicatedAlt() {
        return this.altIndInFt;
    }

    @Override
    public Float getUserGs() {
        return this.gsInKt;
    }

    @Override
    public Float getUserTrueHeading() {
        return this.trueHeading;
    }

    @Override
    public Float getUserMagHeading() {
        return this.magHeading;
    }

    @Override
    public Float getMagVariation() {
        if (this.magHeading == null || this.trueHeading == null) {
            return null;
        }
        return Float.valueOf((float)(GpsUtil.normalizeCourse(this.trueHeading.floatValue()) - GpsUtil.normalizeCourse(this.magHeading.floatValue())));
    }

    @Override
    public Float getUserAltAboveTerrain() {
        return this.altAglInFt;
    }

    @Override
    public Float getUserVerticalSpeed() {
        return null;
    }

    @Override
    public Float getUserIndicatedSpeed() {
        return this.vindInKt;
    }

    @Override
    public Float getUserPitch() {
        return this.pitch;
    }

    @Override
    public Float getUserBank() {
        return this.roll;
    }

    @Override
    public Float getgForce() {
        return null;
    }

    @Override
    public Float getWindVelocity() {
        return null;
    }

    @Override
    public Float getWindDirection() {
        return null;
    }

    @Override
    public Short getFlapsHandle() {
        return null;
    }

    @Override
    public Float getYokeXPosition() {
        return null;
    }

    @Override
    public Float getYokeYPosition() {
        return null;
    }

    @Override
    public Float getRudderPeddalsPosition() {
        return null;
    }

    @Override
    public boolean isOnGround() {
        return false;
    }

    @Override
    public Long getTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public float getGroundLevel() {
        return 0.0f;
    }

    @Override
    public GpsPlace getGpsPlace() {
        return new GpsPlace(this.lat.floatValue(), this.lon.floatValue());
    }

    @Override
    public boolean hasData() {
        return this.lat != null && this.lon != null;
    }

    @Override
    public boolean isInside(GpsArea area) {
        return (double)this.lat.floatValue() <= area.getMaxLat() && (double)this.lat.floatValue() >= area.getMinLat() && (double)this.lon.floatValue() >= area.getMinLon() && (double)this.lon.floatValue() <= area.getMaxLon();
    }

    @Override
    public Float getUserTas() {
        return null;
    }

    @Override
    public Float getFps() {
        return null;
    }
}

