/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.weather.core;

import java.io.Serializable;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.weather.core.Report;

public class Station
implements Serializable {
    private static final long serialVersionUID = -536872872781624693L;
    private String name;
    private String icao;
    private Double lat;
    private Double lon;
    private Report report;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcao() {
        return this.icao;
    }

    public void setIcao(String icao) {
        this.icao = icao;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Report getReport() {
        if (this.report == null) {
            this.report = new Report();
        }
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Station [name=");
        builder.append(this.name);
        builder.append(", icao=");
        builder.append(this.icao);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", report=");
        builder.append(this.report);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.icao == null ? 0 : this.icao.hashCode());
        result = 31 * result + (this.lat == null ? 0 : this.lat.hashCode());
        result = 31 * result + (this.lon == null ? 0 : this.lon.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.report == null ? 0 : this.report.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Station other = (Station)obj;
        if (this.icao == null ? other.icao != null : !this.icao.equals(other.icao)) {
            return false;
        }
        if (this.lat == null ? other.lat != null : !this.lat.equals(other.lat)) {
            return false;
        }
        if (this.lon == null ? other.lon != null : !this.lon.equals(other.lon)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.report == null ? other.report != null : !this.report.equals(other.report));
    }

    public Station clone() {
        Station s = new Station();
        s.setIcao(this.getIcao());
        s.setLat(this.getLat());
        s.setLon(this.getLon());
        s.setName(this.getName());
        s.setReport(this.getReport().clone());
        return s;
    }

    public GpsPlace getGpsPlace() {
        return new GpsPlace(this.lat, this.lon);
    }

    public boolean isInside(GpsArea area) {
        return this.lat <= area.getMaxLat() && this.lat >= area.getMinLat() && this.lon >= area.getMinLon() && this.lon <= area.getMaxLon();
    }

    public boolean isMetarRecentAndValid() {
        return this.getReport() != null && this.getReport().getMetarData() != null && this.getReport().getMetarData().isWithinHourRange(1);
    }
}

