/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.weather;

import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.metar.MetarDecoderUtil;
import main.java.guru.vfrflight.util.metar.TafDecoderUtil;
import main.java.guru.vfrflight.weather.core.Report;
import main.java.guru.vfrflight.weather.core.Station;
import main.java.guru.vfrflight.xml.metar.Response;
import main.java.guru.vfrflight.xml.taf.Response;
import org.apache.log4j.Logger;

public class WeatherUtil {
    private static final Logger log = Logger.getLogger(WeatherUtil.class);
    private static final String[] AWIACJA_IMGW_METAR_30m_1h = new String[]{"EPBY", "EPGD", "EPKK", "EPKT", "EPLB", "EPLL", "EPMO", "EPPO", "EPRZ", "EPSC", "EPWA", "EPWR", "EPZG"};
    private static final String[] AWIACJA_IMGW_METAR_MIL = new String[]{"EPBC", "EPCE", "EPDA", "EPDE", "EPIR", "EPKS", "EPLK", "EPLY", "EPMB", "EPMI", "EPMM", "EPNA", "EPOK", "EPPR", "EPPW", "EPRA", "EPSN", "EPTM"};
    private static final long AWIACJA_IMGW_METAR_CACHE_TIME = 30L;
    private static final GpsPlace METEO_AREA_TOP_LEFT = new GpsPlace(new GpsCoord(65, 31, 0.0), new GpsCoord(1, 18, 0.0));
    private static final GpsPlace METEO_AREA_BOTTOM_RIGHT = new GpsPlace(new GpsCoord(44, 45, 0.0), new GpsCoord(29, 52, 0.0));
    private static final GpsArea METEO_AREA = new GpsArea(METEO_AREA_TOP_LEFT, METEO_AREA_BOTTOM_RIGHT);
    private static final String METEO_ACT_X_SEARCH_STRING = "var act_x = ";
    private static final String METEO_ACT_Y_SEARCH_STRING = "var act_y = ";
    private static final String METEO_FCSTDATE_SEARCH_STRING = "var fcstdate = \"";
    private static final String METEO_NTYPE_SEARCH_STRING = "var ntype =\"";

    public static List<Station> getStationsOnPath(GpsPlace from, GpsPlace to, double distance, boolean includeMetar, boolean includeTaf) {
        List<Station> metarStations = new ArrayList<Station>();
        if (includeMetar) {
            String url = "http://www.aviationweather.gov/adds/dataserver_current/httpparam?dataSource=metars&requestType=retrieve&format=xml&flightPath=" + distance + ";" + from.getLon().getValue() + "," + from.getLat().getValue() + ";" + to.getLon().getValue() + "," + to.getLat().getValue() + "&hoursBeforeNow=1";
            metarStations = WeatherUtil.getMetarStations(url);
        }
        List<Station> tafStations = new ArrayList<Station>();
        if (includeTaf) {
            String url = "http://www.aviationweather.gov/adds/dataserver_current/httpparam?dataSource=tafs&requestType=retrieve&format=xml&flightPath=" + distance + ";" + from.getLon().getValue() + "," + from.getLat().getValue() + ";" + to.getLon().getValue() + "," + to.getLat().getValue() + "&hoursBeforeNow=6";
            tafStations = WeatherUtil.getTafStations(url);
        }
        if (tafStations == null && metarStations == null) {
            return null;
        }
        if (tafStations == null) {
            return metarStations;
        }
        if (metarStations == null) {
            return tafStations;
        }
        ArrayList<Station> mergedStations = new ArrayList<Station>();
        for (Station taf : tafStations) {
            Station metarFound = null;
            for (Station metar : metarStations) {
                if (!metar.getIcao().equals(taf.getIcao())) continue;
                metarFound = metar;
                break;
            }
            if (metarFound != null) {
                taf.getReport().setMetar(metarFound.getReport().getMetar());
                metarStations.remove(metarFound);
            }
            mergedStations.add(taf);
        }
        for (Station metar : metarStations) {
            mergedStations.add(metar);
        }
        if (includeMetar) {
            WeatherUtil.includeAwiacjaImgwMetars(mergedStations);
        }
        return mergedStations;
    }

    public static List<Station> getStationsInRegion(GpsArea area, boolean includeMetar, boolean includeTaf) {
        List<Station> metarStations = new ArrayList<Station>();
        if (includeMetar) {
            String url = "http://www.aviationweather.gov/adds/dataserver_current/httpparam?dataSource=metars&requestType=retrieve&format=xml&minLat=" + area.getMinLat() + "&minLon=" + area.getMinLon() + "&maxLat=" + area.getMaxLat() + "&maxLon=" + area.getMaxLon() + "&hoursBeforeNow=1";
            metarStations = WeatherUtil.getMetarStations(url);
        }
        List<Station> tafStations = new ArrayList<Station>();
        if (includeTaf) {
            String url = "http://www.aviationweather.gov/adds/dataserver_current/httpparam?dataSource=tafs&requestType=retrieve&format=xml&minLat=" + area.getMinLat() + "&minLon=" + area.getMinLon() + "&maxLat=" + area.getMaxLat() + "&maxLon=" + area.getMaxLon() + "&hoursBeforeNow=6";
            tafStations = WeatherUtil.getTafStations(url);
        }
        if (tafStations == null && metarStations == null) {
            return null;
        }
        if (tafStations == null) {
            return metarStations;
        }
        if (metarStations == null) {
            return tafStations;
        }
        ArrayList<Station> mergedStations = new ArrayList<Station>();
        for (Station taf : tafStations) {
            Station metarFound = null;
            for (Station metar : metarStations) {
                if (!metar.getIcao().equals(taf.getIcao())) continue;
                metarFound = metar;
                break;
            }
            if (metarFound != null) {
                taf.getReport().setMetar(metarFound.getReport().getMetar());
                metarStations.remove(metarFound);
            }
            mergedStations.add(taf);
        }
        for (Station metar : metarStations) {
            mergedStations.add(metar);
        }
        if (includeMetar) {
            WeatherUtil.includeAwiacjaImgwMetars(mergedStations);
        }
        return mergedStations;
    }

    private static void includeAwiacjaImgwMetars(List<Station> metarStations) {
        for (Station station : metarStations) {
            if (station.getReport().getMetar() != null || !WeatherUtil.isAwiacjaImgwMetar(station.getIcao())) continue;
            station.getReport().setMetar(WeatherUtil.getLatestAwiacjaImgwMetar(station.getIcao()));
        }
    }

    public static List<Station> getMetarStations(String url) {
        ArrayList<Station> stations = new ArrayList<Station>();
        ArrayList<String> stationsInList = new ArrayList<String>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Response.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Response responseXml = (Response)jaxbUnmarshaller.unmarshal(new URL(url));
            for (Response.Data.METAR metar : responseXml.getData().getMETAR()) {
                if (stationsInList.contains(metar.getStationId())) continue;
                stationsInList.add(metar.getStationId());
                Station s = new Station();
                s.setIcao(metar.getStationId());
                s.setName(metar.getStationId());
                s.setLat(metar.getLatitude().doubleValue());
                s.setLon(metar.getLongitude().doubleValue());
                s.setReport(new Report(MetarDecoderUtil.addMetarKeyword(metar.getRawText()), null));
                stations.add(s);
            }
            return stations;
        }
        catch (JAXBException e) {
            log.error("Couldn't parse XML for METAR stations from " + url, e);
        }
        catch (MalformedURLException e) {
            log.error("Couldn't parse XML for METAR stations from " + url, e);
        }
        return null;
    }

    public static List<Station> getTafStations(String url) {
        ArrayList<Station> stations = new ArrayList<Station>();
        ArrayList<String> stationsInList = new ArrayList<String>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{main.java.guru.vfrflight.xml.taf.Response.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            main.java.guru.vfrflight.xml.taf.Response responseXml = (main.java.guru.vfrflight.xml.taf.Response)jaxbUnmarshaller.unmarshal(new URL(url));
            for (Response.Data.TAF taf : responseXml.getData().getTAF()) {
                if (stationsInList.contains(taf.getStationId())) continue;
                stationsInList.add(taf.getStationId());
                Station s = new Station();
                s.setIcao(taf.getStationId());
                s.setName(taf.getStationId());
                s.setLat(taf.getLatitude().doubleValue());
                s.setLon(taf.getLongitude().doubleValue());
                s.setReport(new Report(null, TafDecoderUtil.addTafKeyword(taf.getRawText())));
                stations.add(s);
            }
            return stations;
        }
        catch (JAXBException e) {
            log.error("Couldn't parse XML for TAF stations from " + url, e);
        }
        catch (MalformedURLException e) {
            log.error("Couldn't parse XML for TAF stations from " + url, e);
        }
        return null;
    }

    private static String getLatestAwiacjaImgwMetar(String icao) {
        String url = null;
        if (WeatherUtil.isAwiacjaImgwMetar30m1h(icao)) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(new Date());
            url = calendar.get(12) < 30 ? "http://awiacja.imgw.pl/rss/metar00.php?airport=" : "http://awiacja.imgw.pl/rss/metar30.php?airport=";
        } else if (WeatherUtil.isAwiacjaImgwMetarMil(icao)) {
            url = "http://awiacja.imgw.pl/rss/metarmil.php?airport=";
        }
        if (url == null) {
            return null;
        }
        return WeatherUtil.getAwiacjaImgwMetar(url, icao);
    }

    private static String getAwiacjaImgwMetar(String url, String icao) {
        Report report;
        log.debug("getAwiacjaImgwMetar= " + url + ";" + icao);
        if (FlightPlanBean.getInstance().getAwiacjaImgwCache().containsKey(icao)) {
            log.debug("awiacjaImgwCache.containsKey(" + icao + ")");
            report = FlightPlanBean.getInstance().getAwiacjaImgwCache().get(icao);
            log.debug(Math.round((double)(System.nanoTime() - report.getCreationTime()) / 1000.0 / 1000.0 / 1000.0) + " < " + 30L);
            if ((System.nanoTime() - report.getCreationTime()) / 1000L / 1000L / 1000L < 30L) {
                log.debug("cache time not reached.");
                return report.getMetar();
            }
            log.debug("cache time reached. Removing object");
            FlightPlanBean.getInstance().getAwiacjaImgwCache().remove(icao);
        }
        report = new Report(WeatherUtil.readUrlAwiacjaImgwMetar(url, icao), null);
        report.setCreationTime(System.nanoTime());
        log.debug("Object created: " + report);
        FlightPlanBean.getInstance().getAwiacjaImgwCache().put(icao, report);
        return report.getMetar();
    }

    private static String readUrlAwiacjaImgwMetar(String url, String icao) {
        int pos;
        String body = UrlUtil.readUrl(url + icao);
        if (body != null && (pos = body.indexOf("METAR " + icao + " ")) >= 0 && (pos = (body = body.substring(pos)).indexOf("</description>")) >= 0) {
            return body.substring(0, pos).trim();
        }
        return null;
    }

    private static boolean isAwiacjaImgwMetar(String icao) {
        return WeatherUtil.isAwiacjaImgwMetar30m1h(icao) || WeatherUtil.isAwiacjaImgwMetarMil(icao);
    }

    private static boolean isAwiacjaImgwMetar30m1h(String icao) {
        return Arrays.asList(AWIACJA_IMGW_METAR_30m_1h).contains(icao);
    }

    private static boolean isAwiacjaImgwMetarMil(String icao) {
        return Arrays.asList(AWIACJA_IMGW_METAR_MIL).contains(icao);
    }

    public static BufferedImage getMeteo(GpsPlace place, String lang) {
        if (!"PL".equals(lang)) {
            lang = "EN".toLowerCase();
        }
        log.debug("getMeteo: " + place + "; " + lang);
        if (WeatherUtil.isMeteoAvailable(place)) {
            String url = "http://www.meteo.pl/um/php/mgram_search.php?NALL=" + place.getLat().getValue() + "&EALL=" + place.getLon().getValue() + "&lang=" + lang;
            String content = UrlUtil.readUrl(url);
            int pos = content.indexOf(METEO_ACT_X_SEARCH_STRING);
            if (pos < 0) {
                log.error("Couldn't find act_x position");
                return null;
            }
            content = content.substring(pos);
            String[] split = content.split(";");
            Integer act_x = null;
            try {
                act_x = Integer.parseInt(split[0].substring(METEO_ACT_X_SEARCH_STRING.length()));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse act_x= " + split[0], e);
                return null;
            }
            pos = content.indexOf(METEO_ACT_Y_SEARCH_STRING);
            if (pos < 0) {
                log.error("Couldn't find act_y position");
                return null;
            }
            content = content.substring(pos);
            split = content.split(";");
            Integer act_y = null;
            try {
                act_y = Integer.parseInt(split[0].substring(METEO_ACT_Y_SEARCH_STRING.length()));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse act_y= " + split[0], e);
                return null;
            }
            pos = content.indexOf(METEO_FCSTDATE_SEARCH_STRING);
            if (pos < 0) {
                log.error("Couldn't find fcstdate position");
                return null;
            }
            content = content.substring(pos);
            split = content.split("\";");
            String fcstdate = split[0].substring(METEO_FCSTDATE_SEARCH_STRING.length());
            pos = content.indexOf(METEO_NTYPE_SEARCH_STRING);
            if (pos < 0) {
                log.error("Couldn't find ntype position");
                return null;
            }
            content = content.substring(pos);
            split = content.split("\";");
            String ntype = split[0].substring(METEO_NTYPE_SEARCH_STRING.length());
            return UrlUtil.readImageFromUrl("http://www.meteo.pl/um/metco/mgram_pict.php?ntype=" + ntype + "&fdate=" + fcstdate + "&row=" + act_y + "&col=" + act_x + "&lang=" + lang);
        }
        return null;
    }

    public static boolean isMeteoAvailable(GpsPlace place) {
        return place.isInside(METEO_AREA);
    }

    public static List<String> stationsReportsToArrayString(List<Station> stations) {
        ArrayList<String> reports = new ArrayList<String>();
        for (Station st : stations) {
            Report report = st.getReport().clone();
            StringBuilder sb = new StringBuilder();
            sb.append(st.getName());
            sb.append("\n");
            if (report.getMetar() != null) {
                sb.append(report.getMetar());
                sb.append("\n");
            }
            if (report.getTaf() != null) {
                sb.append(report.getTaf());
                sb.append("\n");
            }
            reports.add(sb.toString());
        }
        return reports;
    }
}

