/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteAirportXml;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteAirspaceAreaXml;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteIfrPointXml;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteIfrRouteXml;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteNavaidXml;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteObstacleXml;
import main.java.guru.vfrflight.core.sql.entity.xml.DeleteVfrPointXml;
import main.java.guru.vfrflight.core.sql.entity.xml.VfrFlightXmlData;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.ObstacleFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.geo.DeclinationCalculator;
import org.apache.log4j.Logger;

public class XmlDataUtil {
    private static final Logger log = Logger.getLogger(XmlDataUtil.class);

    public static VfrFlightXmlData importXmlData(String filename) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{VfrFlightXmlData.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (VfrFlightXmlData)jaxbUnmarshaller.unmarshal(new File(filename));
        }
        catch (JAXBException e) {
            log.error("Couldn't import XML data", e);
            return null;
        }
    }

    public static boolean exportXmlData(String filename, VfrFlightXmlData data) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{VfrFlightXmlData.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)data, new File(filename));
            return true;
        }
        catch (JAXBException e) {
            log.error("Couldn't export XML data", e);
            return false;
        }
    }

    public static void exportDB(String filename, boolean includeDeleteTags, GpsArea area) {
        VfrFlightXmlData data = new VfrFlightXmlData();
        if (includeDeleteTags) {
            data.getDeleteAirport().add(new DeleteAirportXml(area));
            data.getDeleteNavaid().add(new DeleteNavaidXml(area));
            data.getDeleteObstacle().add(new DeleteObstacleXml(area));
            data.getDeleteAirspaceArea().add(new DeleteAirspaceAreaXml(area));
            data.getDeleteIfrPoint().add(new DeleteIfrPointXml(area));
            data.getDeleteVfrPoint().add(new DeleteVfrPointXml(area));
            data.getDeleteIfrRoute().add(new DeleteIfrRouteXml(area));
        }
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        data.setNavaids(navaidFacade.findNavaidsInArea(area, null, false));
        MapFacade mapFacade = new MapFacade(DBUtil.getDataSource());
        data.setAirports(mapFacade.findAirports(area, true));
        data.setObstacles(mapFacade.findObstacles(area));
        data.setAirspaceAreas(mapFacade.findAirspaces(area));
        data.setIfrPoints(mapFacade.findWaypoints(area));
        data.setVfrPoints(mapFacade.findVfrPoints(area));
        data.setIfrRoutes(mapFacade.findRoutes(area));
        XmlDataUtil.exportXmlData(filename, data);
    }

    public static void importDB(String filename, boolean truncateTable) {
        Double toLon;
        Double toLat;
        Double fromLon;
        Double fromLat;
        log.info("Loading XML db from file " + filename);
        VfrFlightXmlData data = XmlDataUtil.importXmlData(filename);
        ObstacleFacade obstacleFacade = new ObstacleFacade(DBUtil.getDataSource());
        IfrRouteFacade ifrRouteFacade = new IfrRouteFacade(DBUtil.getDataSource());
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        for (DeleteNavaidXml deleteNavaidXml : data.getDeleteNavaid()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteNavaidXml.getLatRange() != null) {
                fromLat = deleteNavaidXml.getLatRange().getFrom();
                toLat = deleteNavaidXml.getLatRange().getTo();
            }
            if (deleteNavaidXml.getLonRange() != null) {
                fromLon = deleteNavaidXml.getLonRange().getFrom();
                toLon = deleteNavaidXml.getLonRange().getTo();
            }
            navaidFacade.deleteNavaids(deleteNavaidXml.getIdent(), fromLat, fromLon, toLat, toLon);
        }
        for (DeleteObstacleXml deleteObstacleXml : data.getDeleteObstacle()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteObstacleXml.getLatRange() != null) {
                fromLat = deleteObstacleXml.getLatRange().getFrom();
                toLat = deleteObstacleXml.getLatRange().getTo();
            }
            if (deleteObstacleXml.getLonRange() != null) {
                fromLon = deleteObstacleXml.getLonRange().getFrom();
                toLon = deleteObstacleXml.getLonRange().getTo();
            }
            obstacleFacade.deleteObstacles(fromLat, fromLon, toLat, toLon);
        }
        for (DeleteVfrPointXml deleteVfrPointXml : data.getDeleteVfrPoint()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteVfrPointXml.getLatRange() != null) {
                fromLat = deleteVfrPointXml.getLatRange().getFrom();
                toLat = deleteVfrPointXml.getLatRange().getTo();
            }
            if (deleteVfrPointXml.getLonRange() != null) {
                fromLon = deleteVfrPointXml.getLonRange().getFrom();
                toLon = deleteVfrPointXml.getLonRange().getTo();
            }
            airportFacade.deleteVfrPoints(deleteVfrPointXml.getIdent(), fromLat, fromLon, toLat, toLon);
        }
        for (DeleteIfrPointXml deleteIfrPointXml : data.getDeleteIfrPoint()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteIfrPointXml.getLatRange() != null) {
                fromLat = deleteIfrPointXml.getLatRange().getFrom();
                toLat = deleteIfrPointXml.getLatRange().getTo();
            }
            if (deleteIfrPointXml.getLonRange() != null) {
                fromLon = deleteIfrPointXml.getLonRange().getFrom();
                toLon = deleteIfrPointXml.getLonRange().getTo();
            }
            ifrRouteFacade.deleteIfrPoints(deleteIfrPointXml.getIdent(), fromLat, fromLon, toLat, toLon);
        }
        for (DeleteIfrRouteXml deleteIfrRouteXml : data.getDeleteIfrRoute()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteIfrRouteXml.getLatRange() != null) {
                fromLat = deleteIfrRouteXml.getLatRange().getFrom();
                toLat = deleteIfrRouteXml.getLatRange().getTo();
            }
            if (deleteIfrRouteXml.getLonRange() != null) {
                fromLon = deleteIfrRouteXml.getLonRange().getFrom();
                toLon = deleteIfrRouteXml.getLonRange().getTo();
            }
            ifrRouteFacade.deleteIfrRoutes(MapFrame.getInstance().getMapViewer(), deleteIfrRouteXml.getName(), fromLat, fromLon, toLat, toLon);
        }
        for (DeleteAirspaceAreaXml deleteAirspaceAreaXml : data.getDeleteAirspaceArea()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteAirspaceAreaXml.getLatRange() != null) {
                fromLat = deleteAirspaceAreaXml.getLatRange().getFrom();
                toLat = deleteAirspaceAreaXml.getLatRange().getTo();
            }
            if (deleteAirspaceAreaXml.getLonRange() != null) {
                fromLon = deleteAirspaceAreaXml.getLonRange().getFrom();
                toLon = deleteAirspaceAreaXml.getLonRange().getTo();
            }
            airspaceFacade.deleteAirspaceAreas(MapFrame.getInstance().getMapViewer(), deleteAirspaceAreaXml.getName(), deleteAirspaceAreaXml.getType(), fromLat, fromLon, toLat, toLon);
        }
        for (DeleteAirportXml deleteAirportXml : data.getDeleteAirport()) {
            fromLat = null;
            fromLon = null;
            toLat = null;
            toLon = null;
            if (deleteAirportXml.getLatRange() != null) {
                fromLat = deleteAirportXml.getLatRange().getFrom();
                toLat = deleteAirportXml.getLatRange().getTo();
            }
            if (deleteAirportXml.getLonRange() != null) {
                fromLon = deleteAirportXml.getLonRange().getFrom();
                toLon = deleteAirportXml.getLonRange().getTo();
            }
            airportFacade.deleteAirports(deleteAirportXml.getIdent(), fromLat, fromLon, toLat, toLon);
        }
        DeclinationCalculator declCalc = SettingsBean.getInstance().getDeclinationCalculator();
        if (data.getObstaclesCount() > 0) {
            obstacleFacade.insertObstacles(data.getObstacles(), truncateTable);
        }
        if (data.getIfrPointsCount() > 0) {
            ifrRouteFacade.insertIfrPoints(data.getIfrPoints(), truncateTable);
        }
        if (data.getIfrRoutesCount() > 0) {
            ifrRouteFacade.insertIfrRoutes(data.getIfrRoutes(), truncateTable);
        }
        if (data.getNavaidsCount() > 0) {
            ArrayList<Navaid> arrayList = new ArrayList<Navaid>(data.getNavaidsCount());
            for (Navaid n : data.getNavaids()) {
                if (n.getMagvar() == null) {
                    n.setMagvar(declCalc.getMagneticDeclination(n.getGpsPlace()));
                }
                arrayList.add(n);
            }
            navaidFacade.insertNavaids(arrayList, truncateTable);
        }
        if (data.getVfrPointsCount() > 0) {
            airportFacade.insertVfrPoints(data.getVfrPoints(), truncateTable);
        }
        if (data.getAirspaceAreasCount() > 0) {
            airspaceFacade.insertAirspaces(data.getAirspaceAreas(), truncateTable);
        }
        if (data.getAirportsCount() > 0) {
            airportFacade.insertAirports(data.getAirports(), truncateTable);
        }
        log.info("Done.");
    }

    public static void importDB(String outputFolder, String archiveName, String filename) {
        try {
            IOUtil.unZipFile(archiveName, outputFolder);
        }
        catch (IOException e) {
            log.error(e, e);
        }
        if (new File(filename).exists()) {
            XmlDataUtil.importDB(filename, true);
            IOUtil.deleteFile(filename);
        } else {
            log.error("Couldn't find db file " + filename);
        }
    }
}

