/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.osm;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.sql.entity.City;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.xml.osm.query.Osm;
import org.apache.log4j.Logger;

public class OsmQueryUtil {
    private static final Logger log = Logger.getLogger(OsmQueryUtil.class);

    public static void importCities(String file, boolean truncateTable) {
        CityFacade cityFacade = new CityFacade(DBUtil.getDataSource());
        cityFacade.insertCities(OsmQueryUtil.loadCities(file), truncateTable);
    }

    public static Set<City> loadCities(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Osm.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Osm xml = (Osm)jaxbUnmarshaller.unmarshal(new File(file));
            return OsmQueryUtil.getCitiesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static Set<City> getCitiesFromXml(Osm xml) {
        HashSet<City> cities = new HashSet<City>();
        if (xml != null) {
            for (Osm.Node xn : xml.getNode()) {
                try {
                    City c = new City();
                    c.setLat((double)xn.getLat());
                    c.setLon((double)xn.getLon());
                    for (Osm.Node.Tag t : xn.getTag()) {
                        if ("name".equals(t.getK())) {
                            c.setName(t.getV());
                            continue;
                        }
                        if ("name:en".equals(t.getK())) {
                            c.setAltName(t.getV());
                            continue;
                        }
                        if (!"population".equals(t.getK())) continue;
                        c.setSize((short)Math.floor(Double.valueOf(t.getV().replaceAll(",", "").replaceAll(" ", "")) / 10000.0));
                    }
                    if (OsmQueryUtil.validateCity(c)) {
                        cities.add(c);
                        continue;
                    }
                    log.error("Invalid city: " + c);
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
        }
        return cities;
    }

    private static boolean validateCity(City o) {
        return o.getLat() != null && o.getLon() != null && o.getName() != null;
    }

    public static void batchImportCities(String path) {
        log.info("Starting batch import: " + path);
        Set<DiskObject> results = SearchUtil.getRootList("*.xml", path);
        for (DiskObject d : results) {
            OsmQueryUtil.importCities(path + d.getPath(), false);
        }
        log.info("FINISHED batch import.");
    }

    public static void importWorld(String type) {
        for (int lat = -90; lat < 90; lat += 5) {
            for (int lon = -180; lon < 180; lon += 5) {
                String url = "http://www.overpass-api.de/api/xapi?node[bbox=" + lon + "," + lat + "," + (lon + 5) + "," + (lat + 5) + "][place=" + type + "]";
                String target = "tmp/" + lat + "_" + lon + ".xml";
                if (new File(target).exists()) continue;
                log.info("Downloading " + target);
                try {
                    IOUtil.downloadFile(url, target);
                    continue;
                }
                catch (IOException e) {
                    log.error(e, e);
                }
            }
        }
    }
}

