/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.openair;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.util.DBUtil;
import org.apache.log4j.Logger;

public class OpenAirAirspacesUtil {
    private static final Logger log = Logger.getLogger(OpenAirAirspacesUtil.class);
    private static final Map<String, AirspaceType> TYPE_MAPPINGS;

    public static void importAirspaces(String file, boolean truncateTable) {
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        airspaceFacade.insertAirspaces(OpenAirAirspacesUtil.loadAirspaces(file), truncateTable);
    }

    /*
     * Exception decompiling
     */
    private static List<AirspaceArea> loadAirspaces(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static AirspaceAreaVertex getAirspaceVertex(String line) {
        String vertex = line.substring(3).trim();
        String[] tokens = vertex.split(" ");
        if (tokens.length == 4) {
            GpsCoord lat = OpenAirAirspacesUtil.parseCoord(tokens[0]);
            GpsCoord lon = OpenAirAirspacesUtil.parseCoord(tokens[2]);
            if (lat != null && lon != null) {
                GpsPlace p = new GpsPlace(lat, lon);
                p.setLatHemisphere(tokens[1]);
                p.setLonHemisphere(tokens[3]);
                return new AirspaceAreaVertex(p);
            }
        } else {
            log.error("Invalid number of tokens: " + line);
        }
        return null;
    }

    private static GpsCoord parseCoord(String string) throws NumberFormatException {
        String[] tokens = string.split(":");
        if (tokens.length == 3) {
            int deg = Integer.valueOf(tokens[0]);
            int min = Integer.valueOf(tokens[1]);
            double sec = Double.valueOf(tokens[2]);
            return new GpsCoord(deg, min, sec);
        }
        log.error("Invalid number of tokens: " + string);
        return null;
    }

    private static AltitudeType getAltitudeType(String line) throws IllegalArgumentException {
        String alt = line.substring(3).trim();
        if ("gnd".equalsIgnoreCase(alt)) {
            return AltitudeType.GND;
        }
        String[] tokens = alt.split(" ");
        if (alt.startsWith("FL")) {
            return AltitudeType.STD;
        }
        if (tokens[0].endsWith("ft")) {
            return AltitudeType.MSL;
        }
        log.error("Error parsing altitude type: " + line);
        return null;
    }

    private static Integer getAltitude(String line) throws NumberFormatException {
        String alt = line.substring(3).trim();
        if ("gnd".equalsIgnoreCase(alt)) {
            return 0;
        }
        String[] tokens = alt.split(" ");
        if (alt.startsWith("FL")) {
            return Integer.valueOf(tokens[1]) * 100;
        }
        if (tokens[0].endsWith("ft")) {
            return Integer.valueOf(tokens[0].substring(0, tokens[0].length() - 2));
        }
        log.error("Error parsing altitude: " + line);
        return null;
    }

    private static String readStreamUntilPrefix(BufferedReader br, String prefix) throws IOException {
        String line = null;
        while (!(line = br.readLine()).startsWith(prefix)) {
        }
        return line;
    }

    private static AirspaceType getAirspaceType(String line) throws IllegalArgumentException {
        String type = line.substring(3).trim();
        if (TYPE_MAPPINGS.get(type) != null) {
            return TYPE_MAPPINGS.get(type);
        }
        return AirspaceType.valueOf(type);
    }

    private static String getAirspaceName(String line) {
        return line.substring(3).trim();
    }

    private static boolean validateAirspace(AirspaceArea ar) {
        if (ar.isPoly() && ar.getVertices().size() == 0) {
            return false;
        }
        if (ar.isCircle() && ar.getRadius() == null) {
            return false;
        }
        return ar.getType() != null;
    }

    static {
        HashMap<String, AirspaceType> mp = new HashMap<String, AirspaceType>();
        mp.put("A", AirspaceType.CLASS_A);
        mp.put("B", AirspaceType.CLASS_B);
        mp.put("C", AirspaceType.CLASS_C);
        mp.put("D", AirspaceType.CLASS_D);
        mp.put("E", AirspaceType.CLASS_E);
        mp.put("F", AirspaceType.CLASS_F);
        mp.put("G", AirspaceType.CLASS_G);
        mp.put("P", AirspaceType.PROHIBITED);
        mp.put("R", AirspaceType.RESTRICTED);
        mp.put("Q", AirspaceType.DANGER);
        mp.put("W", AirspaceType.GLDR);
        mp.put("GP", AirspaceType.HPGLDR);
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

