/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.metar;

import java.util.Calendar;
import java.util.TimeZone;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.metar.Clouds;
import main.java.guru.vfrflight.util.metar.CloudsType;
import main.java.guru.vfrflight.util.metar.MetarData;
import org.apache.log4j.Logger;

public class MetarDecoderUtil {
    private static final Logger log = Logger.getLogger(MetarDecoderUtil.class);

    public static MetarData decodeMetar(String metar) {
        if (metar == null) {
            return null;
        }
        String[] parts = metar.split(" ");
        if (parts.length == 0) {
            return null;
        }
        MetarData data = new MetarData();
        for (String part : parts) {
            if (!(MetarDecoderUtil.isTokenWindInformation(part) ? !MetarDecoderUtil.parseWindToken(part, data) : (MetarDecoderUtil.isTokenVariableWindInformation(part) ? !MetarDecoderUtil.parseVariableWindToken(part, data) : (MetarDecoderUtil.isTokenVisibilityInformation(part) ? !MetarDecoderUtil.parseVisibilityToken(part, data) : (MetarDecoderUtil.isTokenCloudsInformation(part) ? !MetarDecoderUtil.parseCloudsToken(part, data) : MetarDecoderUtil.isTokenTimeInformation(part) && !MetarDecoderUtil.parseTimeInformationToken(part, data)))))) continue;
            return null;
        }
        if (data.getClouds().size() > 0) {
            for (Clouds c : data.getClouds()) {
                if (!CloudsType.BKN.equals((Object)c.getType()) && !CloudsType.OVC.equals((Object)c.getType())) continue;
                data.setCloudBase((double)c.getAltitude() * 100.0);
                break;
            }
        }
        log.debug("decodeMetar: " + metar + "; result: " + data);
        return data;
    }

    public static String addMetarKeyword(String metar) {
        if (metar != null && !metar.startsWith("METAR")) {
            metar = "METAR " + metar;
        }
        return metar;
    }

    private static boolean parseTimeInformationToken(String token, MetarData data) {
        String origToken = token = token.trim();
        try {
            data.setIssueDay(Integer.valueOf(token.substring(0, 2)));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse day " + origToken + ": " + e, e);
            return false;
        }
        try {
            data.setIssueHour(Integer.valueOf(token.substring(2, 4)));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse hour " + origToken + ": " + e, e);
            return false;
        }
        try {
            data.setIssueMin(Integer.valueOf(token.substring(4, 6)));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse minutes " + origToken + ": " + e, e);
            return false;
        }
        return true;
    }

    private static boolean parseVisibilityToken(String token, MetarData data) {
        String origToken = token = token.trim();
        if (token.matches("^([0-9]{4})$")) {
            try {
                data.setVisibility(Double.parseDouble(token));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse visibility " + origToken + ": " + e, e);
                return false;
            }
        }
        try {
            double visSm = Double.parseDouble(token.substring(0, token.length() - 2));
            data.setVisibility(UnitUtil.recalculateDistance(visSm, "sm", "m", false));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse visibility [SM] " + origToken + ": " + e, e);
            return false;
        }
        return true;
    }

    private static boolean parseVariableWindToken(String token, MetarData data) {
        String origToken = token = token.trim();
        try {
            data.setMinimumDirection(Short.valueOf(token.substring(0, 3)));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse wind minimum direction " + origToken + ": " + e, e);
            return false;
        }
        token = token.substring(4);
        try {
            data.setMaximumDirection(Short.valueOf(token.substring(0, 3)));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse wind maximum direction " + origToken + ": " + e, e);
            return false;
        }
        data.setVariable(true);
        return true;
    }

    private static boolean parseWindToken(String token, MetarData data) {
        String origToken = token = token.trim();
        if (token.startsWith("VRB")) {
            data.setVariable(true);
        } else {
            try {
                data.setDirection(Short.valueOf(token.substring(0, 3)));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse wind direction " + origToken + ": " + e, e);
                return false;
            }
        }
        token = token.substring(3);
        Double speed = null;
        try {
            speed = Double.valueOf(token.substring(0, 2));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse wind speed " + origToken + ": " + e, e);
            return false;
        }
        token = token.substring(2);
        Double gusts = null;
        if (token.charAt(0) == 'G') {
            try {
                gusts = Double.valueOf(token.substring(1, 3));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse wind gusts " + origToken + ": " + e, e);
                return false;
            }
            token = token.substring(3);
        }
        if ("MPS".equals(token)) {
            if (speed != null) {
                speed = UnitUtil.recalculateWindSpeed(speed, "m/s", "kt", false);
            }
            if (gusts != null) {
                gusts = UnitUtil.recalculateWindSpeed(gusts, "m/s", "kt", false);
            }
        } else if (!"KT".equals(token)) {
            log.error("Couldn't parse wind unit " + origToken);
            return false;
        }
        data.setSpeed(speed);
        data.setGusts(gusts);
        return true;
    }

    private static boolean parseCloudsToken(String token, MetarData data) {
        String origToken = token = token.trim();
        Clouds clouds = new Clouds();
        try {
            clouds.setType(CloudsType.valueOf(token.substring(0, 3)));
        }
        catch (IllegalArgumentException e) {
            log.error("Couldn't parse clouds type " + origToken);
            return false;
        }
        try {
            clouds.setAltitude(Short.parseShort(token.substring(3, 6)));
        }
        catch (NumberFormatException e) {
            log.error("Couldn't parse clouds altitude " + origToken + ": " + e, e);
            return false;
        }
        data.getClouds().add(clouds);
        return true;
    }

    public static boolean isTokenCloudsInformation(String token) {
        if (token == null) {
            return false;
        }
        return token.matches("^((SCT|FEW|BKN|OVC)[0-9]{3})$");
    }

    public static boolean isTokenVisibilityInformation(String token) {
        if (token == null) {
            return false;
        }
        return token.matches("^([0-9]{4})$") || token.matches("^([0-9]{1,2}(SM){1})$");
    }

    public static boolean isTokenWindInformation(String token) {
        if (token == null) {
            return false;
        }
        return token.matches("^([0-9]{5}[G]*[0-9]{0,2}(KT|MPS))$") || token.matches("^((VRB){1}[0-9]{2}[G]*[0-9]{0,2}(KT|MPS))$");
    }

    public static boolean isTokenVariableWindInformation(String token) {
        if (token == null) {
            return false;
        }
        return token.matches("^([0-9]{3}[V]{1}[0-9]{3})$");
    }

    public static boolean isTokenTimeInformation(String token) {
        if (token == null) {
            return false;
        }
        return token.matches("^([0-9]{6}[Z]{1})$");
    }

    public static boolean isWithinHourRange(MetarData data, Calendar cal, int numHours) {
        int metarMinutesToMidnight;
        int metarMinutesFromMidnight;
        if (data.getIssueDay() == null || data.getIssueHour() == null || data.getIssueMin() == null) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        now.setTimeZone(TimeZone.getTimeZone("UTC"));
        now.setTimeInMillis(cal.getTimeInMillis());
        int currentDayOfMonth = now.get(5);
        int currentMinutesFromMidnight = now.get(11) * 60 + now.get(12);
        Calendar yesterday = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        yesterday.setTimeInMillis(now.getTimeInMillis() - 86400000L);
        int yesterdaysDayOfMonth = yesterday.get(5);
        return currentDayOfMonth == data.getIssueDay() ? currentMinutesFromMidnight - (metarMinutesFromMidnight = data.getIssueHour() * 60 + data.getIssueMin()) <= numHours * 60 : yesterdaysDayOfMonth == data.getIssueDay() && (metarMinutesToMidnight = 1440 - (data.getIssueHour() * 60 + data.getIssueMin())) + currentMinutesFromMidnight <= numHours * 60;
    }
}

