/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.metar;

import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import main.java.guru.vfrflight.util.metar.Clouds;
import main.java.guru.vfrflight.util.metar.MetarDecoderUtil;

public class MetarData {
    private Short minimumDirection;
    private Short direction;
    private Short maximumDirection;
    private boolean variable = false;
    private Double speed;
    private Double gusts;
    private Double visibility;
    private Set<Clouds> clouds;
    private Double cloudBase;
    private Integer issueDay;
    private Integer issueHour;
    private Integer issueMin;

    public Short getMinimumDirection() {
        return this.minimumDirection;
    }

    public void setMinimumDirection(Short minimumDirection) {
        this.minimumDirection = minimumDirection;
    }

    public Short getDirection() {
        return this.direction;
    }

    public void setDirection(Short direction) {
        this.direction = direction;
    }

    public Short getMaximumDirection() {
        return this.maximumDirection;
    }

    public void setMaximumDirection(Short maximumDirection) {
        this.maximumDirection = maximumDirection;
    }

    public boolean isVariable() {
        return this.variable;
    }

    public void setVariable(boolean variable) {
        this.variable = variable;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getGusts() {
        return this.gusts;
    }

    public void setGusts(Double gusts) {
        this.gusts = gusts;
    }

    public boolean isGusts() {
        return this.gusts != null;
    }

    public Double getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Double visibility) {
        this.visibility = visibility;
    }

    public Set<Clouds> getClouds() {
        if (this.clouds == null) {
            this.clouds = new TreeSet<Clouds>();
        }
        return this.clouds;
    }

    public void setClouds(Set<Clouds> clouds) {
        this.clouds = clouds;
    }

    public Integer getIssueDay() {
        return this.issueDay;
    }

    public void setIssueDay(Integer issueDay) {
        this.issueDay = issueDay;
    }

    public Integer getIssueHour() {
        return this.issueHour;
    }

    public void setIssueHour(Integer issueHour) {
        this.issueHour = issueHour;
    }

    public Integer getIssueMin() {
        return this.issueMin;
    }

    public void setIssueMin(Integer issueMin) {
        this.issueMin = issueMin;
    }

    public boolean isWithinHourRange(int numHours) {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return MetarDecoderUtil.isWithinHourRange(this, now, numHours);
    }

    public Double getCloudBase() {
        return this.cloudBase;
    }

    public void setCloudBase(Double cloudBase) {
        this.cloudBase = cloudBase;
    }

    public boolean isImc() {
        if (this.getCloudBase() != null && this.getCloudBase() <= 1000.0) {
            return true;
        }
        return this.getVisibility() != null && !(this.getVisibility() >= 5000.0);
    }

    public boolean isVfr() {
        return !this.isImc();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetarData [minimumDirection=");
        builder.append(this.minimumDirection);
        builder.append(", direction=");
        builder.append(this.direction);
        builder.append(", maximumDirection=");
        builder.append(this.maximumDirection);
        builder.append(", variable=");
        builder.append(this.variable);
        builder.append(", speed=");
        builder.append(this.speed);
        builder.append(", gusts=");
        builder.append(this.gusts);
        builder.append(", cloudBase=");
        builder.append(this.cloudBase);
        builder.append(", visibility=");
        builder.append(this.visibility);
        builder.append(", issueDay=");
        builder.append(this.issueDay);
        builder.append(", issueHour=");
        builder.append(this.issueHour);
        builder.append(", issueMin=");
        builder.append(this.issueMin);
        builder.append("]");
        return builder.toString();
    }
}

