/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.geo;

import main.java.guru.vfrflight.util.geo.WmmCoeff;
import org.apache.log4j.Logger;

public class GeomagneticField {
    private static final Logger log = Logger.getLogger(GeomagneticField.class);
    private float mX;
    private float mY;
    private float mZ;
    private float mGcLatitudeRad;
    private float mGcLongitudeRad;
    private float mGcRadiusKm;
    private WmmCoeff wmmCoeff;
    private static final float EARTH_SEMI_MAJOR_AXIS_KM = 6378.137f;
    private static final float EARTH_SEMI_MINOR_AXIS_KM = 6356.7524f;
    private static final float EARTH_REFERENCE_RADIUS_KM = 6371.2f;
    private final float[][] SCHMIDT_QUASI_NORM_FACTORS;

    public GeomagneticField(WmmCoeff wmmCoeff) {
        this.wmmCoeff = wmmCoeff;
        if (wmmCoeff.getGCoeff().length == wmmCoeff.getHCoeff().length) {
            this.SCHMIDT_QUASI_NORM_FACTORS = this.computeSchmidtQuasiNormFactors(wmmCoeff.getGCoeff().length);
        } else {
            this.SCHMIDT_QUASI_NORM_FACTORS = null;
            log.fatal("Assertion failure: SCHMIDT_QUASI_NORM_FACTORS");
        }
    }

    public void calculate(float gdLatitudeDeg, float gdLongitudeDeg, float altitudeMeters, long timeMillis) {
        int MAX_N = this.wmmCoeff.getGCoeff().length;
        gdLatitudeDeg = Math.min(89.99999f, Math.max(-89.99999f, gdLatitudeDeg));
        this.computeGeocentricCoordinates(gdLatitudeDeg, gdLongitudeDeg, altitudeMeters);
        LegendreTable legendre = new LegendreTable(MAX_N - 1, (float)(1.5707963267948966 - (double)this.mGcLatitudeRad));
        float[] relativeRadiusPower = new float[MAX_N + 2];
        relativeRadiusPower[0] = 1.0f;
        relativeRadiusPower[1] = 6371.2f / this.mGcRadiusKm;
        for (int i = 2; i < relativeRadiusPower.length; ++i) {
            relativeRadiusPower[i] = relativeRadiusPower[i - 1] * relativeRadiusPower[1];
        }
        float[] sinMLon = new float[MAX_N];
        float[] cosMLon = new float[MAX_N];
        sinMLon[0] = 0.0f;
        cosMLon[0] = 1.0f;
        sinMLon[1] = (float)Math.sin(this.mGcLongitudeRad);
        cosMLon[1] = (float)Math.cos(this.mGcLongitudeRad);
        for (int m = 2; m < MAX_N; ++m) {
            int x = m >> 1;
            sinMLon[m] = sinMLon[m - x] * cosMLon[x] + cosMLon[m - x] * sinMLon[x];
            cosMLon[m] = cosMLon[m - x] * cosMLon[x] - sinMLon[m - x] * sinMLon[x];
        }
        float inverseCosLatitude = 1.0f / (float)Math.cos(this.mGcLatitudeRad);
        float yearsSinceBase = (float)(timeMillis - this.wmmCoeff.getBaseTime()) / 3.1536E10f;
        float gcX = 0.0f;
        float gcY = 0.0f;
        float gcZ = 0.0f;
        for (int n = 1; n < MAX_N; ++n) {
            for (int m = 0; m <= n; ++m) {
                float g = this.wmmCoeff.getGCoeff()[n][m] + yearsSinceBase * this.wmmCoeff.getDeltaG()[n][m];
                float h = this.wmmCoeff.getHCoeff()[n][m] + yearsSinceBase * this.wmmCoeff.getDeltaH()[n][m];
                gcX += relativeRadiusPower[n + 2] * (g * cosMLon[m] + h * sinMLon[m]) * legendre.mPDeriv[n][m] * this.SCHMIDT_QUASI_NORM_FACTORS[n][m];
                gcY += relativeRadiusPower[n + 2] * (float)m * (g * sinMLon[m] - h * cosMLon[m]) * legendre.mP[n][m] * this.SCHMIDT_QUASI_NORM_FACTORS[n][m] * inverseCosLatitude;
                gcZ -= (float)(n + 1) * relativeRadiusPower[n + 2] * (g * cosMLon[m] + h * sinMLon[m]) * legendre.mP[n][m] * this.SCHMIDT_QUASI_NORM_FACTORS[n][m];
            }
        }
        double latDiffRad = Math.toRadians(gdLatitudeDeg) - (double)this.mGcLatitudeRad;
        this.mX = (float)((double)gcX * Math.cos(latDiffRad) + (double)gcZ * Math.sin(latDiffRad));
        this.mY = gcY;
        this.mZ = (float)((double)(-gcX) * Math.sin(latDiffRad) + (double)gcZ * Math.cos(latDiffRad));
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getZ() {
        return this.mZ;
    }

    public float getDeclination() {
        return (float)Math.toDegrees(Math.atan2(this.mY, this.mX));
    }

    public float getInclination() {
        return (float)Math.toDegrees(Math.atan2(this.mZ, this.getHorizontalStrength()));
    }

    public float getHorizontalStrength() {
        return (float)Math.sqrt(this.mX * this.mX + this.mY * this.mY);
    }

    public float getFieldStrength() {
        return (float)Math.sqrt(this.mX * this.mX + this.mY * this.mY + this.mZ * this.mZ);
    }

    private void computeGeocentricCoordinates(float gdLatitudeDeg, float gdLongitudeDeg, float altitudeMeters) {
        float altitudeKm = altitudeMeters / 1000.0f;
        float a2 = 4.0680636E7f;
        float b2 = 4.04083E7f;
        double gdLatRad = Math.toRadians(gdLatitudeDeg);
        float clat = (float)Math.cos(gdLatRad);
        float slat = (float)Math.sin(gdLatRad);
        float tlat = slat / clat;
        float latRad = (float)Math.sqrt(a2 * clat * clat + b2 * slat * slat);
        this.mGcLatitudeRad = (float)Math.atan(tlat * (latRad * altitudeKm + b2) / (latRad * altitudeKm + a2));
        this.mGcLongitudeRad = (float)Math.toRadians(gdLongitudeDeg);
        float radSq = altitudeKm * altitudeKm + 2.0f * altitudeKm * (float)Math.sqrt(a2 * clat * clat + b2 * slat * slat) + (a2 * a2 * clat * clat + b2 * b2 * slat * slat) / (a2 * clat * clat + b2 * slat * slat);
        this.mGcRadiusKm = (float)Math.sqrt(radSq);
    }

    private float[][] computeSchmidtQuasiNormFactors(int maxN) {
        float[][] schmidtQuasiNorm = new float[maxN + 1][];
        schmidtQuasiNorm[0] = new float[]{1.0f};
        for (int n = 1; n <= maxN; ++n) {
            schmidtQuasiNorm[n] = new float[n + 1];
            schmidtQuasiNorm[n][0] = schmidtQuasiNorm[n - 1][0] * (float)(2 * n - 1) / (float)n;
            for (int m = 1; m <= n; ++m) {
                schmidtQuasiNorm[n][m] = schmidtQuasiNorm[n][m - 1] * (float)Math.sqrt((float)((n - m + 1) * (m == 1 ? 2 : 1)) / (float)(n + m));
            }
        }
        return schmidtQuasiNorm;
    }

    private class LegendreTable {
        public final float[][] mP;
        public final float[][] mPDeriv;

        public LegendreTable(int maxN, float thetaRad) {
            float cos = (float)Math.cos(thetaRad);
            float sin = (float)Math.sin(thetaRad);
            this.mP = new float[maxN + 1][];
            this.mPDeriv = new float[maxN + 1][];
            this.mP[0] = new float[]{1.0f};
            this.mPDeriv[0] = new float[]{0.0f};
            for (int n = 1; n <= maxN; ++n) {
                this.mP[n] = new float[n + 1];
                this.mPDeriv[n] = new float[n + 1];
                for (int m = 0; m <= n; ++m) {
                    if (n == m) {
                        this.mP[n][m] = sin * this.mP[n - 1][m - 1];
                        this.mPDeriv[n][m] = cos * this.mP[n - 1][m - 1] + sin * this.mPDeriv[n - 1][m - 1];
                        continue;
                    }
                    if (n == 1 || m == n - 1) {
                        this.mP[n][m] = cos * this.mP[n - 1][m];
                        this.mPDeriv[n][m] = -sin * this.mP[n - 1][m] + cos * this.mPDeriv[n - 1][m];
                        continue;
                    }
                    if (n > 1 && m < n - 1) {
                        float k = (float)((n - 1) * (n - 1) - m * m) / (float)((2 * n - 1) * (2 * n - 3));
                        this.mP[n][m] = cos * this.mP[n - 1][m] - k * this.mP[n - 2][m];
                        this.mPDeriv[n][m] = -sin * this.mP[n - 1][m] + cos * this.mPDeriv[n - 1][m] - k * this.mPDeriv[n - 2][m];
                        continue;
                    }
                    log.fatal("Assertion failure: n > 1 && m < n - 1");
                }
            }
        }
    }
}

