/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.downloader;

import com.google.common.cache.Cache;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.CacheUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.downloader.ImgTile;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.apache.log4j.Logger;

public class StaticMapDownloader {
    private static final Logger log = Logger.getLogger(StaticMapDownloader.class);
    private JXMapViewer map;
    private Graphics g;
    private int zoom;
    private Rectangle viewportBounds;
    private Set<ImgTile> tiles = new HashSet<ImgTile>();
    private int threadPoolSize = 6;
    private ExecutorService service;
    private BlockingQueue<ImgTile> tileQueue = new ArrayBlockingQueue<ImgTile>(this.threadPoolSize * 2);

    public StaticMapDownloader(JXMapViewer map, Graphics g, int zoom, Rectangle viewportBounds) {
        this.map = map;
        this.g = g;
        this.zoom = zoom;
        this.viewportBounds = viewportBounds;
    }

    public boolean isRunning() {
        if (this.tiles.size() == 0) {
            return true;
        }
        for (ImgTile tile : this.tiles) {
            if (tile.isLoaded()) continue;
            return true;
        }
        return false;
    }

    public void execute() {
        log.debug("STARTING static map download: " + this.viewportBounds + " @ zoom " + this.zoom);
        int size = this.map.getTileFactory().getTileSize(this.zoom);
        int numWide = this.viewportBounds.width / size + 2;
        int numHigh = this.viewportBounds.height / size + 2;
        TileFactoryInfo info = this.map.getTileFactory().getInfo();
        int tpx = (int)Math.floor(this.viewportBounds.getX() / (double)info.getTileSize(this.zoom));
        int tpy = (int)Math.floor(this.viewportBounds.getY() / (double)info.getTileSize(this.zoom));
        int total = (numWide + 1) * (numHigh + 1);
        log.debug("drawStaticMapTiles: total to load: " + total);
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                int ox = itpx * this.map.getTileFactory().getTileSize(this.zoom) - this.viewportBounds.x;
                int oy = itpy * this.map.getTileFactory().getTileSize(this.zoom) - this.viewportBounds.y;
                String[] url = info.getTileUrl(itpx, itpy, this.zoom);
                this.tiles.add(new ImgTile(url[0], ox, oy));
            }
        }
        int i = 0;
        for (ImgTile tile : this.tiles) {
            this.startLoading(tile);
            log.trace(this.tiles.size() - ++i);
        }
        if (this.service != null) {
            this.service.shutdown();
        }
        log.debug("FINISHED static map download.");
    }

    private synchronized void startLoading(ImgTile tile) {
        if (tile.isLoading()) {
            log.debug(tile.getUrl() + ": already loading. bailing");
            return;
        }
        tile.setLoading(true);
        try {
            this.tileQueue.put(tile);
            this.getService().submit(new TileRunner());
        }
        catch (Exception e) {
            log.error(e, e);
        }
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "tile-pool-" + this.count++);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    private void finishedDownloading(ImgTile tile) {
        this.g.drawImage(tile.getImg().get(), tile.getPixelX(), tile.getPixelY(), null);
    }

    private class TileRunner
    implements Runnable {
        private TileRunner() {
        }

        @Override
        public void run() {
            ImgTile tile = (ImgTile)StaticMapDownloader.this.tileQueue.remove();
            Cache<String, BufferedImage> cache = MapFrame.getInstance().getMapViewer().getTilesCache();
            String urlHash = CacheUtil.getUrlHash(tile.getUrl());
            int trys = 3;
            while (!tile.isLoaded() && trys > 0) {
                try {
                    BufferedImage img = (BufferedImage)cache.asMap().get(urlHash);
                    if (img == null) {
                        img = UrlUtil.readImageFromUrl(tile.getUrl(), true);
                        cache.asMap().put(urlHash, img);
                    }
                    if (img == null) {
                        --trys;
                        continue;
                    }
                    tile.setImg(new SoftReference<BufferedImage>(img));
                    tile.setLoaded(true);
                    StaticMapDownloader.this.finishedDownloading(tile);
                }
                catch (Exception e) {
                    if (trys == 0) {
                        log.debug("Failed to load a tile at url: " + tile.getUrl() + ", stopping", e);
                        continue;
                    }
                    log.trace("Failed to load a tile at url: " + tile.getUrl() + ", retrying", e);
                    --trys;
                }
            }
            tile.setLoading(false);
        }
    }
}

