/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.downloader;

import com.google.common.cache.Cache;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.ConsoleDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.CacheUtil;
import main.java.guru.vfrflight.util.StaticMapUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.downloader.BulkFile;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.apache.log4j.Logger;

public class MapBulkDownloader {
    private static final Logger log = Logger.getLogger(MapBulkDownloader.class);
    private JXMapViewer map;
    private String destinationPath;
    private ConsoleDialog consoleDialog;
    private StoppableTask mainTask;
    private int threadPoolSize = 4;
    private ExecutorService service;
    private boolean running = false;
    private boolean withRandomDelay = false;
    private BlockingQueue<BulkFile> fileQueue = new ArrayBlockingQueue<BulkFile>(this.threadPoolSize * 2);

    public MapBulkDownloader(StoppableTask mainTask, JXMapViewer map, String destinationPath, boolean withRandomDelay, ConsoleDialog consoleDialog) {
        this.mainTask = mainTask;
        this.map = map;
        this.destinationPath = destinationPath;
        this.withRandomDelay = withRandomDelay;
        this.consoleDialog = consoleDialog;
    }

    public void execute(GpsArea region, int zoomMin, int zoomMax) {
        this.consoleDialog.write("STARTING bulk map download. zoom ranges " + zoomMin + " to " + zoomMax);
        this.running = true;
        for (int zoom = zoomMin; zoom <= zoomMax; ++zoom) {
            this.consoleDialog.write("Downloading tiles @ zoom " + zoom);
            File dir = new File(this.destinationPath + "/" + zoom);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Point2D centerPt = this.map.getTileFactory().geoToPixel(region.getCenter().geoPosition(), zoom);
            Point2D topLeftPt = this.map.getTileFactory().geoToPixel(region.getTopLeft().geoPosition(), zoom);
            Point2D bottomRightPt = this.map.getTileFactory().geoToPixel(region.getBottomRight().geoPosition(), zoom);
            int width = (int)Math.round(bottomRightPt.getX() - topLeftPt.getX());
            int height = (int)Math.round(bottomRightPt.getY() - topLeftPt.getY());
            this.downloadMapTiles(zoom, StaticMapUtil.calculateViewportBounds(this.map, centerPt, width, height), this.destinationPath);
            if (!this.running || this.mainTask.isInterrupted()) break;
        }
        if (this.service != null) {
            this.service.shutdown();
        }
        this.running = false;
        this.consoleDialog.write("FINISHED bulk map download.");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    private void downloadMapTiles(int zoom, Rectangle viewportBounds, String destination) {
        int size = this.map.getTileFactory().getTileSize(zoom);
        int numWide = (int)Math.ceil(viewportBounds.width / size) + 1;
        int numHigh = (int)Math.ceil(viewportBounds.height / size) + 1;
        TileFactoryInfo info = this.map.getTileFactory().getInfo();
        int tpx = (int)Math.floor(viewportBounds.getX() / (double)info.getTileSize(zoom));
        int tpy = (int)Math.floor(viewportBounds.getY() / (double)info.getTileSize(zoom));
        int total = (numWide + 1) * (numHigh + 1);
        for (int x = 0; x <= numWide; ++x) {
            this.consoleDialog.write("Tiles remaining for zoom " + zoom + " => " + (total - x * numWide));
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                String[] url = info.getTileUrl(itpx, itpy, zoom);
                BulkFile file = new BulkFile(url[0], destination + "/" + zoom + "/" + itpx + "_" + itpy + ".png");
                this.startLoading(file);
                if (!this.running || this.mainTask.isInterrupted()) break;
            }
            if (!this.running || this.mainTask.isInterrupted()) break;
        }
    }

    private synchronized void startLoading(BulkFile file) {
        if (file.isLoading()) {
            log.debug(file.getFromUrl() + ": already loading. bailing");
            return;
        }
        file.setLoading(true);
        try {
            this.fileQueue.put(file);
            this.getService().submit(new FileRunner());
        }
        catch (Exception e) {
            log.error(e, e);
        }
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "file-pool-" + this.count++);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    private class FileRunner
    implements Runnable {
        private FileRunner() {
        }

        @Override
        public void run() {
            BulkFile file = (BulkFile)MapBulkDownloader.this.fileQueue.remove();
            if (!new File(file.getDestinationPath()).exists()) {
                Cache<String, BufferedImage> cache = MapFrame.getInstance().getMapViewer().getTilesCache();
                String urlHash = CacheUtil.getUrlHash(file.getFromUrl());
                Random generator = new Random();
                int trys = 3;
                while (!file.isLoaded() && trys > 0) {
                    try {
                        BufferedImage img;
                        if (MapBulkDownloader.this.withRandomDelay) {
                            VfrUtil.waitMilis(generator.nextInt(1500) + 500);
                        }
                        if ((img = (BufferedImage)cache.asMap().get(urlHash)) == null) {
                            img = UrlUtil.readImageFromUrl(file.getFromUrl(), true);
                            cache.asMap().put(urlHash, img);
                        }
                        if (img == null) {
                            --trys;
                            continue;
                        }
                        file.setLoaded(true);
                        UrlUtil.saveImage(img, file.getDestinationPath());
                    }
                    catch (Exception e) {
                        if (trys == 0) {
                            log.debug("Failed to load a tile at url: " + file.getFromUrl() + ", stopping", e);
                            continue;
                        }
                        log.trace("Failed to load a tile at url: " + file.getFromUrl() + ", retrying", e);
                        --trys;
                    }
                }
            }
            file.setLoading(false);
        }
    }
}

