/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.downloader;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.downloader.BulkFile;
import org.apache.log4j.Logger;

public class FilesBulkDownloader {
    private static final Logger log = Logger.getLogger(FilesBulkDownloader.class);
    private final String destinationPath;
    private final List<BulkFile> bulkFiles;
    private int threadPoolSize = 4;
    private ExecutorService service;
    private BlockingQueue<BulkFile> fileQueue = new ArrayBlockingQueue<BulkFile>(this.threadPoolSize * 2);

    public FilesBulkDownloader(List<String> files, String destinationPath) {
        this.destinationPath = destinationPath;
        this.bulkFiles = new ArrayList<BulkFile>(files.size());
        for (String file : files) {
            this.bulkFiles.add(new BulkFile(file, destinationPath));
        }
    }

    public void execute() {
        log.info("STARTING bulk download. Total files: " + this.bulkFiles.size());
        File dir = new File(this.destinationPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (BulkFile file : this.bulkFiles) {
            this.startLoading(file);
        }
        if (this.service != null) {
            this.service.shutdown();
        }
        log.info("FINISHED bulk map download.");
    }

    private synchronized void startLoading(BulkFile file) {
        if (file.isLoading()) {
            log.debug(file.getFromUrl() + ": already loading. bailing");
            return;
        }
        file.setLoading(true);
        try {
            this.fileQueue.put(file);
            this.getService().submit(new FileRunner());
        }
        catch (Exception e) {
            log.error(e, e);
        }
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "file-pool-" + this.count++);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    private class FileRunner
    implements Runnable {
        private FileRunner() {
        }

        @Override
        public void run() {
            BulkFile file = (BulkFile)FilesBulkDownloader.this.fileQueue.remove();
            int trys = 3;
            while (!file.isLoaded() && trys > 0) {
                try {
                    BufferedImage img = UrlUtil.readImageFromUrl(file.getFromUrl(), true);
                    if (img == null) {
                        --trys;
                        continue;
                    }
                    file.setLoaded(true);
                    UrlUtil.saveImage(img, file.getDestinationPath());
                }
                catch (Exception e) {
                    if (trys == 0) {
                        log.debug("Failed to load a tile at url: " + file.getFromUrl() + ", stopping", e);
                        continue;
                    }
                    log.trace("Failed to load a tile at url: " + file.getFromUrl() + ", retrying", e);
                    --trys;
                }
            }
            file.setLoading(false);
        }
    }
}

