/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.bean;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.UrlUtil;

public class HgtZipFilesMapping {
    private final String zipPath;
    private final String zipName;
    private final GpsArea[] coveredAreas;
    private final long size;

    public HgtZipFilesMapping(String zipPath, GpsArea[] coveredAreas, long size) {
        this.zipPath = zipPath;
        this.zipName = UrlUtil.getFilenameFromPath(zipPath);
        this.coveredAreas = coveredAreas;
        this.size = size;
    }

    public String getZipPath() {
        return this.zipPath;
    }

    public String getZipName() {
        return this.zipName;
    }

    public GpsArea[] getCoveredAreas() {
        return this.coveredAreas;
    }

    public long getSize() {
        return this.size;
    }

    public boolean contains(GpsPlace place) {
        if (place == null || this.coveredAreas == null || this.coveredAreas.length == 0) {
            return false;
        }
        for (GpsArea area : this.coveredAreas) {
            if (!place.isInside(area)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(GpsArea area) {
        if (area == null || this.coveredAreas == null || this.coveredAreas.length == 0) {
            return false;
        }
        for (GpsArea ar : this.coveredAreas) {
            if (!ar.isInside(area) && !area.isInside(ar)) continue;
            return true;
        }
        return false;
    }
}

