/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.bean;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import org.apache.log4j.Logger;

public class HgtHeader {
    private static final Logger log = Logger.getLogger(HgtHeader.class);
    private final int xllcorner;
    private final int yllcorner;
    private final GpsArea coveredRegion;
    private final String filename;
    private final int SIZE = 1201;
    private final double CELLSIZE = 8.326394671107411E-4;

    public HgtHeader(String filename) {
        this.filename = filename;
        this.xllcorner = this.getXllcornerFromHgtFileName(filename);
        this.yllcorner = this.getYllcornerFromHgtFileName(filename);
        GpsPlace topLeft = new GpsPlace(new GpsCoord(this.yllcorner + 1), new GpsCoord(this.xllcorner));
        GpsPlace bottomRight = new GpsPlace(new GpsCoord(this.yllcorner), new GpsCoord(this.xllcorner + 1));
        this.coveredRegion = new GpsArea(topLeft, bottomRight);
    }

    public int getXllcorner() {
        return this.xllcorner;
    }

    public int getYllcorner() {
        return this.yllcorner;
    }

    public int getSize() {
        return 1201;
    }

    public double getCellsize() {
        return 8.326394671107411E-4;
    }

    public GpsArea getCoveredRegion() {
        return this.coveredRegion;
    }

    private Integer getYllcornerFromHgtFileName(String filename) {
        Integer lat = null;
        if (filename != null && filename.length() >= 7) {
            try {
                lat = Integer.valueOf(filename.substring(1, 3));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse filename " + filename, e);
            }
            if (filename.toUpperCase().charAt(0) == 'S') {
                lat = -lat.intValue();
            }
        }
        return lat;
    }

    private Integer getXllcornerFromHgtFileName(String filename) {
        Integer lon = null;
        if (filename != null && filename.length() >= 7) {
            try {
                lon = Integer.valueOf(filename.substring(4, 7));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse filename " + filename, e);
            }
            if (filename.toUpperCase().charAt(3) == 'W') {
                lon = -lon.intValue();
            }
        }
        return lon;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isInside(GpsArea area) {
        return area != null && this.coveredRegion != null && (area.isInside(this.coveredRegion) || this.coveredRegion.isInside(area));
    }
}

