/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.amc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.AirspaceReservation;
import main.java.guru.vfrflight.core.AirspaceReservationPlan;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.type.AirspaceReservationType;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.xml.mrt.Mrts;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AmcUtil {
    private static final Logger log = Logger.getLogger(AmcUtil.class);

    public static List<AirspaceReservation> loadReservedAirspaces(String data) {
        ArrayList<AirspaceReservation> reservations = new ArrayList<AirspaceReservation>();
        reservations.addAll(AmcUtil.loadReservedAirspacesCharlie(data));
        reservations.addAll(AmcUtil.loadReservedAirspacesFoxtrot(data));
        return reservations;
    }

    public static List<AirspaceReservation> loadReservedAirspacesCharlie(String data) {
        ArrayList reservations = AmcUtil.loadReservedAirspaces(data, AirspaceReservationType.CHARLIE);
        return reservations == null ? new ArrayList() : reservations;
    }

    public static List<AirspaceReservation> loadReservedAirspacesFoxtrot(String data) {
        ArrayList reservations = AmcUtil.loadReservedAirspaces(data, AirspaceReservationType.FOXTROT);
        return reservations == null ? new ArrayList() : reservations;
    }

    public static List<AirspaceReservation> loadReservedAirspaces(String body, AirspaceReservationType type) {
        if (body != null) {
            String tableName = type.toString();
            Document doc = Jsoup.parse((String)body);
            Elements tables = doc.select("table");
            for (Element table : tables) {
                if (table.toString().indexOf(tableName) < 0) continue;
                ArrayList<AirspaceReservation> reservations = new ArrayList<AirspaceReservation>();
                Elements rows = table.getElementsByTag("tr");
                log.debug("Rows count for " + (Object)((Object)type) + " table: " + (rows.size() - 4));
                for (int i = 4; i < rows.size(); ++i) {
                    ArrayList<String> cols = new ArrayList<String>();
                    Elements columns = ((Element)rows.get(i)).getElementsByTag("td");
                    for (Element col : columns) {
                        cols.add(col.html());
                    }
                    List<AirspaceReservation> res = AmcUtil.parseAirspaceReservation(cols, type);
                    if (res != null) {
                        reservations.addAll(res);
                        continue;
                    }
                    log.error("Error parsing reservation row: " + ((Element)rows.get(i)).toString());
                }
                return reservations;
            }
        }
        return null;
    }

    private static List<AirspaceReservation> parseAirspaceReservation(List<String> cols, AirspaceReservationType type) {
        if (cols.size() != 8) {
            log.error("Invalid number of columns: " + cols);
            return null;
        }
        AirspaceReservation res = new AirspaceReservation();
        res.setNumber(cols.get(0));
        res.setAirspaceName(cols.get(1));
        res.setAltitudeFrom(AirspacesUtil.getAltitudeFromString(cols.get(2)));
        res.setAltitudeTo(AirspacesUtil.getAltitudeFromString(cols.get(3)));
        res.setAltitudeFromString(cols.get(2));
        res.setAltitudeToString(cols.get(3));
        res.setTimeFrom(VfrUtil.parseTimeFromString(cols.get(4)));
        res.setTimeTo(VfrUtil.parseTimeFromString(cols.get(5)));
        res.setTimeFromString(cols.get(4));
        res.setTimeToString(cols.get(5));
        res.setResponsibleUnit(cols.get(6));
        res.setRemarks(StringEscapeUtils.unescapeHtml((String)cols.get(7)));
        if (res.getAltitudeFrom() == null || res.getAltitudeTo() == null || res.getTimeFrom() == null || res.getTimeTo() == null) {
            log.error("Invalid airspace reservation: " + cols);
            return null;
        }
        if (NumberUtil.doubleEqualsDouble(res.getTimeFrom(), res.getTimeTo()) || res.getTimeFrom() > res.getTimeTo()) {
            res.setTimeTo(res.getTimeTo() + 24.0);
        }
        log.debug("Analyzing " + res.getAirspaceName());
        ArrayList<AirspaceReservation> resultList = new ArrayList<AirspaceReservation>();
        if (res.getAirspaceName().matches("^(EPD|EPR|TSA|TSAD|TRA|TFR|EA){1}[0-9]{1,3}[A-Z]{0,1}$")) {
            log.debug("Found single airspace for " + res.getAirspaceName());
            res.setType(type);
            resultList.add(res);
        } else if (res.getAirspaceName().matches("^(EPD|EPR|TSA|TRA|TFR|EA){1}[0-9]{1,3}[A-Z]+$")) {
            int index = -1;
            for (int i = res.getAirspaceName().length() - 1; i >= 0; --i) {
                if (Character.isLetter(res.getAirspaceName().charAt(i))) continue;
                index = i + 1;
                break;
            }
            String areas = res.getAirspaceName().substring(index);
            String basis = res.getAirspaceName().substring(0, index);
            log.debug("Found areas for " + res.getAirspaceName() + ": " + areas + " with basis " + basis);
            for (int i = 0; i < areas.length(); ++i) {
                AirspaceReservation r = res.clone();
                if (i == 0) {
                    r.setType(type);
                }
                r.setAirspaceName(basis + areas.charAt(i));
                resultList.add(r);
            }
        } else {
            res.setType(type);
            log.debug("Unknown Airspace NAME ! " + res.getAirspaceName());
            resultList.add(res);
        }
        return resultList;
    }

    public static List<AirspaceReservation> parseMrtRoutes(List<AirspaceReservation> reservations) {
        Map<String, String> mrtNames = AmcUtil.getMrtNames("data/mrts.xml");
        ArrayList<AirspaceReservation> newReservations = new ArrayList<AirspaceReservation>(reservations.size());
        for (AirspaceReservation r : reservations) {
            if (mrtNames.containsKey(r.getAirspaceName())) {
                String[] names;
                for (String name : names = mrtNames.get(r.getAirspaceName()).split(",")) {
                    AirspaceReservation res = r.clone();
                    res.setAirspaceName(name);
                    newReservations.add(res);
                }
                continue;
            }
            newReservations.add(r);
        }
        return newReservations;
    }

    public static AirspaceReservationPlan loadAirspaceReservationPlan(AirspaceAreaDTO[] airspaces, String data) {
        List<AirspaceReservation> reservations = AmcUtil.loadReservedAirspaces(data);
        if (reservations.size() == 0) {
            return null;
        }
        reservations = AmcUtil.parseMrtRoutes(reservations);
        AirspaceReservationPlan plan = new AirspaceReservationPlan();
        Document doc = Jsoup.parse((String)data);
        Elements tables = doc.select("table");
        if (tables.size() > 0) {
            plan.setDesc(((Element)tables.get(0)).text());
        }
        int foundNum = 0;
        StringBuilder found = new StringBuilder();
        StringBuilder missing = new StringBuilder();
        for (AirspaceReservation reservation : reservations) {
            reservation.setShape(AmcUtil.findShapeForReservation(reservation, airspaces));
            if (reservation.getShape() != null) {
                ++foundNum;
                found.append(reservation.getAirspaceName() + " ");
                continue;
            }
            missing.append(reservation.getAirspaceName() + " ");
        }
        plan.setWithShapesCount(foundNum);
        log.debug("Found " + foundNum + " of " + reservations.size() + " airspaces");
        if (foundNum < reservations.size()) {
            log.debug("Found airspaces: " + found.toString());
            log.debug("Missing airspaces: " + missing.toString());
        }
        int charlieNum = 0;
        int foxtrotNum = 0;
        for (AirspaceReservation res : reservations) {
            if (AirspaceReservationType.CHARLIE.equals((Object)res.getType())) {
                ++charlieNum;
                continue;
            }
            if (!AirspaceReservationType.FOXTROT.equals((Object)res.getType())) continue;
            ++foxtrotNum;
        }
        plan.setCharlieCount(charlieNum);
        plan.setFoxtrotCount(foxtrotNum);
        plan.setReservations(reservations);
        return plan;
    }

    private static MapShape findShapeForReservation(AirspaceReservation reservation, AirspaceAreaDTO[] airspaces) {
        for (AirspaceAreaDTO area : airspaces) {
            if (!AmcUtil.testAirspaceNames(area, reservation.getAirspaceName())) continue;
            return area;
        }
        return null;
    }

    private static boolean testAirspaceNames(AirspaceAreaDTO area, String aupName) {
        if (area.getName() == null || aupName == null) {
            return false;
        }
        if (area.getName().equals(aupName) || area.getName().equals("EP" + aupName)) {
            return true;
        }
        String trimmedAupName = aupName.replaceAll(" ", "").trim();
        String trimmedAreaName = area.getName().replaceAll(" ", "").trim();
        if (area.getType() != null && trimmedAupName.equals(area.getType().toString() + trimmedAreaName)) {
            return true;
        }
        return trimmedAupName.equals(trimmedAreaName) || trimmedAreaName.equals("EP" + trimmedAupName);
    }

    public static Map<String, String> getMrtNames(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Mrts.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Mrts xml = (Mrts)jaxbUnmarshaller.unmarshal(new File(file));
            return AmcUtil.getMrtNamesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static Map<String, String> getMrtNamesFromXml(Mrts xml) {
        HashMap<String, String> names = new HashMap<String, String>();
        if (xml != null) {
            for (Mrts.Mrt mrt : xml.getMrt()) {
                names.put(mrt.getName(), mrt.getValue());
            }
        }
        return names;
    }
}

