/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aixm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Route;
import main.java.guru.vfrflight.core.sql.entity.VfrPoint;
import main.java.guru.vfrflight.core.sql.entity.Waypoint;
import main.java.guru.vfrflight.core.sql.type.WaypointType;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.aixm.AixmAirspacesUtil;
import main.java.guru.vfrflight.xml.aixm.AIXMSnapshot;
import org.apache.log4j.Logger;

public class AixmPointsUtil {
    private static final Logger log = Logger.getLogger(AixmPointsUtil.class);
    private static final String SUPPORTED_AIXM_VERSION = "4.5";

    public static List<VfrPoint> loadVfrPoints(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmPointsUtil.getVfrPointsFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<VfrPoint> getVfrPointsFromXml(AIXMSnapshot xml) {
        ArrayList<VfrPoint> points = new ArrayList<VfrPoint>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                for (AIXMSnapshot.Ahp xn : xml.getAhp()) {
                    String ident = xn.getAhpUid().getCodeId();
                    String ahpUid = xn.getAhpUid().getMid();
                    for (AIXMSnapshot.Dpn xnd : xml.getDpn()) {
                        if (!AixmPointsUtil.isVfrPoint(xnd, ident) || (xnd.getAhpUidAssoc() == null || !ahpUid.equals(xnd.getAhpUidAssoc().getMid())) && !ident.equals(xnd.getAhpUidCodeId())) continue;
                        VfrPoint v = new VfrPoint();
                        if (xnd.getAhpUidCodeId() == null && !"ADHP".equals(xnd.getCodeType()) && xnd.getTxtName() != null) {
                            v.setName(xnd.getTxtName());
                        } else {
                            v.setName(xnd.getDpnUid().getCodeId());
                        }
                        if (xnd.getDpnUid().getGeoLat() != null && xnd.getDpnUid().getGeoLong() != null) {
                            GpsPlace place = FormatUtil.getAixmGpsFromString(xnd.getDpnUid().getGeoLat(), xnd.getDpnUid().getGeoLong());
                            v.setLat(place.getLat().getValue());
                            v.setLon(place.getLon().getValue());
                        }
                        v.setRemark(xnd.getTxtRmk());
                        points.add(v);
                        log.debug("Found VFR point " + v.getName() + " for " + ident);
                    }
                }
            }
        } else {
            log.fatal("Unsupported data version for points: " + xml.getVersion());
        }
        return points;
    }

    public static void importVfrIfrPoints(String file, boolean truncateVfrTable, boolean truncateIfrTable) {
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        List<VfrPoint> vfrPoints = AixmPointsUtil.loadVfrPoints(file);
        airportFacade.insertVfrPoints(vfrPoints, truncateVfrTable);
        AixmPointsUtil.importRoutes(file, truncateIfrTable);
        IfrRouteFacade ifrFacade = new IfrRouteFacade(DBUtil.getDataSource());
        List<Waypoint> ifrPoints = AixmPointsUtil.loadIfrPoints(file);
        Iterator<Waypoint> i = ifrPoints.iterator();
        block0: while (i.hasNext()) {
            Waypoint w = i.next();
            for (VfrPoint v : vfrPoints) {
                if (!NumberUtil.doubleEqualsDouble(v.getLat(), w.getLat(), 5) || !NumberUtil.doubleEqualsDouble(v.getLon(), w.getLon(), 5)) continue;
                i.remove();
                continue block0;
            }
        }
        ifrFacade.insertIfrPoints(ifrPoints, false);
    }

    private static String getUniqueKey(Double lat, Double lon) {
        StringBuilder sb = new StringBuilder();
        sb.append(NumberUtil.roundDouble(lat, 5));
        sb.append(NumberUtil.roundDouble(lon, 5));
        return sb.toString();
    }

    private static void importRoutes(String file, boolean truncateTable) {
        IfrRouteFacade ifrFacade = new IfrRouteFacade(DBUtil.getDataSource());
        List<Route> routes = AixmPointsUtil.loadIfrRoutes(file);
        ifrFacade.insertIfrRoutes(routes, truncateTable);
        ArrayList<Waypoint> ifrPoints = new ArrayList<Waypoint>();
        HashSet<String> pointsKeys = new HashSet<String>();
        for (Route r : routes) {
            String toKey;
            String fromKey = AixmPointsUtil.getUniqueKey(r.getFromLat(), r.getFromLon());
            if (!pointsKeys.contains(fromKey)) {
                ifrPoints.add(new Waypoint(r.getPreviousIdent(), WaypointType.ROUTE, r.getFromLat(), r.getFromLon()));
                pointsKeys.add(fromKey);
            }
            if (pointsKeys.contains(toKey = AixmPointsUtil.getUniqueKey(r.getToLat(), r.getToLon()))) continue;
            ifrPoints.add(new Waypoint(r.getNextIdent(), WaypointType.ROUTE, r.getToLat(), r.getToLon()));
            pointsKeys.add(toKey);
        }
        ifrFacade.insertIfrPoints(ifrPoints, truncateTable);
    }

    public static List<Waypoint> loadIfrPoints(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmPointsUtil.getIfrPointsFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    public static List<Route> loadIfrRoutes(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmPointsUtil.getIfrRoutesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<Route> getIfrRoutesFromXml(AIXMSnapshot xml) {
        ArrayList<Route> routes = new ArrayList<Route>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                for (AIXMSnapshot.Rsg rsg : xml.getRsg()) {
                    GpsPlace place;
                    if (AixmAirspacesUtil.isMrtRoute(rsg)) continue;
                    Route r = new Route();
                    r.setName(rsg.getRsgUid().getRteUid().getTxtDesig());
                    r.setRemark(rsg.getTxtRmk());
                    if (rsg.getRsgUid().getDpnUidSta() != null) {
                        r.setPreviousIdent(rsg.getRsgUid().getDpnUidSta().getCodeId());
                        if (rsg.getRsgUid().getDpnUidSta().getGeoLat() != null && rsg.getRsgUid().getDpnUidSta().getGeoLong() != null) {
                            place = FormatUtil.getAixmGpsFromString(rsg.getRsgUid().getDpnUidSta().getGeoLat(), rsg.getRsgUid().getDpnUidSta().getGeoLong());
                            r.setFromLat(place.getLat().getValue());
                            r.setFromLon(place.getLon().getValue());
                        }
                    } else if (rsg.getRsgUid().getVorUidSta() != null) {
                        r.setPreviousIdent(rsg.getRsgUid().getVorUidSta().getCodeId());
                        if (rsg.getRsgUid().getVorUidSta().getGeoLat() != null && rsg.getRsgUid().getVorUidSta().getGeoLong() != null) {
                            place = FormatUtil.getAixmGpsFromString(rsg.getRsgUid().getVorUidSta().getGeoLat(), rsg.getRsgUid().getVorUidSta().getGeoLong());
                            r.setFromLat(place.getLat().getValue());
                            r.setFromLon(place.getLon().getValue());
                        }
                    } else if (rsg.getRsgUid().getNdbUidSta() != null) {
                        r.setPreviousIdent(rsg.getRsgUid().getNdbUidSta().getCodeId());
                        if (rsg.getRsgUid().getNdbUidSta().getGeoLat() != null && rsg.getRsgUid().getNdbUidSta().getGeoLong() != null) {
                            place = FormatUtil.getAixmGpsFromString(rsg.getRsgUid().getNdbUidSta().getGeoLat(), rsg.getRsgUid().getNdbUidSta().getGeoLong());
                            r.setFromLat(place.getLat().getValue());
                            r.setFromLon(place.getLon().getValue());
                        }
                    } else {
                        log.error("Missing start point for " + r.getName());
                    }
                    if (rsg.getRsgUid().getDpnUidEnd() != null) {
                        r.setNextIdent(rsg.getRsgUid().getDpnUidEnd().getCodeId());
                        if (rsg.getRsgUid().getDpnUidEnd().getGeoLat() != null && rsg.getRsgUid().getDpnUidEnd().getGeoLong() != null) {
                            place = FormatUtil.getAixmGpsFromString(rsg.getRsgUid().getDpnUidEnd().getGeoLat(), rsg.getRsgUid().getDpnUidEnd().getGeoLong());
                            r.setToLat(place.getLat().getValue());
                            r.setToLon(place.getLon().getValue());
                        }
                    } else if (rsg.getRsgUid().getVorUidEnd() != null) {
                        r.setNextIdent(rsg.getRsgUid().getVorUidEnd().getCodeId());
                        if (rsg.getRsgUid().getVorUidEnd().getGeoLat() != null && rsg.getRsgUid().getVorUidEnd().getGeoLong() != null) {
                            place = FormatUtil.getAixmGpsFromString(rsg.getRsgUid().getVorUidEnd().getGeoLat(), rsg.getRsgUid().getVorUidEnd().getGeoLong());
                            r.setToLat(place.getLat().getValue());
                            r.setToLon(place.getLon().getValue());
                        }
                    } else if (rsg.getRsgUid().getNdbUidEnd() != null) {
                        r.setNextIdent(rsg.getRsgUid().getNdbUidEnd().getCodeId());
                        if (rsg.getRsgUid().getNdbUidEnd().getGeoLat() != null && rsg.getRsgUid().getNdbUidEnd().getGeoLong() != null) {
                            place = FormatUtil.getAixmGpsFromString(rsg.getRsgUid().getNdbUidEnd().getGeoLat(), rsg.getRsgUid().getNdbUidEnd().getGeoLong());
                            r.setToLat(place.getLat().getValue());
                            r.setToLon(place.getLon().getValue());
                        }
                    } else {
                        log.error("Missing end point for " + r.getName());
                    }
                    if (AixmPointsUtil.validateRoute(r)) {
                        log.debug("Found IFR route " + r.getName() + " [RsgUid mid=\"" + rsg.getRsgUid().getMid() + "\"]");
                        routes.add(r);
                        continue;
                    }
                    log.error("Invalid route:  [RsgUid mid=\"" + rsg.getRsgUid().getMid() + "\"]: " + r);
                }
            }
        } else {
            log.fatal("Unsupported data version for routes: " + xml.getVersion());
        }
        return routes;
    }

    private static boolean validateRoute(Route r) {
        return r.getName() != null && r.getFromLat() != null && r.getFromLon() != null && r.getToLat() != null && r.getToLon() != null;
    }

    private static List<Waypoint> getIfrPointsFromXml(AIXMSnapshot xml) {
        ArrayList<Waypoint> points = new ArrayList<Waypoint>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                for (AIXMSnapshot.Dpn xnd : xml.getDpn()) {
                    if (!AixmPointsUtil.isIfrPoint(xnd)) continue;
                    Waypoint w = new Waypoint();
                    w.setIdent(xnd.getDpnUid().getCodeId());
                    w.setType(WaypointType.IFR);
                    if (xnd.getDpnUid().getGeoLat() != null && xnd.getDpnUid().getGeoLong() != null) {
                        GpsPlace place = FormatUtil.getAixmGpsFromString(xnd.getDpnUid().getGeoLat(), xnd.getDpnUid().getGeoLong());
                        w.setLat(place.getLat().getValue());
                        w.setLon(place.getLon().getValue());
                    }
                    points.add(w);
                    log.debug("Found IFR point " + w.getIdent());
                }
            }
        } else {
            log.fatal("Unsupported data version for points: " + xml.getVersion());
        }
        return points;
    }

    private static boolean isIfrPoint(AIXMSnapshot.Dpn xnd) {
        return "ADHP".equals(xnd.getCodeType());
    }

    private static boolean isVfrPoint(AIXMSnapshot.Dpn xnd, String airportIdent) {
        if (xnd.getCodeType().startsWith("VFR")) {
            return true;
        }
        return "ADHP".equals(xnd.getCodeType()) && xnd.getDpnUid().getCodeId() != null && xnd.getDpnUid().getCodeId().matches("^([A-Z]{5})$") && (airportIdent == null || xnd.getDpnUid().getCodeId().startsWith(airportIdent));
    }
}

