/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aixm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.sql.facade.ObstacleFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.aixm.AIXMSnapshot;
import org.apache.log4j.Logger;

public class AixmObstaclesUtil {
    private static final Logger log = Logger.getLogger(AixmObstaclesUtil.class);
    private static final String SUPPORTED_AIXM_VERSION = "4.5";

    public static void importObstacles(String file, boolean truncateTable) {
        ObstacleFacade obstacleFacade = new ObstacleFacade(DBUtil.getDataSource());
        obstacleFacade.insertObstacles(AixmObstaclesUtil.loadObstacles(file), truncateTable);
    }

    public static List<Obstacle> loadObstacles(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmObstaclesUtil.getObstaclesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<Obstacle> getObstaclesFromXml(AIXMSnapshot xml) {
        ArrayList<Obstacle> obstacles = new ArrayList<Obstacle>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                for (AIXMSnapshot.Obs xn : xml.getObs()) {
                    Obstacle o = new Obstacle();
                    o.setName(xn.getTxtName());
                    o.setDesc(xn.getTxtDescrType());
                    if ("Y".equals(xn.getCodeLgt())) {
                        o.setLgt(true);
                    } else if (xn.getCodeLgt() != null) {
                        o.setLgt(false);
                    }
                    if ("Y".equals(xn.getCodeGroup())) {
                        o.setGrp(true);
                    } else if (xn.getCodeGroup() != null) {
                        o.setGrp(false);
                    }
                    if (xn.getValElev() != null) {
                        double amsl = xn.getValElev();
                        if (!"FT".equals(xn.getUomDistVer())) {
                            amsl = UnitUtil.recalculateAltitude(amsl, "m", "ft", false);
                        }
                        o.setAmsl((int)Math.round(amsl));
                    }
                    if (xn.getValHgt() != null && xn.getValHgt() > 0.0) {
                        double agl = xn.getValHgt();
                        if (!"FT".equals(xn.getUomDistVer())) {
                            agl = UnitUtil.recalculateAltitude(agl, "m", "ft", false);
                        }
                        o.setAgl((int)Math.round(agl));
                    }
                    if (xn.getObsUid() != null && xn.getObsUid().getGeoLat() != null && xn.getObsUid().getGeoLong() != null) {
                        GpsPlace place = FormatUtil.getAixmGpsFromString(xn.getObsUid().getGeoLat(), xn.getObsUid().getGeoLong());
                        o.setLat(place.getLat().getValue());
                        o.setLon(place.getLon().getValue());
                    }
                    if (AixmObstaclesUtil.validateObstacle(o)) {
                        obstacles.add(o);
                        continue;
                    }
                    log.fatal("INVALID OBSTACLE: " + o);
                }
            }
        } else {
            log.fatal("Unsupported data version for obstacles: " + xml.getVersion());
        }
        return obstacles;
    }

    private static boolean validateObstacle(Obstacle o) {
        return o.getLat() != null && o.getLon() != null;
    }
}

