/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aixm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.geo.RealWorldCalculator;
import main.java.guru.vfrflight.xml.aixm.AIXMSnapshot;
import org.apache.log4j.Logger;

public class AixmNavaidsUtil {
    private static final Logger log = Logger.getLogger(AixmNavaidsUtil.class);
    private static final String SUPPORTED_AIXM_VERSION = "4.5";
    private static final Map<String, String> TYPE_MAPPINGS;

    public static void importNavaids(String file, boolean truncateTable) {
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        navaidFacade.insertNavaids(AixmNavaidsUtil.loadNavaids(file), truncateTable);
    }

    public static List<Navaid> loadNavaids(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmNavaidsUtil.getNavaidsFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<Navaid> getNavaidsFromXml(AIXMSnapshot xml) {
        RealWorldCalculator declCalc = new RealWorldCalculator();
        ArrayList<Navaid> navaids = new ArrayList<Navaid>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                GpsPlace place;
                Navaid n;
                for (AIXMSnapshot.Vor xv : xml.getVor()) {
                    if (xv.getVorUid() == null) continue;
                    n = new Navaid();
                    String type = TYPE_MAPPINGS.get(xv.getCodeType());
                    for (AIXMSnapshot.Dme xd : xml.getDme()) {
                        if (xd.getVorUid() == null || !xv.getVorUid().getMid().equals(xd.getVorUid().getMid())) continue;
                        type = "VOR-DME";
                        break;
                    }
                    n.setType(type);
                    n.setIdent(xv.getVorUid().getCodeId());
                    if (xv.getVorUid().getGeoLat() != null && xv.getVorUid().getGeoLong() != null) {
                        GpsPlace place2 = FormatUtil.getAixmGpsFromString(xv.getVorUid().getGeoLat(), xv.getVorUid().getGeoLong());
                        n.setLat(place2.getLat().getValue());
                        n.setLon(place2.getLon().getValue());
                        n.setMagvar(declCalc.getMagneticDeclination(place2));
                    }
                    if (xv.getValFreq() != null) {
                        n.setFreq((int)Math.round(xv.getValFreq() * 1000.0));
                    }
                    if (xv.getValElev() != null) {
                        double elev = xv.getValElev();
                        if (!"FT".equals(xv.getUomDistVer())) {
                            elev = UnitUtil.recalculateAltitude(elev, "m", "ft", false);
                        }
                        n.setAlt((int)Math.round(elev));
                    }
                    n.setName(xv.getTxtName());
                    for (AIXMSnapshot.Vli xvl : xml.getVli()) {
                        if (xvl.getVliUid() == null || xvl.getVliUid().getVorUid() == null || !xv.getVorUid().getMid().equals(xvl.getVliUid().getVorUid().getMid())) continue;
                        n.setRemark(xvl.getTxtRmk());
                        break;
                    }
                    if (AixmNavaidsUtil.validateNavaid(n)) {
                        navaids.add(n);
                        continue;
                    }
                    log.fatal("INVALID VOR: " + n);
                }
                for (AIXMSnapshot.Dme xd : xml.getDme()) {
                    if (xd.getDmeUid() == null || xd.getVorUid() != null) continue;
                    n = new Navaid();
                    n.setType("DME");
                    n.setIdent(xd.getDmeUid().getCodeId());
                    if (xd.getDmeUid().getGeoLat() != null && xd.getDmeUid().getGeoLong() != null) {
                        place = FormatUtil.getAixmGpsFromString(xd.getDmeUid().getGeoLat(), xd.getDmeUid().getGeoLong());
                        n.setLat(place.getLat().getValue());
                        n.setLon(place.getLon().getValue());
                    }
                    if (xd.getValGhostFreq() != null) {
                        n.setFreq((int)Math.round(xd.getValGhostFreq() * 1000.0));
                    }
                    if (xd.getValElev() != null) {
                        double elev = xd.getValElev();
                        if (!"FT".equals(xd.getUomDistVer())) {
                            elev = UnitUtil.recalculateAltitude(elev, "m", "ft", false);
                        }
                        n.setAlt((int)Math.round(elev));
                    }
                    n.setName(xd.getTxtName());
                    n.setRemark(xd.getTxtRmk());
                    for (AIXMSnapshot.Dli dvl : xml.getDli()) {
                        if (dvl.getDliUid() == null || dvl.getDliUid().getDmeUid() == null || !xd.getDmeUid().getMid().equals(dvl.getDliUid().getDmeUid().getMid())) continue;
                        if (dvl.getTxtRmk() == null) break;
                        n.setRemark(n.getRemark() == null ? dvl.getTxtRmk() : n.getRemark() + "; " + dvl.getTxtRmk());
                        break;
                    }
                    if (AixmNavaidsUtil.validateNavaid(n)) {
                        navaids.add(n);
                        continue;
                    }
                    log.fatal("INVALID DME: " + n);
                }
                for (AIXMSnapshot.Ndb xn : xml.getNdb()) {
                    if (xn.getNdbUid() == null) continue;
                    n = new Navaid();
                    n.setType("NDB");
                    n.setIdent(xn.getNdbUid().getCodeId());
                    if (xn.getNdbUid().getGeoLat() != null && xn.getNdbUid().getGeoLong() != null) {
                        place = FormatUtil.getAixmGpsFromString(xn.getNdbUid().getGeoLat(), xn.getNdbUid().getGeoLong());
                        n.setLat(place.getLat().getValue());
                        n.setLon(place.getLon().getValue());
                    }
                    if (xn.getValFreq() != null) {
                        n.setFreq((int)Math.round(xn.getValFreq() * 10.0));
                    }
                    n.setName(xn.getTxtName());
                    n.setRemark(xn.getTxtRmk());
                    if (AixmNavaidsUtil.validateNavaid(n)) {
                        navaids.add(n);
                        continue;
                    }
                    log.fatal("INVALID NDB: " + n);
                }
            }
        } else {
            log.fatal("Unsupported data version for navaids: " + xml.getVersion());
        }
        return navaids;
    }

    private static boolean validateNavaid(Navaid n) {
        return n.getIdent() != null && n.getType() != null && n.getLat() != null && n.getLon() != null;
    }

    static {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("DME", "DME");
        mp.put("TACAN", "TACAN");
        mp.put("NDB", "NDB");
        mp.put("VOR", "VOR");
        mp.put("VOR-DME", "VOR-DME");
        mp.put("VORTAC", "VORTAC");
        mp.put("DVOR", "VOR");
        mp.put("DVOR-DME", "VOR-DME");
        mp.put("DVORTAC", "VORTAC");
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

