/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aixm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.aixm.AIXMSnapshot;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import org.apache.log4j.Logger;

public class AixmAirspacesUtil {
    private static final Logger log = Logger.getLogger(AixmAirspacesUtil.class);
    private static final boolean AIRSPACE_MIDS_AS_NAMES = false;
    private static final String SUPPORTED_AIXM_VERSION = "4.5";
    private static final List<String> IGNORE_TYPES = Arrays.asList("AWACS", "MARA", "TANGO", "FIR", "FIS", "RAS", "SECTOR", "SECTOR-C", "NAS", "DELEGATION", "FDA", "ADIZ");
    private static final Map<String, AirspaceType> TYPE_MAPPINGS;

    public static void importAirspaces(String file, boolean truncateTable) {
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        airspaceFacade.insertAirspaces(AixmAirspacesUtil.loadAirspaces(file), truncateTable);
    }

    public static List<AirspaceArea> loadAirspaces(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmAirspacesUtil.getAirspacesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<AirspaceArea> getAirspacesFromXml(AIXMSnapshot xml) {
        ArrayList<AirspaceArea> airspaces = new ArrayList<AirspaceArea>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                AirspaceArea ar;
                for (AIXMSnapshot.Ase xa : xml.getAse()) {
                    Object v;
                    String t;
                    if (xa.getAseUid() == null) continue;
                    ar = new AirspaceArea();
                    ar.setName(xa.getAseUid().getCodeId() != null ? xa.getAseUid().getCodeId() : xa.getTxtName());
                    String string = t = !StringUtil.isEmpty(xa.getTxtLocalType()) ? xa.getTxtLocalType() : xa.getAseUid().getCodeType();
                    if (StringUtil.isEmpty(t) && !StringUtil.isEmpty(xa.getCodeClass()) && xa.getCodeClass().length() == 1) {
                        t = "CLASS_" + xa.getCodeClass();
                    }
                    String t2 = xa.getAseUid().getCodeType();
                    if (StringUtil.isEmpty(t) || IGNORE_TYPES.contains(t)) continue;
                    ar.setRemark(xa.getTxtRmk() != null ? xa.getTxtRmk() : xa.getXtTxtRmk());
                    if (TYPE_MAPPINGS.get(t) != null) {
                        ar.setType(TYPE_MAPPINGS.get(t));
                    } else {
                        try {
                            ar.setType(AirspaceType.valueOf(t));
                        }
                        catch (IllegalArgumentException e) {
                            if (!StringUtil.isEmpty(t2) && !IGNORE_TYPES.contains(t)) {
                                if (TYPE_MAPPINGS.get(t2) != null) {
                                    ar.setType(TYPE_MAPPINGS.get(t2));
                                } else {
                                    try {
                                        ar.setType(AirspaceType.valueOf(t2));
                                    }
                                    catch (IllegalArgumentException e2) {
                                        log.error("Unknown AirspaceType [2]: " + t2);
                                    }
                                }
                            }
                            log.error("Unknown AirspaceType [1]: " + t);
                        }
                    }
                    if (xa.getValDistVerUpper() != null && xa.getUomDistVerUpper() != null) {
                        int elev = xa.getValDistVerUpper();
                        if ("FL".equals(xa.getUomDistVerUpper())) {
                            elev *= 100;
                        }
                        ar.setTopAltitude(elev);
                        if (xa.getCodeDistVerUpper() != null) {
                            try {
                                ar.setTopAltitudeType(AltitudeType.valueOf(xa.getCodeDistVerUpper()));
                            }
                            catch (IllegalArgumentException e) {
                                log.debug("Unknown AltitudeType: " + xa.getCodeDistVerUpper());
                            }
                        }
                    }
                    if (xa.getValDistVerLower() != null && xa.getUomDistVerLower() != null) {
                        int elev = xa.getValDistVerLower();
                        if ("FL".equals(xa.getUomDistVerLower())) {
                            elev *= 100;
                        }
                        ar.setBottomAltitude(elev);
                        if (xa.getCodeDistVerLower() != null) {
                            try {
                                ar.setBottomAltitudeType(AltitudeType.valueOf(xa.getCodeDistVerLower()));
                            }
                            catch (IllegalArgumentException e) {
                                log.debug("Unknown AltitudeType: " + xa.getCodeDistVerLower());
                            }
                        }
                    }
                    boolean shapeFound = false;
                    boolean clockwiseCheck = false;
                    for (AIXMSnapshot.Abd xb : xml.getAbd()) {
                        if (!xa.getAseUid().getMid().equals(xb.getAbdUid().getAseUid().getMid())) continue;
                        if (xb.getCircle() != null && xb.getCircle().size() > 0 || xb.getAvx().size() == 1) {
                            GpsPlace place;
                            if (xb.getAvx().size() == 1) {
                                v = xb.getAvx().get(0);
                                place = FormatUtil.getAixmGpsFromString(((AIXMSnapshot.Abd.Avx)v).getGeoLatArc(), ((AIXMSnapshot.Abd.Avx)v).getGeoLongArc());
                                if (place != null) {
                                    ar.setCircleCenterLat(place.getLat().getValue());
                                    ar.setCircleCenterLon(place.getLon().getValue());
                                    GpsPlace placeTo = FormatUtil.getAixmGpsFromString(((AIXMSnapshot.Abd.Avx)v).getGeoLat(), ((AIXMSnapshot.Abd.Avx)v).getGeoLong());
                                    if (placeTo != null) {
                                        ar.setRadius(GpsUtil.getDistance(place, placeTo));
                                    } else {
                                        log.error("Place for vertex is null [AseUid mid=\"" + xa.getAseUid().getMid() + "\"]: " + ((AIXMSnapshot.Abd.Avx)v).getGeoLat() + "; " + ((AIXMSnapshot.Abd.Avx)v).getGeoLong());
                                    }
                                } else {
                                    log.error("Place for vertex is null [AseUid mid=\"" + xa.getAseUid().getMid() + "\"]: " + ((AIXMSnapshot.Abd.Avx)v).getGeoLatArc() + "; " + ((AIXMSnapshot.Abd.Avx)v).getGeoLongArc());
                                }
                            } else {
                                AIXMSnapshot.Abd.Circle c = xb.getCircle().get(0);
                                place = FormatUtil.getAixmGpsFromString(c.getGeoLatCen(), c.getGeoLongCen());
                                ar.setCircleCenterLat(place.getLat().getValue());
                                ar.setCircleCenterLon(place.getLon().getValue());
                                double radius = c.getValRadius();
                                if (c.getUomRadius() != null && !"NM".equalsIgnoreCase(c.getUomRadius())) {
                                    radius = UnitUtil.recalculateDistance(radius, c.getUomRadius().toLowerCase(), "nm", false);
                                }
                                ar.setRadius(radius);
                            }
                        } else if (xb.getAvx() != null && xb.getAvx().size() > 1) {
                            for (AIXMSnapshot.Abd.Avx v2 : xb.getAvx()) {
                                GpsPlace place;
                                if ("GRC".equals(v2.getCodeType()) || "FNT".equals(v2.getCodeType())) {
                                    place = FormatUtil.getAixmGpsFromString(v2.getGeoLat(), v2.getGeoLong());
                                    if (place != null) {
                                        ar.getVertices().add(new AirspaceAreaVertex(place));
                                        continue;
                                    }
                                    log.error("Place for vertex is null: " + v2.getGeoLat() + "; " + v2.getGeoLong());
                                    continue;
                                }
                                place = FormatUtil.getAixmGpsFromString(v2.getGeoLat(), v2.getGeoLong());
                                if (place != null) {
                                    ar.getVertices().add(new AirspaceAreaVertex(place));
                                } else {
                                    log.error("Place for vertex is null: " + v2.getGeoLat() + "; " + v2.getGeoLong());
                                }
                                Double radius = null;
                                Boolean clockwise = null;
                                if (v2.getValRadiusArc() != null) {
                                    radius = v2.getValRadiusArc();
                                } else if (v2.getGeoLatArc() != null && v2.getGeoLongArc() != null && ar.getVertices().size() > 0) {
                                    GpsPlace center = FormatUtil.getAixmGpsFromString(v2.getGeoLatArc(), v2.getGeoLongArc());
                                    radius = GpsUtil.getDistance(place, center);
                                    clockwiseCheck = true;
                                }
                                if (radius == null) {
                                    log.error("Radius is null for AseUid mid=\"" + xa.getAseUid().getMid() + "\"");
                                    continue;
                                }
                                if (radius == null) continue;
                                if (v2.getUomRadiusArc() != null && !"NM".equalsIgnoreCase(v2.getUomRadiusArc())) {
                                    radius = UnitUtil.recalculateDistance(radius, v2.getUomRadiusArc().toLowerCase(), "nm", false);
                                }
                                place = FormatUtil.getAixmGpsFromString(v2.getGeoLatArc(), v2.getGeoLongArc());
                                ar.getVertices().add(new AirspaceAreaVertex(place.getLat().getValue(), place.getLon().getValue(), radius, clockwise));
                            }
                            if (!ar.getVertices().get(ar.getVertices().size() - 1).isVertex()) {
                                ar.getVertices().add(ar.getVertices().get(0).clone());
                            }
                        }
                        shapeFound = true;
                        break;
                    }
                    if (shapeFound && AixmAirspacesUtil.validateAirspace(ar)) {
                        if (clockwiseCheck && !ar.isClockwise()) {
                            ArrayList<AirspaceAreaVertex> vertices = new ArrayList<AirspaceAreaVertex>(ar.getVertices().size());
                            for (int i = 0; i < ar.getVertices().size(); ++i) {
                                v = ar.getVertices().get(i);
                                if (!((AirspaceAreaVertex)v).isVertex()) {
                                    ((AirspaceAreaVertex)v).setClockwise(false);
                                }
                                vertices.add(((AirspaceAreaVertex)v).clone());
                            }
                            ar.setVertices(vertices);
                        }
                        airspaces.add(ar);
                        continue;
                    }
                    boolean foundAdg = false;
                    for (AIXMSnapshot.Adg xd : xml.getAdg()) {
                        for (Object o : xd.getAdgUidOrAseUidBaseOrCodeOpr()) {
                            if (!(o instanceof AIXMSnapshot.Adg.AdgUid)) continue;
                            AIXMSnapshot.Adg.AdgUid adgUid = (AIXMSnapshot.Adg.AdgUid)o;
                            if (!xa.getAseUid().getMid().equals(adgUid.getAseUid().getMid())) break;
                            foundAdg = true;
                            break;
                        }
                        if (!foundAdg) continue;
                        break;
                    }
                    if (foundAdg) continue;
                    log.fatal("INVALID AIRSPACE " + ar.getName() + "; AseUid mid=\"" + xa.getAseUid().getMid() + "\" " + (Object)((Object)ar.getType()) + " [" + shapeFound + "]");
                }
                for (AIXMSnapshot.Rsg xr : xml.getRsg()) {
                    if (!AixmAirspacesUtil.isMrtRoute(xr)) continue;
                    log.debug("Found military route " + xr.getRsgUid().getRteUid().getTxtDesig() + " between " + xr.getRsgUid().getDpnUidSta().getCodeId() + "-" + xr.getRsgUid().getDpnUidEnd().getCodeId());
                    ar = new AirspaceArea();
                    ar.setType(AirspaceType.MRT);
                    if (xr.getValDistVerUpper() != null && xr.getUomDistVerUpper() != null) {
                        int elev = xr.getValDistVerUpper();
                        if ("FL".equals(xr.getUomDistVerUpper())) {
                            elev *= 100;
                        }
                        ar.setTopAltitude(elev);
                        if (xr.getCodeDistVerUpper() != null) {
                            try {
                                ar.setTopAltitudeType(AltitudeType.valueOf(xr.getCodeDistVerUpper()));
                            }
                            catch (IllegalArgumentException e) {
                                log.debug("Unknown AltitudeType: " + xr.getCodeDistVerUpper());
                            }
                        }
                    }
                    if (xr.getValDistVerLower() != null && xr.getUomDistVerLower() != null) {
                        int elev = xr.getValDistVerLower();
                        if ("FL".equals(xr.getUomDistVerLower())) {
                            elev *= 100;
                        }
                        ar.setBottomAltitude(elev);
                        if (xr.getCodeDistVerLower() != null) {
                            try {
                                ar.setBottomAltitudeType(AltitudeType.valueOf(xr.getCodeDistVerLower()));
                            }
                            catch (IllegalArgumentException e) {
                                log.debug("Unknown AltitudeType: " + xr.getCodeDistVerLower());
                            }
                        }
                    }
                    if (xr.getValWid() != null && xr.getValTrueTrack() != null) {
                        double width = xr.getValWid() / 2.0;
                        if ("KM".equals(xr.getUomWid())) {
                            width = UnitUtil.recalculateDistance(width, "km", "nm", false);
                        }
                        if (xr.getRsgUid() != null && xr.getRsgUid().getDpnUidEnd() != null && xr.getRsgUid().getDpnUidSta() != null) {
                            GpsPlace from = FormatUtil.getAixmGpsFromString(xr.getRsgUid().getDpnUidSta().getGeoLat(), xr.getRsgUid().getDpnUidSta().getGeoLong());
                            GpsPlace to = FormatUtil.getAixmGpsFromString(xr.getRsgUid().getDpnUidEnd().getGeoLat(), xr.getRsgUid().getDpnUidEnd().getGeoLong());
                            double heading = xr.getValTrueTrack();
                            if (from != null && to != null) {
                                GeoPosition[] boundary;
                                for (GeoPosition p : boundary = GpsUtil.calculateBoundaryForLineSegment(new LineSegment(from, to, heading), width, 15)) {
                                    ar.getVertices().add(new AirspaceAreaVertex(p));
                                }
                            }
                            ar.setName(xr.getRsgUid().getDpnUidSta().getCodeId() + "-" + xr.getRsgUid().getDpnUidEnd().getCodeId());
                        }
                    } else {
                        log.error("Missing width for " + ar.getName());
                    }
                    if (AixmAirspacesUtil.validateAirspace(ar)) {
                        airspaces.add(ar);
                        continue;
                    }
                    log.fatal("INVALID MRT " + ar.getName() + "; RsgUid mid=\"" + xr.getRsgUid().getMid() + "\"");
                }
            }
        } else {
            log.fatal("Unsupported data version for airspaces: " + xml.getVersion());
        }
        return airspaces;
    }

    public static boolean isMrtRoute(AIXMSnapshot.Rsg xr) {
        return "M".equals(xr.getCodeCiv()) && "L".equals(xr.getCodeLvl()) || xr.getRsgUid().getRteUid().getTxtDesig().startsWith("MRT");
    }

    private static boolean validateAirspace(AirspaceArea ar) {
        if (ar.isPoly() && ar.getVertices().size() == 0) {
            return false;
        }
        if (ar.isCircle() && ar.getRadius() == null) {
            return false;
        }
        return ar.getType() != null;
    }

    static {
        HashMap<String, AirspaceType> mp = new HashMap<String, AirspaceType>();
        mp.put("CTR-P", AirspaceType.CTR);
        mp.put("TMA-P", AirspaceType.TMA);
        mp.put("MTMA", AirspaceType.TMA);
        mp.put("NRA", AirspaceType.RESTRICTED);
        mp.put("AREA", AirspaceType.SPORTS_AREA);
        mp.put("D", AirspaceType.DANGER);
        mp.put("P", AirspaceType.PROHIBITED);
        mp.put("R", AirspaceType.RESTRICTED);
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

