/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aixm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.Apron;
import main.java.guru.vfrflight.core.sql.entity.ApronVertex;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.core.sql.entity.Taxiway;
import main.java.guru.vfrflight.core.sql.type.AirportFreqType;
import main.java.guru.vfrflight.core.sql.type.Surface;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.ImportFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.geo.RealWorldCalculator;
import main.java.guru.vfrflight.xml.aixm.AIXMSnapshot;
import org.apache.log4j.Logger;
import org.hsqldb.lib.StringUtil;

public class AixmAirportsUtil {
    private static final Logger log = Logger.getLogger(AixmAirportsUtil.class);
    private static final String SUPPORTED_AIXM_VERSION = "4.5";
    private static final Map<String, Surface> SURFACE_MAPPINGS;

    public static void importAirports(String file, boolean truncateTable) {
        AirportFacade aiportFacade = new AirportFacade(DBUtil.getDataSource());
        List<Airport> airports = AixmAirportsUtil.loadAirports(file);
        MapFacade mapFacade = new MapFacade(DBUtil.getDataSource());
        ImportFacade importFacade = new ImportFacade(DBUtil.getDataSource());
        importFacade.setMountanousAirports(airports, mapFacade.findElevations(0));
        importFacade.setHardenedAirports(airports);
        aiportFacade.insertAirports(airports, truncateTable);
    }

    public static List<Airport> loadAirports(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AIXMSnapshot.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AIXMSnapshot xml = (AIXMSnapshot)jaxbUnmarshaller.unmarshal(new File(file));
            return AixmAirportsUtil.getAirportsFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<Airport> getAirportsFromXml(AIXMSnapshot xml) {
        RealWorldCalculator declCalc = new RealWorldCalculator();
        ArrayList<Airport> airports = new ArrayList<Airport>();
        if (xml.getVersion().startsWith(SUPPORTED_AIXM_VERSION)) {
            if (xml != null) {
                for (AIXMSnapshot.Ahp xn : xml.getAhp()) {
                    String ahpUid = xn.getAhpUid().getMid();
                    Airport a = new Airport();
                    a.setIdent(xn.getAhpUid().getCodeId());
                    a.setName(xn.getTxtName());
                    if (xn.getGeoLat() != null && xn.getGeoLong() != null) {
                        GpsPlace place = FormatUtil.getAixmGpsFromString(xn.getGeoLat(), xn.getGeoLong());
                        a.setLat(place.getLat().getValue());
                        a.setLon(place.getLon().getValue());
                        a.setMagvar(declCalc.getMagneticDeclination(place));
                    }
                    if (xn.getValElev() != null) {
                        double elev = xn.getValElev();
                        if (!"FT".equals(xn.getUomDistVer())) {
                            elev = UnitUtil.recalculateAltitude(elev, "m", "ft", false);
                        }
                        a.setElev((int)Math.round(elev));
                    }
                    double longestRwyLength = 0.0;
                    Double headingOfLongestRwy = null;
                    for (AIXMSnapshot.Rwy xnr : xml.getRwy()) {
                        Runway r = new Runway();
                        r.setLat(a.getLat());
                        r.setLon(a.getLon());
                        r.setDesc(xnr.getRwyUid().getTxtDesig());
                        if (ahpUid == null || !ahpUid.equals(xnr.getRwyUid().getAhpUid().getMid())) continue;
                        log.debug("RWY " + xnr.getRwyUid().getTxtDesig() + " binded to " + a.getIdent());
                        if (xnr.getValLen() != null) {
                            double len = xnr.getValLen();
                            if (!"M".equals(xnr.getUomDimRwy())) {
                                len = UnitUtil.recalculateDistance(len, "ft", "m", false);
                            }
                            r.setLength(len);
                        }
                        if (xnr.getValWid() != null) {
                            double wid = xnr.getValWid();
                            if (!"M".equals(xnr.getUomDimRwy())) {
                                wid = UnitUtil.recalculateDistance(wid, "ft", "m", false);
                            }
                            r.setWidth(wid);
                        }
                        if (!StringUtil.isEmpty(xnr.getCodeComposition())) {
                            try {
                                r.setSurface(SURFACE_MAPPINGS.get(xnr.getCodeComposition()));
                            }
                            catch (IllegalArgumentException e) {
                                log.debug("Unknown AirportRunwaysSurface: " + xnr.getCodeComposition());
                            }
                        }
                        r.setMagvar(a.getMagvar());
                        if (xnr.getRwyUid().getMid() != null) {
                            ArrayList<AIXMSnapshot.Rdn> rwyDet = new ArrayList<AIXMSnapshot.Rdn>(2);
                            for (AIXMSnapshot.Rdn xnrd : xml.getRdn()) {
                                if (!xnr.getRwyUid().getMid().equals(xnrd.getRdnUid().getRwyUid().getMid())) continue;
                                rwyDet.add(xnrd);
                                if (rwyDet.size() != 2) continue;
                                break;
                            }
                            if (rwyDet.size() == 2) {
                                String string = ((AIXMSnapshot.Rdn)rwyDet.get(0)).getGeoLat();
                                String lon1 = ((AIXMSnapshot.Rdn)rwyDet.get(0)).getGeoLong() != null ? ((AIXMSnapshot.Rdn)rwyDet.get(0)).getGeoLong() : ((AIXMSnapshot.Rdn)rwyDet.get(0)).getGeoLon();
                                String lat2 = ((AIXMSnapshot.Rdn)rwyDet.get(1)).getGeoLat();
                                String string2 = ((AIXMSnapshot.Rdn)rwyDet.get(1)).getGeoLong() != null ? ((AIXMSnapshot.Rdn)rwyDet.get(1)).getGeoLong() : ((AIXMSnapshot.Rdn)rwyDet.get(1)).getGeoLon();
                                GpsPlace thr1 = FormatUtil.getAixmGpsFromString(string, lon1);
                                GpsPlace thr2 = FormatUtil.getAixmGpsFromString(lat2, string2);
                                LineSegment segm = new LineSegment(thr1, thr2);
                                if (thr1 == null || thr2 == null) {
                                    log.error("Error with looking for center: " + ((AIXMSnapshot.Rdn)rwyDet.get(0)).getGeoLat() + " =1> " + ((AIXMSnapshot.Rdn)rwyDet.get(0)).getGeoLong());
                                    log.error("Error with looking for center: " + ((AIXMSnapshot.Rdn)rwyDet.get(1)).getGeoLat() + " =2> " + ((AIXMSnapshot.Rdn)rwyDet.get(1)).getGeoLong());
                                } else {
                                    Double trueBrg;
                                    GpsPlace rwyCenter = segm.getCenter();
                                    r.setLat(rwyCenter.getLat().getValue());
                                    r.setLon(rwyCenter.getLon().getValue());
                                    Double d = trueBrg = ((AIXMSnapshot.Rdn)rwyDet.get(0)).getValTrueBrg() != null ? ((AIXMSnapshot.Rdn)rwyDet.get(0)).getValTrueBrg() : ((AIXMSnapshot.Rdn)rwyDet.get(0)).getValueTruBrg();
                                    if (trueBrg != null && a.getMagvar() != null) {
                                        r.setHeading(trueBrg - a.getMagvar());
                                    }
                                    if (r.getHeading() != null) {
                                        r.setNumber(GpsUtil.getPrimaryRwyNumberFromHeading(r.getHeading()));
                                    }
                                    log.debug("Setting RWY center " + xnr.getRwyUid().getMid() + " of " + a.getIdent() + " to " + rwyCenter + "; heading " + r.getHeading() + "; number " + r.getNumber());
                                }
                            } else {
                                log.debug("Couldn't find Rdn elements for RWY " + xnr.getRwyUid().getMid() + " of " + a.getIdent());
                            }
                            if (rwyDet.size() > 0) {
                                for (AIXMSnapshot.Ils xni : xml.getIls()) {
                                    for (AIXMSnapshot.Rdn rdn : rwyDet) {
                                        if (!rdn.getRdnUid().getMid().equals(xni.getIlsUid().getRdnUid().getMid())) continue;
                                        log.debug("Found ILS for " + xnr.getRwyUid().getMid() + " of " + a.getIdent());
                                        Ils i = new Ils();
                                        if (rdn.getValElevTdz() == null) {
                                            i.setAlt(a.getElev());
                                        } else {
                                            double elev = rdn.getValElevTdz();
                                            if (!"FT".equals(rdn.getUomElevTdz())) {
                                                elev = UnitUtil.recalculateAltitude(elev, "m", "ft", false);
                                            }
                                            i.setAlt((int)Math.round(elev));
                                        }
                                        i.setHeading(rdn.getValTrueBrg());
                                        i.setMagvar(a.getMagvar());
                                        if (xni.getIgp().getValSlope() == null) {
                                            i.setPitch(3.0);
                                        } else {
                                            i.setPitch(xni.getIgp().getValSlope().doubleValue());
                                        }
                                        i.setWidth(3.0);
                                        i.setFrequency(xni.getIlz().getValFreq());
                                        i.setDme(xni.getDmeUid() != null);
                                        i.setGs(xni.getIgp() != null);
                                        if (xni.getIlz() != null && xni.getIlz().getGeoLat() != null && xni.getIlz().getGeoLong() != null) {
                                            GpsPlace place = FormatUtil.getAixmGpsFromString(xni.getIlz().getGeoLat(), xni.getIlz().getGeoLong());
                                            i.setLat(place.getLat().getValue());
                                            i.setLon(place.getLon().getValue());
                                        }
                                        i.setIdent(xni.getIlz().getCodeId());
                                        r.getIls().add(i);
                                    }
                                }
                            }
                        }
                        if (r.getLength() != null && r.getHeading() != null && r.getLength() >= longestRwyLength) {
                            longestRwyLength = r.getLength();
                            headingOfLongestRwy = r.getHeading();
                        }
                        a.getRunways().add(r);
                    }
                    if (headingOfLongestRwy != null) {
                        a.setMainLength((int)Math.round(longestRwyLength));
                        a.setMainRwy((int)Math.round(headingOfLongestRwy));
                    }
                    block13: for (AIXMSnapshot.Fqy xnf : xml.getFqy()) {
                        if (xnf.getFqyUid() == null || xnf.getFqyUid().getSerUid() == null || xnf.getFqyUid().getSerUid().getUniUid() == null || xnf.getFqyUid().getSerUid().getUniUid().getMid() == null) continue;
                        String uniUid = xnf.getFqyUid().getSerUid().getUniUid().getMid();
                        for (AIXMSnapshot.Uni uni : xml.getUni()) {
                            if (!uniUid.equals(uni.getUniUid().getMid())) continue;
                            if ((uni.getAhpUid() == null || uni.getAhpUid().getMid() == null || !ahpUid.equals(uni.getAhpUid().getMid())) && (uni.getUniUid().getTxtName() == null || !uni.getUniUid().getTxtName().startsWith(a.getIdent()))) continue block13;
                            String callsign = null;
                            Double freq = null;
                            if (xnf.getCdl() != null) {
                                for (AIXMSnapshot.Fqy.Cdl cdl : xnf.getCdl()) {
                                    if (!SettingsBean.getInstance().getLanguageCode().equals(cdl.getCodeLang())) continue;
                                    callsign = cdl.getTxtCallSign();
                                    break;
                                }
                                if (callsign == null && xnf.getCdl().size() > 0) {
                                    callsign = xnf.getCdl().get(0).getTxtCallSign();
                                }
                            }
                            freq = xnf.getFqyUid().getValFreqTrans() != null ? xnf.getFqyUid().getValFreqTrans() : xnf.getValFreqRec();
                            AirportFreq airportFreq = new AirportFreq();
                            airportFreq.setName(callsign);
                            airportFreq.setFrequency(freq);
                            if (xnf.getFqyUid().getSerUid() != null && xnf.getFqyUid().getSerUid().getCodeType() != null) {
                                try {
                                    airportFreq.setType(AirportFreqType.valueOf(xnf.getFqyUid().getSerUid().getCodeType()));
                                }
                                catch (IllegalArgumentException e) {
                                    log.error("Unknown AirportFreqType: " + xnf.getFqyUid().getSerUid().getCodeType());
                                }
                            }
                            log.debug("Frequency found for " + a.getIdent() + " - " + callsign + " / " + freq);
                            a.getFrequencies().add(airportFreq);
                            continue block13;
                        }
                    }
                    for (AIXMSnapshot.Apn xapn : xml.getApn()) {
                        String[] pos;
                        if (!ahpUid.equals(xapn.getApnUid().getAhpUid().getMid()) || xapn.getXtSurface() == null || xapn.getXtSurface().getGmlPosList() == null || (pos = xapn.getXtSurface().getGmlPosList().split(" ")).length <= 0) continue;
                        Apron apron = new Apron();
                        for (String string : pos) {
                            String[] coords = string.trim().split(",");
                            if (coords.length == 2) {
                                try {
                                    ApronVertex v = new ApronVertex();
                                    v.setLon(Double.valueOf(coords[0]));
                                    v.setLat(Double.valueOf(coords[1]));
                                    apron.getVertices().add(v);
                                }
                                catch (NumberFormatException e) {
                                    log.error("Invalid coords for apron [1]: " + xapn.getApnUid().getMid() + " => " + string, e);
                                }
                                continue;
                            }
                            log.error("Invalid coords for apron [2]: " + xapn.getApnUid().getMid() + " => " + string);
                        }
                        if (apron.getVertices().size() > 0) {
                            a.getAprons().add(apron);
                            continue;
                        }
                        log.error("No vertices for apron: " + xapn.getApnUid().getMid());
                    }
                    for (AIXMSnapshot.Twy xt : xml.getTwy()) {
                        int i;
                        if (!ahpUid.equals(xt.getTwyUid().getAhpUid().getMid()) || xt.getXtSurface() == null || xt.getXtSurface().getGmlPosList() == null) continue;
                        String taxiwayName = xt.getTwyUid().getTxtDesig();
                        String[] pos = xt.getXtSurface().getGmlPosList().split(" ");
                        if (pos.length <= 0) continue;
                        GpsPlace[] gpsPlaceArray = new GpsPlace[pos.length];
                        boolean success = true;
                        for (i = 0; i < pos.length; ++i) {
                            String[] stringArray = pos[i].trim().split(",");
                            if (stringArray.length == 2) {
                                try {
                                    gpsPlaceArray[i] = new GpsPlace(Double.valueOf(stringArray[1]), Double.valueOf(stringArray[0]));
                                }
                                catch (NumberFormatException e) {
                                    log.error("Invalid coords for taxiway [1]: " + xt.getTwyUid().getMid() + " => " + pos[i], e);
                                    success = false;
                                }
                                continue;
                            }
                            log.error("Invalid coords for taxiway [2]: " + xt.getTwyUid().getMid() + " => " + pos[i]);
                            success = false;
                        }
                        if (!success) continue;
                        for (i = 1; i < gpsPlaceArray.length; ++i) {
                            Taxiway taxiway = new Taxiway();
                            taxiway.setName(taxiwayName);
                            taxiway.setFromLat(gpsPlaceArray[i - 1].getLat().getValue());
                            taxiway.setFromLon(gpsPlaceArray[i - 1].getLon().getValue());
                            taxiway.setToLat(gpsPlaceArray[i].getLat().getValue());
                            taxiway.setToLon(gpsPlaceArray[i].getLon().getValue());
                            taxiway.setWidth(20.0);
                            a.getTaxiways().add(taxiway);
                            if (StringUtil.isEmpty(taxiway.getName())) continue;
                            a.getTaxiNames().add(new TaxiName(taxiway));
                        }
                        VfrUtil.optimizeTaxiNames(a);
                    }
                    if (AixmAirportsUtil.validateAirport(a)) {
                        airports.add(a);
                        continue;
                    }
                    log.fatal("INVALID AIRPORT: " + a);
                }
            }
        } else {
            log.fatal("Unsupported data version for airports: " + xml.getVersion());
        }
        return airports;
    }

    private static boolean validateAirport(Airport a) {
        return a.getLat() != null && a.getLon() != null;
    }

    static {
        HashMap<String, Surface> mp = new HashMap<String, Surface>();
        mp.put("ASPH", Surface.ASPHALT);
        mp.put("CONC", Surface.CONCRETE);
        mp.put("GRASS", Surface.GRASS);
        mp.put("CONC+ASPH", Surface.CONCRETE_ASPHALT);
        SURFACE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

