/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aip;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.aip.AipAirportUtil;
import main.java.guru.vfrflight.util.aip.AipAirspaceUtil;
import main.java.guru.vfrflight.util.aip.AipNavaidUtil;
import org.apache.log4j.Logger;

public class AipUtil {
    private static final Logger log = Logger.getLogger(AipUtil.class);

    public static void importData(String pathToFolder, boolean truncateData) {
        ArrayList<AirspaceArea> airspaces = new ArrayList<AirspaceArea>();
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        if (truncateData) {
            AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
            airportFacade.truncateAirportsTable();
            NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
            navaidFacade.truncateNavaidsTable();
            airspaceFacade.truncateAirspacesTable();
        }
        Set<DiskObject> results = SearchUtil.getRootList("*.aip", pathToFolder);
        for (DiskObject d : results) {
            String path = pathToFolder + d.getPath();
            log.info("Importing from " + path);
            AipFileType type = AipUtil.getAipType(path);
            if (AipFileType.AIRPORTS.equals((Object)type)) {
                AipAirportUtil.importAirports(path, false);
                continue;
            }
            if (AipFileType.AIRSPACES.equals((Object)type)) {
                airspaces.addAll(AipAirspaceUtil.loadAirspaces(path));
                continue;
            }
            if (AipFileType.NAVAIDS.equals((Object)type)) {
                AipNavaidUtil.importNavaids(path, false);
                continue;
            }
            log.error("Unknown file type: " + path);
        }
        if (airspaces.size() > 0) {
            HashSet<String> airspacesHash = new HashSet<String>();
            ListIterator it = airspaces.listIterator();
            while (it.hasNext()) {
                AirspaceArea area = (AirspaceArea)it.next();
                if (!airspacesHash.contains(area.getUniqueHash())) {
                    airspacesHash.add(area.getUniqueHash());
                    continue;
                }
                it.remove();
            }
            airspaceFacade.insertAirspaces(airspaces, false);
        }
        log.info("Import finished.");
    }

    /*
     * Exception decompiling
     */
    private static AipFileType getAipType(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static enum AipFileType {
        AIRPORTS,
        NAVAIDS,
        AIRSPACES;

    }
}

