/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aip;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.sql.entity.Navaid;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.aip.navaid.OPENAIP;
import org.apache.log4j.Logger;

public class AipNavaidUtil {
    private static final Logger log = Logger.getLogger(AipNavaidUtil.class);
    private static final String SUPPORTED_DATA_VERSION_NAVAIDS = "1.1";
    private static final Map<String, String> TYPE_MAPPINGS;

    public static void importNavaids(String file, boolean truncateTable) {
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        navaidFacade.insertNavaids(AipNavaidUtil.loadNavaids(file), truncateTable);
    }

    public static List<Navaid> loadNavaids(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OPENAIP.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            OPENAIP xml = (OPENAIP)jaxbUnmarshaller.unmarshal(new File(file));
            return AipNavaidUtil.getNavaidsFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<Navaid> getNavaidsFromXml(OPENAIP xml) {
        ArrayList<Navaid> navaids = new ArrayList<Navaid>();
        if (SUPPORTED_DATA_VERSION_NAVAIDS.equals(xml.getDATAFORMAT())) {
            if (xml != null) {
                for (OPENAIP.NAVAIDS.NAVAID xn : xml.getNAVAIDS().getNAVAID()) {
                    Navaid n = new Navaid();
                    n.setCountry(xn.getCOUNTRY());
                    n.setIdent(xn.getID());
                    n.setName(xn.getNAME());
                    if (xn.getGEOLOCATION() != null) {
                        n.setLat(xn.getGEOLOCATION().getLAT());
                        n.setLon(xn.getGEOLOCATION().getLON());
                        if (xn.getGEOLOCATION().getELEV() != null) {
                            double elev = xn.getGEOLOCATION().getELEV().getValue();
                            if ("M".equals(xn.getGEOLOCATION().getELEV().getUNIT())) {
                                elev = UnitUtil.recalculateAltitude(elev, "m", "ft", false);
                            }
                            n.setAlt((int)Math.round(elev));
                        }
                    }
                    if (xn.getPARAMS() != null) {
                        if (!"FALSE".equalsIgnoreCase(xn.getPARAMS().getALIGNEDTOTRUENORTH())) {
                            n.setMagvar(0.0);
                        } else {
                            n.setMagvar(xn.getPARAMS().getDECLINATION());
                        }
                    }
                    if (xn.getTYPE() != null && TYPE_MAPPINGS.get(xn.getTYPE()) != null) {
                        n.setType(TYPE_MAPPINGS.get(xn.getTYPE()));
                    }
                    if (xn.getRADIO() != null && !StringUtil.isEmpty(xn.getRADIO().getFREQUENCY())) {
                        try {
                            double freq = Double.valueOf(xn.getRADIO().getFREQUENCY().replaceAll(",", "."));
                            freq = n.isNdb() ? (freq *= 10.0) : (freq *= 1000.0);
                            n.setFreq((int)Math.round(freq));
                        }
                        catch (NumberFormatException e) {
                            log.error(e, e);
                        }
                    }
                    if (AipNavaidUtil.validateNavaid(n)) {
                        navaids.add(n);
                        continue;
                    }
                    log.fatal("INVALID NAVAID: " + n);
                }
            }
        } else {
            log.fatal("Unsupported data version for navaids: " + xml.getDATAFORMAT());
        }
        return navaids;
    }

    private static boolean validateNavaid(Navaid n) {
        return n.getIdent() != null && n.getType() != null && n.getLat() != null && n.getLon() != null;
    }

    static {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("DME", "DME");
        mp.put("TACAN", "TACAN");
        mp.put("NDB", "NDB");
        mp.put("VOR", "VOR");
        mp.put("VOR-DME", "VOR-DME");
        mp.put("VORTAC", "VORTAC");
        mp.put("DVOR", "VOR");
        mp.put("DVOR-DME", "VOR-DME");
        mp.put("DVORTAC", "VORTAC");
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

