/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aip;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.core.sql.type.AltitudeType;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.xml.aip.airspace.OPENAIP;
import org.apache.log4j.Logger;

public class AipAirspaceUtil {
    private static final Logger log = Logger.getLogger(AipAirspaceUtil.class);
    private static final String SUPPORTED_DATA_VERSION_AIRSPACES = "1.1";
    private static final Map<String, AirspaceType> TYPE_MAPPINGS;

    public static void importAirspaces(String file, boolean truncateTable) {
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        airspaceFacade.insertAirspaces(AipAirspaceUtil.loadAirspaces(file), truncateTable);
    }

    public static List<AirspaceArea> loadAirspaces(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OPENAIP.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            OPENAIP xml = (OPENAIP)jaxbUnmarshaller.unmarshal(new File(file));
            return AipAirspaceUtil.getAirspacesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<AirspaceArea> getAirspacesFromXml(OPENAIP xml) {
        ArrayList<AirspaceArea> airspaces = new ArrayList<AirspaceArea>();
        if (SUPPORTED_DATA_VERSION_AIRSPACES.equals(xml.getDATAFORMAT())) {
            if (xml != null) {
                for (OPENAIP.AIRSPACES.ASP xn : xml.getAIRSPACES().getASP()) {
                    if (xn.getCATEGORY() != null && "FIR".equals(xn.getCATEGORY())) continue;
                    AirspaceArea ar = new AirspaceArea();
                    ar.setName(xn.getNAME());
                    try {
                        ar.setType(TYPE_MAPPINGS.get(xn.getCATEGORY()));
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Unknown AirspaceType: " + xn.getCATEGORY());
                    }
                    if (xn.getALTLIMITBOTTOM() != null && xn.getALTLIMITBOTTOM().getREFERENCE() != null) {
                        if (xn.getALTLIMITBOTTOM().getALT() != null) {
                            double elev = xn.getALTLIMITBOTTOM().getALT().getValue();
                            if ("FL".equals(xn.getALTLIMITBOTTOM().getALT().getUNIT())) {
                                elev *= 100.0;
                            }
                            ar.setBottomAltitude((int)Math.round(elev));
                        }
                        try {
                            ar.setBottomAltitudeType(AltitudeType.valueOf(xn.getALTLIMITBOTTOM().getREFERENCE()));
                        }
                        catch (IllegalArgumentException e) {
                            log.debug("Unknown AltitudeType: " + xn.getALTLIMITBOTTOM().getREFERENCE());
                        }
                    }
                    if (xn.getALTLIMITTOP() != null && xn.getALTLIMITTOP().getREFERENCE() != null) {
                        if (xn.getALTLIMITTOP().getALT() != null) {
                            double elev = xn.getALTLIMITTOP().getALT().getValue();
                            if ("FL".equals(xn.getALTLIMITTOP().getALT().getUNIT())) {
                                elev *= 100.0;
                            }
                            ar.setTopAltitude((int)Math.round(elev));
                        }
                        try {
                            ar.setTopAltitudeType(AltitudeType.valueOf(xn.getALTLIMITTOP().getREFERENCE()));
                        }
                        catch (IllegalArgumentException e) {
                            log.debug("Unknown AltitudeType: " + xn.getALTLIMITTOP().getREFERENCE());
                        }
                    }
                    if (xn.getGEOMETRY() != null && xn.getGEOMETRY().getPOLYGON() != null) {
                        String[] vertices;
                        for (String vertex : vertices = xn.getGEOMETRY().getPOLYGON().split(",")) {
                            String[] coords = vertex.trim().split(" ");
                            if (coords.length == 2) {
                                try {
                                    double lon = Double.valueOf(coords[0]);
                                    double lat = Double.valueOf(coords[1]);
                                    ar.getVertices().add(new AirspaceAreaVertex(lat, (Double)lon));
                                }
                                catch (NumberFormatException e) {
                                    log.error(e, e);
                                }
                                continue;
                            }
                            log.error("Invalid geometry vertex for " + xn.getNAME() + " [" + vertex + "]");
                        }
                    } else {
                        log.error("Missing geometry for " + xn.getNAME());
                    }
                    if (AipAirspaceUtil.validateAirspace(ar)) {
                        airspaces.add(ar);
                        continue;
                    }
                    log.fatal("INVALID AIRSPACE: " + ar);
                }
            }
        } else {
            log.fatal("Unsupported data version for airports: " + xml.getDATAFORMAT());
        }
        return airspaces;
    }

    private static boolean validateAirspace(AirspaceArea ar) {
        return ar.getVertices().size() != 0;
    }

    static {
        HashMap<String, AirspaceType> mp = new HashMap<String, AirspaceType>();
        mp.put("A", AirspaceType.CLASS_A);
        mp.put("B", AirspaceType.CLASS_B);
        mp.put("C", AirspaceType.CLASS_C);
        mp.put("D", AirspaceType.CLASS_D);
        mp.put("E", AirspaceType.CLASS_E);
        mp.put("F", AirspaceType.CLASS_F);
        mp.put("G", AirspaceType.CLASS_G);
        mp.put("CTR", AirspaceType.CTR);
        mp.put("DANGER", AirspaceType.DANGER);
        mp.put("GLIDING", AirspaceType.TRA);
        mp.put("OTH", AirspaceType.OTHER);
        mp.put("RESTRICTED", AirspaceType.RESTRICTED);
        mp.put("TMA", AirspaceType.TMA);
        mp.put("TMZ", AirspaceType.TMZ);
        mp.put("WAVE", AirspaceType.TSA);
        mp.put("PROHIBITED", AirspaceType.PROHIBITED);
        mp.put("UIR", AirspaceType.UIR);
        mp.put("RMZ", AirspaceType.RMZ);
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

