/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util.aip;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.sql.type.AirportFreqType;
import main.java.guru.vfrflight.core.sql.type.AirportType;
import main.java.guru.vfrflight.core.sql.type.RunwayOperations;
import main.java.guru.vfrflight.core.sql.type.Surface;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.ImportFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.geo.RealWorldCalculator;
import main.java.guru.vfrflight.xml.aip.airport.OPENAIP;
import org.apache.log4j.Logger;
import org.hsqldb.lib.StringUtil;

public class AipAirportUtil {
    private static final Logger log = Logger.getLogger(AipAirportUtil.class);
    private static final String SUPPORTED_DATA_VERSION_AIRPORTS = "1.1";
    private static final Map<String, Surface> SURFACE_MAPPINGS;

    public static void importAirports(String file, boolean truncateTable) {
        AirportFacade aiportFacade = new AirportFacade(DBUtil.getDataSource());
        List<Airport> airports = AipAirportUtil.loadAirports(file);
        MapFacade mapFacade = new MapFacade(DBUtil.getDataSource());
        ImportFacade importFacade = new ImportFacade(DBUtil.getDataSource());
        importFacade.setMountanousAirports(airports, mapFacade.findElevations(0));
        importFacade.setHardenedAirports(airports);
        aiportFacade.insertAirports(airports, truncateTable);
    }

    public static List<Airport> loadAirports(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OPENAIP.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            OPENAIP xml = (OPENAIP)jaxbUnmarshaller.unmarshal(new File(file));
            return AipAirportUtil.getAirportsFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<Airport> getAirportsFromXml(OPENAIP xml) {
        RealWorldCalculator declCalc = new RealWorldCalculator();
        ArrayList<Airport> airports = new ArrayList<Airport>();
        HashSet<String> airportsIdents = new HashSet<String>();
        if (SUPPORTED_DATA_VERSION_AIRPORTS.equals(xml.getDATAFORMAT())) {
            if (xml != null) {
                for (OPENAIP.WAYPOINTS.AIRPORT xn : xml.getWAYPOINTS().getAIRPORT()) {
                    Airport a = new Airport();
                    a.setIdent(xn.getICAO());
                    a.setName(xn.getNAME());
                    if (xn.getGEOLOCATION() != null) {
                        a.setLat(xn.getGEOLOCATION().getLAT());
                        a.setLon(xn.getGEOLOCATION().getLON());
                        try {
                            a.setType(AirportType.valueOf(xn.getTYPE()));
                            if (AirportType.HELI_CIVIL.equals((Object)a.getType()) || AirportType.HELI_MIL.equals((Object)a.getType())) {
                                a.setHeli(true);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            log.debug("Unknown AirportType: " + xn.getTYPE());
                        }
                        GpsPlace center = new GpsPlace(a.getLat(), a.getLon());
                        a.setMagvar(declCalc.getMagneticDeclination(center));
                        if (xn.getGEOLOCATION().getELEV() != null) {
                            double elev = xn.getGEOLOCATION().getELEV().getValue();
                            if ("M".equals(xn.getGEOLOCATION().getELEV().getUNIT())) {
                                elev = UnitUtil.recalculateAltitude(elev, "m", "ft", false);
                            }
                            a.setElev((int)Math.round(elev));
                        }
                        if (xn.getRADIO() != null) {
                            for (OPENAIP.WAYPOINTS.AIRPORT.RADIO rADIO : xn.getRADIO()) {
                                AirportFreq f = new AirportFreq();
                                f.setName(rADIO.getDESCRIPTION());
                                f.setFrequency(rADIO.getFREQUENCY());
                                try {
                                    f.setType(AirportFreqType.valueOf(rADIO.getTYPE()));
                                }
                                catch (IllegalArgumentException e) {
                                    log.debug("Unknown AirportFreqType: " + rADIO.getTYPE());
                                }
                                a.getFrequencies().add(f);
                            }
                        }
                        if (xn.getRWY() != null) {
                            for (OPENAIP.WAYPOINTS.AIRPORT.RWY rWY : xn.getRWY()) {
                                if (rWY.getDIRECTION() != null && rWY.getDIRECTION().size() > 0) {
                                    Object length = null;
                                    Double width = null;
                                    if (rWY.getLENGTH() != null) {
                                        length = rWY.getLENGTH().getValue();
                                        if ("F".equals(rWY.getLENGTH().getUNIT())) {
                                            length = UnitUtil.recalculateAltitude((Double)length, "ft", "m", false);
                                        }
                                    }
                                    if (rWY.getWIDTH() != null) {
                                        width = rWY.getWIDTH().getValue();
                                        if ("F".equals(rWY.getWIDTH().getUNIT())) {
                                            width = UnitUtil.recalculateAltitude(width, "ft", "m", false);
                                        }
                                    }
                                    RunwayOperations operations = null;
                                    try {
                                        operations = RunwayOperations.valueOf(rWY.getOPERATIONS());
                                    }
                                    catch (IllegalArgumentException e) {
                                        log.debug("Unknown RunwayOperations: " + rWY.getOPERATIONS());
                                    }
                                    Surface surf = null;
                                    try {
                                        surf = SURFACE_MAPPINGS.get(rWY.getSFC());
                                    }
                                    catch (IllegalArgumentException e) {
                                        log.debug("Unknown AirportRunwaysSurface: " + rWY.getSFC());
                                    }
                                    boolean alreadyAdded = false;
                                    for (OPENAIP.WAYPOINTS.AIRPORT.RWY.DIRECTION d : rWY.getDIRECTION()) {
                                        if (d.getLANDINGAIDS() != null && d.getLANDINGAIDS().getILS() != null) {
                                            a.setIls(Boolean.TRUE);
                                        }
                                        if (!alreadyAdded && d.getTC() != null) {
                                            String rwyName;
                                            Runway rwy = new Runway();
                                            double magCrs = d.getTC();
                                            boolean magnetic = false;
                                            if (!StringUtil.isEmpty(rWY.getNAME()) && (rwyName = rWY.getNAME().replaceAll("\\s+", "").replaceAll("N\\/", "36/").replaceAll("\\/N", "/36").replaceAll("S\\/", "18/").replaceAll("\\/S", "/18").replaceAll("E\\/", "09/").replaceAll("\\/E", "/09").replaceAll("W\\/", "27/").replaceAll("\\/W", "/27")).matches("[0-9]{2}\\/[0-9]{2}")) {
                                                int num = AipAirportUtil.getRwyNumberFromMagCourse(magCrs);
                                                int primaryNum = Integer.valueOf(rwyName.substring(0, 2));
                                                int secondaryNum = Integer.valueOf(rwyName.substring(3, 5));
                                                if (num == primaryNum || num == secondaryNum) {
                                                    magnetic = true;
                                                }
                                            }
                                            if (!magnetic) {
                                                magCrs = GpsUtil.normalizeCourse(magCrs - a.getMagvar());
                                            }
                                            rwy.setNumber(AipAirportUtil.getRwyNumberFromMagCourse(magCrs));
                                            rwy.setHeading(magCrs);
                                            rwy.setLength((Double)length);
                                            rwy.setWidth(width);
                                            rwy.setOperations(operations);
                                            rwy.setSurface(surf);
                                            a.getRunways().add(rwy);
                                            alreadyAdded = true;
                                            continue;
                                        }
                                        if (d.getTC() != null) continue;
                                        log.error("RWY " + rWY.getNAME() + " of " + xn.getICAO() + ": empty runway direction tag!");
                                    }
                                    continue;
                                }
                                log.error("RWY " + rWY.getNAME() + " of " + xn.getICAO() + ": missing runway directions!");
                            }
                            if (a.getRunways().size() > 0) {
                                void var9_18;
                                Double mainRwy = null;
                                Double d = 0.0;
                                for (Runway r : a.getRunways()) {
                                    if (r.getLength() == null || !(r.getLength() > var9_18.doubleValue())) continue;
                                    Double d2 = r.getLength();
                                    mainRwy = r.getHeading();
                                }
                                if (mainRwy != null) {
                                    a.setMainRwy((int)Math.round(mainRwy + a.getMagvar()));
                                }
                                if (var9_18.doubleValue() > 0.0) {
                                    a.setMainLength((int)Math.round(var9_18.doubleValue()));
                                }
                            }
                        }
                    } else {
                        log.error(xn.getICAO() + ": missing geolocation!");
                    }
                    if (AipAirportUtil.validateAirport(a)) {
                        boolean duplicate = false;
                        if (!a.isHeli() && a.getIdentOrName() != null && airportsIdents.contains(a.getIdentOrName())) {
                            for (Airport airport : airports) {
                                double dist;
                                if (!a.getIdentOrName().equals(airport.getIdentOrName()) || !((dist = GpsUtil.getDistance(a.getGpsPlace(), airport.getGpsPlace())) <= 5.0)) continue;
                                duplicate = true;
                                break;
                            }
                        }
                        if (!duplicate) {
                            airportsIdents.add(a.getIdentOrName());
                            airports.add(a);
                            continue;
                        }
                        log.error("DUPLICATE AIRPORT: " + a);
                        continue;
                    }
                    log.fatal("INVALID AIRPORT: " + a);
                }
            }
        } else {
            log.fatal("Unsupported data version for airports: " + xml.getDATAFORMAT());
        }
        return airports;
    }

    private static int getRwyNumberFromMagCourse(double magCrs) {
        int num = (int)Math.round(magCrs / 10.0) % 36;
        if (num == 0) {
            num = 36;
        }
        return num;
    }

    private static boolean validateAirport(Airport a) {
        return a.getLat() != null && a.getLon() != null;
    }

    static {
        HashMap<String, Surface> mp = new HashMap<String, Surface>();
        mp.put("ASPH", Surface.ASPHALT);
        mp.put("CONC", Surface.CONCRETE);
        mp.put("GRAS", Surface.GRASS);
        mp.put("GRVL", Surface.GRAVEL);
        mp.put("ICE", Surface.ICE);
        mp.put("SAND", Surface.SAND);
        mp.put("SNOW", Surface.SNOW);
        mp.put("SOIL", Surface.SOIL);
        mp.put("UNKN", Surface.UNKNOWN);
        mp.put("WATE", Surface.WATER);
        SURFACE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

