/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.search.SearchParams;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;

public class XplaneImportUtil {
    private static final Logger log = Logger.getLogger(XplaneImportUtil.class);

    public static Map<Integer, Boolean> readDatarefsConfig(Map<String, String> prfConfig, String binetPrefix) {
        HashMap<Integer, Boolean> config = new HashMap<Integer, Boolean>();
        for (int i = 0; i <= 133; ++i) {
            String val = prfConfig.get(binetPrefix + i);
            if (val == null) continue;
            config.put(i, "1".equals(val));
        }
        return config;
    }

    public static void importOrtho4XPAirspaces(List<SceneryConfigEntry> entries) {
        List<AirspaceArea> areas = XplaneImportUtil.findOrtho4XPTiles(entries);
        log.info("Found " + areas.size() + " airspaces in directory.");
        if (areas.size() > 0) {
            AirspaceFacade facade = new AirspaceFacade(DBUtil.getDataSource());
            log.info("Deleting all previous ORTHO4XP areas");
            facade.deleteAirspacesByType(AirspaceType.ORTHO4XP);
            log.info("Inserting new ORTHO4XP areas");
            facade.insertAirspaces(areas, false);
        }
        log.info("Done.");
    }

    private static List<AirspaceArea> findOrtho4XPTiles(List<SceneryConfigEntry> entries) {
        ArrayList<AirspaceArea> result = new ArrayList<AirspaceArea>();
        for (SceneryConfigEntry entry : entries) {
            int pos = entry.getPath().indexOf("zOrtho4XP_");
            if (pos < 0 || entry.getPath().length() < pos + "zOrtho4XP_".length() + 7) continue;
            String latLon = entry.getPath().substring(pos + "zOrtho4XP_".length(), pos + "zOrtho4XP_".length() + 7);
            try {
                double lat = Double.valueOf(latLon.substring(0, 3));
                double lon = Double.valueOf(latLon.substring(3, 7));
                AirspaceArea area = new AirspaceArea();
                area.setName(latLon);
                area.setType(AirspaceType.ORTHO4XP);
                area.getVertices().add(new AirspaceAreaVertex(new GpsPlace(lat, lon + 1.0)));
                area.getVertices().add(new AirspaceAreaVertex(new GpsPlace(lat + 1.0, lon + 1.0)));
                area.getVertices().add(new AirspaceAreaVertex(new GpsPlace(lat + 1.0, lon)));
                area.getVertices().add(new AirspaceAreaVertex(new GpsPlace(lat, lon)));
                result.add(area);
            }
            catch (Exception e) {
                log.error("Exception while parsing " + entry.getPath(), e);
            }
        }
        return result;
    }

    public static List<SceneryConfigEntry> readSceneryConfig(String simulatorMainDir) {
        String defaultData;
        SceneryConfigEntry dataEntry;
        String defaultAirportData;
        SceneryConfigEntry entry;
        simulatorMainDir = StringUtil.finishWithSlash(simulatorMainDir);
        ArrayList<SceneryConfigEntry> results = new ArrayList<SceneryConfigEntry>();
        List<String> content = IOUtil.loadTextFileAsRows(simulatorMainDir + "Custom Scenery/scenery_packs.ini");
        if (content != null) {
            for (int i = 0; i < content.size(); ++i) {
                SceneryConfigEntry entry2;
                String line = content.get(i).trim();
                if (!line.startsWith("SCENERY_PACK ") || (entry2 = XplaneImportUtil.parseSceneryResult(simulatorMainDir + line.substring(13), results.size())) == null) continue;
                results.add(entry2);
            }
        }
        if ((entry = XplaneImportUtil.parseSceneryResult(defaultAirportData = simulatorMainDir + "Resources/default scenery/default apt dat/Earth nav data/", results.size())) != null) {
            results.add(entry);
        }
        if ((dataEntry = XplaneImportUtil.parseSceneryResult(defaultData = simulatorMainDir + "Resources/default data/", results.size())) != null) {
            results.add(dataEntry);
        }
        Collections.sort(results, Collections.reverseOrder());
        return results;
    }

    private static SceneryConfigEntry parseSceneryResult(String sceneryPath, int layer) {
        boolean active = new File(sceneryPath).exists();
        SceneryConfigEntry entry = new SceneryConfigEntry(sceneryPath, layer, active);
        if (entry.isActive()) {
            SearchParams searchParams = new SearchParams();
            searchParams.setMaxDepth(0);
            searchParams.setSkipDirs(true);
            searchParams.getPatterns().add("apt.dat");
            searchParams.getPatterns().add("nav.dat");
            searchParams.getPatterns().add("awy.dat");
            searchParams.getPatterns().add("fix.dat");
            searchParams.getPatterns().add("earth_nav.dat");
            searchParams.getPatterns().add("earth_fix.dat");
            searchParams.getPatterns().add("earth_awy.dat");
            Set<DiskObject> bgls = SearchUtil.getRootList(searchParams, sceneryPath);
            entry.setFileCount(bgls.size());
            for (DiskObject obj : bgls) {
                entry.setSize(entry.getSize() + obj.getSize());
            }
            if (bgls.size() == 0) {
                entry.setActive(false);
            }
            return entry;
        }
        return null;
    }

    public static boolean exportFms(String filename, Route route) {
        try {
            if (route.calculate()) {
                StringBuilder sb = new StringBuilder();
                sb.append(XplaneImportUtil.createHeader());
                sb.append(XplaneImportUtil.createRoutePoints(route));
                return IOUtil.saveTextFile(sb.toString(), filename);
            }
        }
        catch (Exception e) {
            log.error(e, e);
        }
        return false;
    }

    private static String createHeader() {
        return "I" + Constants.EOL + "3 version" + Constants.EOL + "1" + Constants.EOL;
    }

    private static String createRoutePoints(Route route) {
        StringBuilder sb = new StringBuilder();
        sb.append(route.getPoints().size() - 1);
        sb.append(Constants.EOL);
        int i = 0;
        for (RoutePlace place : route.getPoints()) {
            sb.append(i == 0 || i == route.getPoints().size() - 1 ? XplaneImportUtil.createAirportLine(place) : XplaneImportUtil.createLatLonLine(place));
            ++i;
        }
        return sb.toString();
    }

    private static String createAirportLine(RoutePlace place) {
        if (!place.getName().matches("^([A-Z0-9]{4})$")) {
            return XplaneImportUtil.createLatLonLine(place);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1 " + place.getName());
        double alt = place.getAlt() != null ? place.getAlt() : 0.0;
        sb.append(" " + XplaneImportUtil.formatDouble(NumberUtil.roundDouble(alt, 6)));
        sb.append(" " + XplaneImportUtil.formatDouble(NumberUtil.roundDouble(place.getLatVal(), 6)));
        sb.append(" " + XplaneImportUtil.formatDouble(NumberUtil.roundDouble(place.getLonVal(), 6)));
        sb.append(Constants.EOL);
        return sb.toString();
    }

    private static String formatDouble(double val) {
        return String.format("%.6f", val).replaceAll(",", "\\.");
    }

    private static String createLatLonLine(RoutePlace place) {
        StringBuilder sb = new StringBuilder();
        sb.append("28 " + XplaneImportUtil.formatGps(place));
        double alt = place.getAlt() != null ? place.getAlt() : 0.0;
        sb.append(" " + XplaneImportUtil.formatDouble(NumberUtil.roundDouble(alt, 6)));
        sb.append(" " + XplaneImportUtil.formatDouble(NumberUtil.roundDouble(place.getLatVal(), 6)));
        sb.append(" " + XplaneImportUtil.formatDouble(NumberUtil.roundDouble(place.getLonVal(), 6)));
        sb.append(Constants.EOL);
        return sb.toString();
    }

    public static String formatGps(RoutePlace place) {
        StringBuilder sb = new StringBuilder();
        sb.append("S".equals(place.getLatHemisphere()) ? "-" : "+");
        String lat = String.valueOf(NumberUtil.roundDouble(Math.abs(place.getLatVal()), 3));
        if ((int)Math.floor(place.getLatVal()) < 10) {
            lat = "0" + lat;
        }
        sb.append(lat);
        sb.append("_");
        sb.append("W".equals(place.getLonHemisphere()) ? "-" : "+");
        String lon = String.valueOf(NumberUtil.roundDouble(Math.abs(place.getLonVal()), 3));
        if ((int)Math.floor(place.getLonVal()) < 10) {
            lon = "00" + lon;
        } else if ((int)Math.floor(place.getLonVal()) < 100) {
            lon = "0" + lon;
        }
        sb.append(lon);
        return sb.toString();
    }

    public static boolean loadFms(File selectedFile) {
        try {
            List<String> lines = IOUtil.loadTextFileAsRows(selectedFile.getAbsolutePath());
            if (lines.size() < 5) {
                return false;
            }
            ArrayList<RoutePlace> points = new ArrayList<RoutePlace>();
            for (int i = 4; i < lines.size(); ++i) {
                RoutePlace place = XplaneImportUtil.parseFmsLine(lines.get(i));
                if (place == null) continue;
                points.add(place);
            }
            FlightPlanBean.getInstance().getRoute().setPoints(points);
            return true;
        }
        catch (Exception e) {
            log.error(e, e);
            return false;
        }
    }

    private static RoutePlace parseFmsLine(String line) {
        if (line == null || line.startsWith("0 ")) {
            return null;
        }
        String[] tokens = line.trim().split("\\s+");
        if (tokens.length >= 5) {
            try {
                RoutePlace place = new RoutePlace();
                place.setName(tokens[1]);
                place.setAlt(Double.valueOf(tokens[2]));
                place.setLat(new GpsCoord(Double.valueOf(tokens[3])));
                place.setLon(new GpsCoord(Double.valueOf(tokens[4])));
                return place;
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFileVersion(String filename) {
        block8: {
            String string;
            String fileHeaderLine;
            BufferedReader br;
            block7: {
                br = null;
                br = new BufferedReader(new FileReader(filename));
                br.readLine();
                fileHeaderLine = br.readLine();
                if (fileHeaderLine != null && fileHeaderLine.length() >= 4) break block7;
                String string2 = null;
                IOUtil.closeQuietly(br);
                return string2;
            }
            try {
                string = fileHeaderLine.substring(0, 4);
            }
            catch (FileNotFoundException e) {
                log.error(e, e);
                IOUtil.closeQuietly(br);
                break block8;
            }
            catch (IOException e2) {
                log.error(e2, e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(br);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(br);
            }
            IOUtil.closeQuietly(br);
            return string;
        }
        return null;
    }
}

