/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.WnBProfile;
import main.java.guru.vfrflight.gui.table.model.row.WnBRow;
import main.java.guru.vfrflight.xml.wnb.Wnbs;
import org.apache.log4j.Logger;

public class WnBProfileUtil {
    private static final Logger log = Logger.getLogger(WnBProfileUtil.class);

    public static List<WnBProfile> loadProfiles(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Wnbs.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Wnbs xml = (Wnbs)jaxbUnmarshaller.unmarshal(new File(file));
            return WnBProfileUtil.getProfilesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<WnBProfile> getProfilesFromXml(Wnbs xml) {
        ArrayList<WnBProfile> profiles = new ArrayList<WnBProfile>();
        if (xml != null) {
            for (Wnbs.Wnb xmlProfile : xml.getWnb()) {
                WnBProfile profile = new WnBProfile(xmlProfile.getName());
                profile.setName(xmlProfile.getName());
                for (Wnbs.Wnb.Remarks xmlRemarks : xmlProfile.getRemarks()) {
                    if (xmlRemarks.getLang() == null) {
                        profile.setRemarks(xmlRemarks.getValue());
                        break;
                    }
                    if (!xmlRemarks.getLang().equals(SettingsBean.getInstance().getLanguageCode())) continue;
                    profile.setRemarks(xmlRemarks.getValue());
                    break;
                }
                profile.setArmUnit(xmlProfile.getArmUnit());
                if (xmlProfile.getMtow() != null) {
                    profile.setMtow(xmlProfile.getMtow().getValue());
                    profile.setMtowUnit(xmlProfile.getMtow().getUnit());
                }
                for (Wnbs.Wnb.Row xmlRow : xmlProfile.getRow()) {
                    WnBRow row = new WnBRow();
                    for (Wnbs.Wnb.Row.Name xmlRowName : xmlRow.getName()) {
                        if (xmlRowName.getLang() == null) {
                            row.setName(xmlRowName.getValue());
                            break;
                        }
                        if (!xmlRowName.getLang().equals(SettingsBean.getInstance().getLanguageCode())) continue;
                        row.setName(xmlRowName.getValue());
                        break;
                    }
                    if (xmlRow.getArm() != null) {
                        row.setArm(xmlRow.getArm().getValue());
                    }
                    if (xmlRow.getQuantity() != null) {
                        row.setQuantity(xmlRow.getQuantity().getValue());
                        row.setQuantityUnit(xmlRow.getQuantity().getUnit());
                    }
                    profile.getRows().add(row);
                }
                profiles.add(profile);
            }
        }
        return profiles;
    }

    public static boolean saveProfiles(List<WnBProfile> profiles, String file) {
        Wnbs xml = WnBProfileUtil.getXml(profiles);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Wnbs.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    private static Wnbs getXml(List<WnBProfile> profiles) {
        Wnbs xml = new Wnbs();
        for (WnBProfile profile : profiles) {
            Wnbs.Wnb xmlProfile = new Wnbs.Wnb();
            xmlProfile.setArmUnit(profile.getArmUnit());
            if (profile.getRemarks() != null) {
                Wnbs.Wnb.Remarks remarks = new Wnbs.Wnb.Remarks();
                remarks.setValue(profile.getRemarks());
                xmlProfile.getRemarks().add(remarks);
            }
            xmlProfile.setName(profile.getName());
            if (profile.getMtow() != null && profile.getMtowUnit() != null) {
                Wnbs.Wnb.Mtow xmlMtow = new Wnbs.Wnb.Mtow();
                xmlMtow.setUnit(profile.getMtowUnit());
                xmlMtow.setValue(profile.getMtow());
                xmlProfile.setMtow(xmlMtow);
            }
            for (WnBRow row : profile.getRows()) {
                Wnbs.Wnb.Row xmlRow = new Wnbs.Wnb.Row();
                if (row.getArm() != null) {
                    Wnbs.Wnb.Row.Arm xmlArm = new Wnbs.Wnb.Row.Arm();
                    xmlArm.setValue(row.getArm());
                    xmlRow.setArm(xmlArm);
                }
                if (row.getQuantity() != null && row.getQuantityUnit() != null) {
                    Wnbs.Wnb.Row.Quantity xmlQuantity = new Wnbs.Wnb.Row.Quantity();
                    xmlQuantity.setUnit(row.getQuantityUnit());
                    xmlQuantity.setValue(row.getQuantity());
                    xmlRow.setQuantity(xmlQuantity);
                }
                if (row.getName() != null) {
                    Wnbs.Wnb.Row.Name name = new Wnbs.Wnb.Row.Name();
                    name.setValue(row.getName());
                    xmlRow.getName().add(name);
                }
                xmlProfile.getRow().add(xmlRow);
            }
            xml.getWnb().add(xmlProfile);
        }
        return xml;
    }
}

