/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import com.luckycatlabs.sunrisesunset.SunriseSunsetCalculator;
import com.luckycatlabs.sunrisesunset.dto.Location;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.VfrMain;
import main.java.guru.vfrflight.bean.JvmParamsBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.bean.theme.ColorTheme;
import main.java.guru.vfrflight.core.DesiredVector;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.core.sql.entity.TaxiName;
import main.java.guru.vfrflight.gui.callable.CalculateVerticalSegmentCallable;
import main.java.guru.vfrflight.gui.concurrent.CalculateVerticalProfileForSegmentTask;
import main.java.guru.vfrflight.gui.concurrent.bean.VerticalProfileResultBean;
import main.java.guru.vfrflight.gui.flightplan.FatalExceptionDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.MeteoViewDialog;
import main.java.guru.vfrflight.gui.flightplan.SplashScreenDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.RefreshAllTask;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.PlaneProfileUtil;
import main.java.guru.vfrflight.util.PropertiesFileReader;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.Timer;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import main.java.org.jdesktop.swingx.mapviewer.TileFactory;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class VfrUtil {
    private static final Logger log = Logger.getLogger(VfrUtil.class);

    public static void setLayerVisibilityAction(final Callable ... tasks) {
        PleaseWaitDialog.getInstance().start();
        MapFrame.getInstance().setMapLayersToolbarEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (Callable task : tasks) {
                    try {
                        VfrUtil.executeTaskInFixedSinglePool(task);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                MapFrame.getInstance().setMapLayersToolbarEnabled(true);
                PleaseWaitDialog.getInstance().stop();
                MapFrame.getInstance().updateMap();
            }
        }).start();
    }

    public static boolean isCurrentVersion() {
        String ver = UrlUtil.readUrl("http://vfrflight.org/ver.php", true);
        return ver != null ? "2.3.1".equals(ver) : true;
    }

    public static boolean isAppExportAvailable() {
        String ver = UrlUtil.readUrl("http://vfrflight.org/app.php", true);
        return ver != null;
    }

    public static double getMagneticDeclination(GpsPlace place) {
        return SettingsBean.getInstance().getDeclinationCalculator().getMagneticDeclination(place);
    }

    public static double getMagneticDeclination(LineSegment segment) {
        return VfrUtil.getMagneticDeclination(segment.getCenter());
    }

    public static GpsPlace getGpsPlaceFromWindowsClipboard() {
        String clipboard = StringUtil.pasteFromClipboard();
        if (clipboard != null) {
            return FormatUtil.stringToGpsPlace(clipboard);
        }
        return null;
    }

    public static String getNextNameFromPoints(String prefix, List<RoutePlace> places) {
        ArrayList<String> names = new ArrayList<String>();
        for (GpsPlace gpsPlace : places) {
            if (gpsPlace.getName() == null) continue;
            names.add(gpsPlace.getName());
        }
        return VfrUtil.getNextName(prefix, names);
    }

    public static String getNextNameFromVfrPoints(String prefix, List<VfrPointDTO> places) {
        ArrayList<String> names = new ArrayList<String>();
        for (VfrPointDTO place : places) {
            if (place.getName() == null) continue;
            names.add(place.getName());
        }
        return VfrUtil.getNextName(prefix, names);
    }

    public static String getNextName(String prefix, List<String> names) {
        String name;
        boolean endLoop;
        int idx = 0;
        block0: do {
            endLoop = true;
            name = prefix + ++idx;
            for (String n : names) {
                if (!name.equals(n)) continue;
                endLoop = false;
                continue block0;
            }
        } while (!endLoop);
        return name;
    }

    public static double calculateScore(String txt, String match) {
        if (txt != null && match != null) {
            int p = (txt = txt.toLowerCase()).indexOf(match = match.toLowerCase());
            if (p >= 0) {
                double s = (double)match.length() / (double)txt.length() + 1.0;
                if (p == 0) {
                    s += 1.0;
                }
                return s;
            }
            for (int i = match.length() - 1; i > 2; --i) {
                String m = match.substring(0, i);
                if (txt.indexOf(m) < 0) continue;
                return (double)m.length() / (double)txt.length() * (double)i / (double)match.length();
            }
        }
        return 0.0;
    }

    public static String getEnvVar(String name) {
        if (VfrUtil.isWindows()) {
            return System.getenv(name);
        }
        return null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").startsWith("Mac OS");
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
    }

    public static Elevation[] calculateVerticalProfile(StoppableTask mainTask, List<RouteSegment> segments, double elevationMaxGridSize, int totalWidth, String pathToDir, int scale, boolean findMaxValue) {
        Timer.getInstance().start("calculateVerticalProfile");
        double totalDistance = GpsUtil.getTotalDistance(new ArrayList<LineSegment>(segments));
        int width = 0;
        double expandValue = 8.326394671107411E-4 * (double)scale;
        ArrayList<Elevation> resultsList = new ArrayList<Elevation>();
        if (!mainTask.isInterrupted()) {
            for (int i = 0; i < segments.size(); ++i) {
                width = i < segments.size() - 1 ? (int)Math.round(segments.get(i).getDistance() / totalDistance * (double)totalWidth) : totalWidth - resultsList.size();
                List<GpsArea> areas = GpsUtil.divideSegmentToAreas(segments.get(i), width, expandValue);
                Elevation[] elevations = null;
                elevations = ElevationsUtil.loadElevationsFromHgtFiles(pathToDir, scale, findMaxValue, segments.get(i).getRectangleOver(), true);
                if (mainTask.isInterrupted() || elevations.length <= 0) continue;
                Timer.getInstance().start("VERTICAL_PROFILE_SEGMENT" + i);
                log.debug("Working on segment " + i + "/" + segments.size());
                Timer.getInstance().start("VERTICAL_PROFILE_SEGMENT" + i + "_ELEVATIONS_IN_AREAS");
                Elevation[] elevInArea = null;
                log.debug("Using single core: getElevationsInAreas");
                if (!mainTask.isInterrupted()) {
                    elevInArea = ElevationsUtil.getElevationsInAreas(elevations, areas.toArray(new GpsArea[areas.size()]));
                    Timer.getInstance().stop("VERTICAL_PROFILE_SEGMENT" + i + "_ELEVATIONS_IN_AREAS", false);
                    log.debug("Elevations in area: " + elevInArea.length);
                }
                Timer.getInstance().start("VERTICAL_PROFILE_SEGMENT" + i + "_CALCULATE_VERTICAL_PROFILE");
                log.debug("Using single core: calculateVerticalProfileForSegment");
                if (!mainTask.isInterrupted()) {
                    resultsList.addAll(VfrUtil.calculateVerticalProfileForSegment(segments.get(i), elevationMaxGridSize, width, elevInArea, scale));
                }
                Timer.getInstance().stop("VERTICAL_PROFILE_SEGMENT" + i + "_CALCULATE_VERTICAL_PROFILE", false);
                Timer.getInstance().stop("VERTICAL_PROFILE_SEGMENT" + i, false);
            }
        }
        Timer.getInstance().stop("calculateVerticalProfile", false);
        if (resultsList.size() == 0) {
            return null;
        }
        return resultsList.toArray(new Elevation[resultsList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Elevation[] calculateVerticalProfileMultiCore(StoppableTask mainTask, List<RouteSegment> segments, double elevationMaxGridSize, int totalWidth, String pathToDir, int scale, boolean findMaxValue) {
        Timer.getInstance().start("calculateVerticalProfileMultiCore");
        double totalDistance = GpsUtil.getTotalDistance(new ArrayList<LineSegment>(segments));
        log.debug("calculateVerticalProfileMultiCore START: " + segments.size() + "; " + elevationMaxGridSize + "; " + totalWidth + "; " + scale + "; ; " + findMaxValue);
        ExecutorService executor = null;
        int width = 0;
        LinkedList resultList = new LinkedList();
        if (!mainTask.isInterrupted() && segments.size() > 1) {
            executor = Executors.newFixedThreadPool(Constants.NTHREDS_IO);
            ArrayList<Future<List<Elevation>>> tasks = new ArrayList<Future<List<Elevation>>>(segments.size() - 1);
            for (int i = 0; i < segments.size() - 1; ++i) {
                width = (int)Math.round(segments.get(i).getDistance() / totalDistance * (double)totalWidth);
                tasks.add(executor.submit(new CalculateVerticalSegmentCallable(segments.get(i), i, pathToDir, elevationMaxGridSize, findMaxValue, width, scale)));
            }
            for (Future future : tasks) {
                try {
                    while (!mainTask.isInterrupted() && !future.isDone()) {
                        Thread.yield();
                    }
                    if (mainTask.isInterrupted()) {
                        future.cancel(true);
                        continue;
                    }
                    List elev = (List)future.get();
                    if (elev == null) continue;
                    resultList.addAll(elev);
                }
                catch (InterruptedException e) {
                    mainTask.setInterrupted(true);
                    log.debug(e, e);
                    break;
                }
                catch (ExecutionException e) {
                    log.error(e, e);
                }
            }
            executor.shutdown();
        }
        if (!mainTask.isInterrupted()) {
            log.debug("calculateVerticalProfileMultiCore LAST SEGMENT");
            executor = Executors.newSingleThreadExecutor();
            width = totalWidth - resultList.size();
            Future<List<Elevation>> task = executor.submit(new CalculateVerticalSegmentCallable(segments.get(segments.size() - 1), segments.size() - 1, pathToDir, elevationMaxGridSize, findMaxValue, width, scale));
            try {
                while (!mainTask.isInterrupted() && !task.isDone()) {
                    Thread.yield();
                }
                if (mainTask.isInterrupted()) {
                    task.cancel(true);
                } else {
                    resultList.addAll(task.get());
                }
            }
            catch (InterruptedException e) {
                mainTask.setInterrupted(true);
                log.debug(e, e);
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
            finally {
                executor.shutdown();
            }
        }
        log.debug("calculateVerticalProfileMultiCore FINISHED: " + resultList.size());
        Timer.getInstance().stop("calculateVerticalProfileMultiCore", false);
        if (resultList.size() == 0) {
            return null;
        }
        return resultList.toArray(new Elevation[resultList.size()]);
    }

    public static List<Elevation> calculateVerticalProfileForSegment(LineSegment segment, double elevationMaxGridSize, int width, Elevation[] elevations, int scale) {
        ArrayList<Elevation> elevValues = new ArrayList<Elevation>();
        if (elevations.length > 0) {
            List<GpsPlace> pointsEnRoute = GpsUtil.divideSegmentToPoints(segment, width);
            for (int i = 0; i < pointsEnRoute.size(); ++i) {
                GpsPlace point = pointsEnRoute.get(i);
                Elevation elevation = null;
                ArrayList<Elevation> excludeList = new ArrayList<Elevation>();
                Elevation resultElev1 = VfrUtil.findMaxElevation(point, elevations, elevationMaxGridSize, excludeList);
                if (resultElev1 != null) {
                    double dist1 = GpsUtil.getDistance(point, resultElev1.getGpsPlace());
                    excludeList.add(resultElev1);
                    Elevation resultElev2 = VfrUtil.findMaxElevation(point, elevations, elevationMaxGridSize, excludeList);
                    if (resultElev2 != null) {
                        double dist2 = GpsUtil.getDistance(point, resultElev2.getGpsPlace());
                        double sum = dist1 + dist2;
                        short elev = (short)Math.round((1.0 - dist1 / sum) * (double)resultElev1.getElev().shortValue() + (1.0 - dist2 / sum) * (double)resultElev2.getElev().shortValue());
                        elevation = new Elevation(point.getLat().getValue(), point.getLon().getValue(), elev);
                    }
                }
                elevValues.add(elevation);
            }
        }
        return elevValues;
    }

    public static List<Elevation> calculateVerticalProfileForSegmentMultiCore(LineSegment segment, double elevationMaxGridSize, int width, Elevation[] elevations, int scale) {
        ArrayList<Elevation> resultsList = new ArrayList<Elevation>();
        if (elevations.length > 0) {
            List<GpsPlace> pointsEnRoute = GpsUtil.divideSegmentToPoints(segment, width);
            if (pointsEnRoute.size() < 50) {
                return VfrUtil.calculateVerticalProfileForSegment(segment, elevationMaxGridSize, width, elevations, scale);
            }
            log.debug("calculateVerticalProfileForSegmentMultiCore: start");
            int size = (int)Math.floor(pointsEnRoute.size() / Constants.NTHREDS);
            ArrayList<ForkJoinTask<VerticalProfileResultBean>> futuresList = new ArrayList<ForkJoinTask<VerticalProfileResultBean>>();
            ForkJoinPool fjPool = new ForkJoinPool(Constants.NTHREDS);
            int from = 0;
            int to = 0;
            for (int index = 0; index < Constants.NTHREDS; ++index) {
                from = index * size;
                to = index < Constants.NTHREDS - 1 ? (index + 1) * size - 1 : pointsEnRoute.size() - 1;
                log.debug("calculateVerticalProfileForSegmentMultiCore: starting task " + index + " / " + Constants.NTHREDS);
                futuresList.add(fjPool.submit(new CalculateVerticalProfileForSegmentTask(index, pointsEnRoute.subList(from, to), elevations, elevationMaxGridSize)));
            }
            HashMap<Integer, List<Elevation>> elevValues = new HashMap<Integer, List<Elevation>>();
            VerticalProfileResultBean resultTask = null;
            int i = 0;
            for (Future future : futuresList) {
                try {
                    resultTask = (VerticalProfileResultBean)future.get();
                    elevValues.put(resultTask.getIndex(), resultTask.getElevation());
                    log.debug("calculateVerticalProfileForSegmentMultiCore: waiting for task " + ++i + " / " + futuresList.size() + " finished");
                }
                catch (InterruptedException e) {
                    --i;
                }
                catch (ExecutionException e) {
                    --i;
                }
            }
            for (i = 0; i < Constants.NTHREDS; ++i) {
                resultsList.addAll((Collection)elevValues.get(i));
            }
            log.debug("calculateVerticalProfileForSegmentMultiCore: all tasks finished");
        }
        return resultsList;
    }

    public static Elevation findMaxElevation(GpsPlace point, Elevation[] elevations, double elevationMaxGridSize, List<Elevation> excludeList) {
        if (excludeList == null) {
            excludeList = new ArrayList<Elevation>();
        }
        Elevation resultElev = null;
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < elevations.length; ++i) {
            double d;
            if (excludeList.contains(elevations[i]) || !((d = GpsUtil.getDistance(point, elevations[i].getGpsPlace())) <= elevationMaxGridSize) || !(d < dist)) continue;
            dist = d;
            resultElev = elevations[i];
        }
        return resultElev;
    }

    public static short[] getSamples(Elevation[] elev) {
        short[] result = new short[elev.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = elev[i] != null && elev[i].getElev() != null ? elev[i].getElev() : (short)0;
        }
        return result;
    }

    public static long getSignedLongFromUnsignedInt(int unsigned) {
        return (long)unsigned & 0xFFFFFFFFL;
    }

    public static long getUInt32(byte[] bytes) {
        long value = bytes[0] & 0xFF;
        value |= (long)(bytes[1] << 8 & 0xFFFF);
        value |= (long)(bytes[2] << 16 & 0xFFFFFF);
        return value |= (long)(bytes[3] << 24 & 0xFFFFFFFF);
    }

    public static short byte2short(byte[] arr) {
        return ByteBuffer.wrap(arr).getShort();
    }

    public static double byte2double(byte[] arr) {
        return ByteBuffer.wrap(arr).getDouble();
    }

    public static int byte2int(byte[] arr) {
        return ByteBuffer.wrap(arr).getInt();
    }

    public static boolean checkHeapSize() {
        long heapSize = Math.round(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        long heapMaxSize = Math.round(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        long heapFreeSize = Math.round(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        log.info("heapSize: " + heapSize + "; heapMaxSize: " + heapMaxSize + "; heapFreeSize: " + heapFreeSize);
        if (!VfrUtil.isMacOS() && heapFreeSize < 128L) {
            return GuiUtil.showConfirmationDialog(null, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("heap_size_too_small"));
        }
        return true;
    }

    public static long getFreeHeapSpace() {
        return Runtime.getRuntime().freeMemory() / 1024L / 1024L;
    }

    public static String[] getSupportedImageTypes() {
        HashSet<String> set = new HashSet<String>();
        String[] formatNames = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formatNames.length; ++i) {
            set.add(formatNames[i].toUpperCase());
        }
        return set.toArray(new String[set.size()]);
    }

    public static Double[] getLinearEquation(Point2D a, Point2D b) {
        Double[] result = new Double[2];
        if (b.getX() != a.getX()) {
            result[0] = (b.getY() - a.getY()) / (b.getX() - a.getX());
            result[1] = a.getY() - result[0] * a.getX();
        }
        return result;
    }

    public static Double[] getPerpendicularLine(Point2D point, double a, double b) {
        Double[] result;
        result = new Double[]{NumberUtil.doubleEqualsZero(a) ? Double.valueOf(0.0) : Double.valueOf(-1.0 / a), point.getY() - result[0] * point.getX()};
        return result;
    }

    public static boolean isPointOnLine(Point2D point, Point2D lineA, Point2D lineB) {
        return VfrUtil.isPointOnLine(point, lineA, lineB, null);
    }

    public static boolean isPointOnLine(Point2D point, Point2D lineA, Point2D lineB, Double tolerance) {
        Double[] coofs = VfrUtil.getLinearEquation(lineA, lineB);
        double y = coofs[0] * point.getX() + coofs[1];
        if (tolerance == null) {
            tolerance = 1.0E-5;
        }
        return Math.abs(y - point.getY()) < tolerance;
    }

    public static GpsPoint[] getCommonPointsCircleLine(GpsPoint pointA, GpsPoint pointB, GpsPoint center, double radius) {
        double c;
        double q;
        double a;
        double caY;
        double baX = pointB.getX() - pointA.getX();
        double baY = pointB.getY() - pointA.getY();
        double caX = center.getX() - pointA.getX();
        double bBy2 = baX * caX + baY * (caY = center.getY() - pointA.getY());
        double pBy2 = bBy2 / (a = baX * baX + baY * baY);
        double disc = pBy2 * pBy2 - (q = (c = caX * caX + caY * caY - radius * radius) / a);
        if (disc < 0.0) {
            return null;
        }
        GpsPoint[] result = new GpsPoint[2];
        double tmpSqrt = Math.sqrt(disc);
        double abScalingFactor1 = -pBy2 + tmpSqrt;
        double abScalingFactor2 = -pBy2 - tmpSqrt;
        result[0] = new GpsPoint(pointA.getX() - baX * abScalingFactor1, pointA.getY() - baY * abScalingFactor1);
        result[1] = disc == 0.0 ? result[0] : new GpsPoint(pointA.getX() - baX * abScalingFactor2, pointA.getY() - baY * abScalingFactor2);
        return result;
    }

    public static double getLineGradient(GpsPoint pointA, GpsPoint pointB) {
        if (pointB.getX() < pointA.getX()) {
            GpsPoint temp = pointB;
            pointB = pointA;
            pointA = temp;
        } else if (pointB.getX() == pointA.getX()) {
            return 0.0;
        }
        double diffX = pointB.getX() - pointA.getX();
        double diffY = pointB.getY() - pointA.getY();
        return Math.atan(diffY / diffX);
    }

    public static GpsPoint[] getPointsOnWP(GpsPoint p1, GpsPoint p2, double radius) {
        GpsPoint[] commonPointsP1 = VfrUtil.getCommonPointsCircleLine(p1, p2, p1, radius);
        GpsPoint[] commonPointsP2 = VfrUtil.getCommonPointsCircleLine(p1, p2, p2, radius);
        if (commonPointsP1 != null && commonPointsP2 != null) {
            double d2;
            GpsPoint[] result = new GpsPoint[2];
            double d1 = commonPointsP1[0].distance(p2);
            result[0] = d1 < (d2 = commonPointsP1[1].distance(p2)) ? commonPointsP1[0] : commonPointsP1[1];
            d1 = commonPointsP2[0].distance(p1);
            d2 = commonPointsP2[1].distance(p1);
            result[1] = d1 < d2 ? commonPointsP2[0] : commonPointsP2[1];
            return result;
        }
        return null;
    }

    public static DesiredVector getDesiredVector(GpsPlace from, GpsPlace to, Double cruiseSpeedKt, Double windSpeedKt, Double windDirection) {
        LineSegment seg = GpsUtil.getLineSegment(from, to);
        double distNm = seg.getDistance();
        if (distNm > 0.5) {
            double magvar = VfrUtil.getMagneticDeclination(seg);
            Double mh = VfrUtil.calculateMagneticHeading(cruiseSpeedKt, seg.getCourse(), windSpeedKt, windDirection, magvar);
            double gsKt = VfrUtil.calculateGSForWind(cruiseSpeedKt, seg.getCourse(), windSpeedKt, windDirection);
            long t = Math.round(seg.getDistance() / gsKt * 3600.0);
            return new DesiredVector(mh, t, distNm);
        }
        return null;
    }

    public static double calculateMagneticHeading(double tasSpeed, double trueSegmentCourse, double windSpeed, double windDirection, double magvar) {
        double windCorrection = VfrUtil.calculateWindCorectionAngle(tasSpeed, trueSegmentCourse, windSpeed, windDirection);
        return GpsUtil.normalizeCourse(trueSegmentCourse - magvar + windCorrection);
    }

    public static double calculateWindCorectionAngle(double tasSpeed, double segmentCourse, double windSpeed, double windDirection) {
        double Kw;
        double Dn = windDirection;
        if (Dn >= 180.0) {
            Dn -= 180.0;
        }
        if ((Kw = Dn - segmentCourse) <= -180.0) {
            Kw += 360.0;
        }
        double kzmax = windSpeed * 60.0 / tasSpeed;
        double Kz = Math.abs(Math.sin(Math.toRadians(Kw)) * kzmax);
        double navWind = GpsUtil.normalizeCourse(windDirection - 180.0);
        double windAngle = 0.0;
        windAngle = segmentCourse <= 180.0 ? GpsUtil.normalizeCourse(navWind - segmentCourse) : GpsUtil.normalizeCourse(navWind + (360.0 - segmentCourse));
        if (Kz != 0.0 && windAngle > 0.0 && windAngle < 180.0) {
            Kz = -1.0 * Kz;
        }
        return Kz;
    }

    public static double calculateGSForWind(double tasSpeed, double segmentCourse, double windSpeed, double windDirection) {
        double Kw;
        double Dn = windDirection;
        if (Dn >= 180.0) {
            Dn -= 180.0;
        }
        if ((Kw = Dn - segmentCourse) <= -180.0) {
            Kw += 360.0;
        }
        double kzmax = windSpeed * 60.0 / tasSpeed;
        double Kz = Math.abs(Math.sin(Math.toRadians(Kw)) * kzmax);
        double dW = windSpeed * Math.abs(Math.cos(Math.toRadians(Kw)));
        double navWind = GpsUtil.normalizeCourse(windDirection - 180.0);
        double windAngle = 0.0;
        windAngle = segmentCourse <= 180.0 ? GpsUtil.normalizeCourse(navWind - segmentCourse) : GpsUtil.normalizeCourse(navWind + (360.0 - segmentCourse));
        if (Kz != 0.0 && windAngle > 0.0 && windAngle < 180.0) {
            Kz = -1.0 * Kz;
        }
        if (windAngle > 90.0 && windAngle < 270.0) {
            dW = -1.0 * dW;
        }
        return tasSpeed + dW;
    }

    public static String getBuildString() {
        return "build " + VfrUtil.getBuildNumber() + " (java " + System.getProperty("java.version") + ")";
    }

    public static String getBuildNumber() {
        String gitSha = PropertiesFileReader.getGitSha1();
        if (gitSha == null) {
            return Messages.getInstance().get("not_available");
        }
        if (gitSha.length() < 10) {
            return gitSha;
        }
        return gitSha.substring(0, 10);
    }

    public static void optimizeForMaxPerformance(GpsPlace userPlane, Route route) {
        ArrayList<GpsVertex> places = new ArrayList<GpsVertex>(route.getPoints());
        places.addAll(route.getVors());
        places.add((RoutePlace)userPlane);
        if (places.size() > 0) {
            GpsArea area = GpsUtil.getRectangleOverVertices(places);
            area.expand(1.0);
            SettingsBean.getInstance().setParamMapRegionSelected(1);
            SettingsBean.getInstance().setMapObjectsUserRegion(area);
            VfrUtil.setLayerVisibilityAction(new RefreshAllTask());
            MapFrame.getInstance().setSelectedRegion(1, false);
        }
        System.gc();
    }

    public static void waitUntilThreadsAreFinished(Thread[] threads) {
        boolean stop = false;
        boolean anyRunning = false;
        while (!stop) {
            anyRunning = false;
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].isAlive()) continue;
                anyRunning = true;
                break;
            }
            if (anyRunning) continue;
            stop = true;
        }
    }

    public static void waitMilis(long milis) {
        long timeMilis = System.currentTimeMillis();
        do {
            LockSupport.parkNanos(250L);
        } while (System.currentTimeMillis() - timeMilis < milis);
    }

    public static String getVersion() {
        return "2.3.1";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveLaunch4jIni(JvmParamsBean bean) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File("VfrFlight.l4j.ini"));
            out.write("# Launch4j runtime config" + Constants.EOL);
            out.write("-Xms" + bean.getXms() + "m" + Constants.EOL);
            out.write("-Xmx" + bean.getXmx() + "m" + Constants.EOL);
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static JvmParamsBean readLaunch4jIni() {
        JvmParamsBean bean = new JvmParamsBean();
        BufferedReader br = null;
        try {
            int pos2;
            String xmx;
            int pos22;
            br = new BufferedReader(new FileReader(new File("VfrFlight.l4j.ini")));
            br.readLine();
            String xms = br.readLine();
            int pos = xms.indexOf("-Xms");
            if (pos >= 0 && (pos22 = xms.indexOf("m", pos += 4)) >= 0) {
                bean.setXms(Integer.valueOf(xms.substring(pos, pos22)));
            }
            if ((pos = (xmx = br.readLine()).indexOf("-Xmx")) >= 0 && (pos2 = xmx.indexOf("m", pos += 4)) >= 0) {
                bean.setXmx(Integer.valueOf(xmx.substring(pos, pos2)));
            }
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't load launch4j ini", e);
            JvmParamsBean jvmParamsBean = null;
            IOUtil.closeQuietly(br);
            return jvmParamsBean;
        }
        catch (IOException e2) {
            log.error("Couldn't load launch4j ini", e2);
            JvmParamsBean jvmParamsBean = null;
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
            return jvmParamsBean;
        }
        IOUtil.closeQuietly(br);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveCommandFileWindows(JvmParamsBean bean) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File("VfrFlight.cmd"));
            out.write("javaw -Xms" + bean.getXms() + "m -Xmx" + bean.getXmx() + "m -Dfile.encoding=UTF-8 -jar vfr-flight.jar %1");
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveCommandFileLinux(JvmParamsBean bean) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File("VfrFlight-linux.sh"));
            out.write("#!/bin/bash" + Constants.EOL);
            out.write("nohup java -Xms" + bean.getXms() + "m -Xmx" + bean.getXmx() + "m -Dfile.encoding=UTF-8 -jar vfr-flight.jar $1 &");
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean saveCommandFileMacOs(JvmParamsBean bean) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(new File("VfrFlight-macos.sh"));
            out.write("#!/bin/bash" + Constants.EOL);
            out.write("nohup java -Xms" + bean.getXms() + "m -Xmx" + bean.getXmx() + "m -Dfile.encoding=UTF-8 -jar vfr-flight.jar $1 &");
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    public static void configureLoggers(Level fileLogLevel, Level consoleLogLevel) {
        if (Level.TRACE.equals(fileLogLevel) || Level.TRACE.equals(consoleLogLevel)) {
            Logger.getRootLogger().setLevel(Level.TRACE);
        } else if (Level.DEBUG.equals(fileLogLevel) || Level.DEBUG.equals(consoleLogLevel)) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        FileAppender fa = new FileAppender();
        fa.setName("FileLogger");
        fa.setFile("vfrflight.log");
        fa.setLayout(new PatternLayout("%d{yyyy-MM-dd HH:mm:ss,SSS} %5p [%t] (%F:%L) - %m%n"));
        fa.setThreshold(fileLogLevel);
        fa.setAppend(true);
        fa.activateOptions();
        Logger.getRootLogger().addAppender(fa);
        Logger.getLogger("org.hibernate").setLevel(Level.ERROR);
        Logger.getLogger("org.jxmapviewer").setLevel(Level.ERROR);
        log.info("Logger levels: " + Logger.getRootLogger().getLevel() + "; " + fileLogLevel + "; " + consoleLogLevel);
    }

    public static void setGlobalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                VfrUtil.createExceptionDialog(t, e);
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(null);
    }

    public static void supressGlobalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error(e, e);
            }
        });
    }

    public static void createExceptionDialog(Throwable e) {
        VfrUtil.createExceptionDialog(null, e);
    }

    public static void createExceptionDialog(Thread t, Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stacktrace = sw.toString();
        log.error("Uncaught Exception in thread '" + (t != null ? t.getName() : "") + "'", e);
        FatalExceptionDialog dialog = new FatalExceptionDialog(new Date().toString() + Constants.EOL + VfrUtil.getBuildString() + Constants.EOL + System.getProperty("os.name") + Constants.EOL + System.getProperty("java.vm.name") + Constants.EOL + Constants.EOL + stacktrace);
        dialog.setVisible(true);
        if (dialog.isCloseApplication()) {
            log.error("Closing application after exception");
            VfrMain.exit();
        }
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static String getSunriseForPlace(GpsPlace place, Calendar date) {
        Location location = new Location(place.getLat().getValue(), place.getLon().getValue());
        SunriseSunsetCalculator calculator = new SunriseSunsetCalculator(location, TimeZone.getTimeZone("UTC"));
        Calendar officialSunrise = calculator.getOfficialSunriseCalendarForDate(date);
        if (officialSunrise != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm z");
            dateFormat.setTimeZone(officialSunrise.getTimeZone());
            return dateFormat.format(officialSunrise.getTime());
        }
        return null;
    }

    public static String getSunsetForPlace(GpsPlace place, Calendar date) {
        Location location = new Location(place.getLat().getValue(), place.getLon().getValue());
        SunriseSunsetCalculator calculator = new SunriseSunsetCalculator(location, TimeZone.getTimeZone("UTC"));
        Calendar officialSunset = calculator.getOfficialSunsetCalendarForDate(date);
        if (officialSunset != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm z");
            dateFormat.setTimeZone(officialSunset.getTimeZone());
            return dateFormat.format(officialSunset.getTime());
        }
        return null;
    }

    public static Float calculateMedian(List<Float> values) {
        if (values != null && values.size() > 0) {
            Collections.sort(values);
            if (values.size() % 2 == 0) {
                int middle_index = (int)Math.ceil(values.size() / 2) - 1;
                return Float.valueOf((values.get(middle_index).floatValue() + values.get(middle_index + 1).floatValue()) / 2.0f);
            }
            return values.get((int)Math.floor((double)values.size() / 2.0));
        }
        return null;
    }

    public static Float calculateAverage(List<Float> values) {
        if (values != null && values.size() > 0) {
            float val = 0.0f;
            for (Float f : values) {
                val += f.floatValue();
            }
            return Float.valueOf(val / (float)values.size());
        }
        return null;
    }

    public static Float calculateMin(List<Float> values) {
        if (values != null && values.size() > 0) {
            float val = values.get(0).floatValue();
            for (Float f : values) {
                if (!(f.floatValue() <= val)) continue;
                val = f.floatValue();
            }
            return Float.valueOf(val);
        }
        return null;
    }

    public static Float calculateMax(List<Float> values) {
        if (values != null && values.size() > 0) {
            float val = values.get(0).floatValue();
            for (Float f : values) {
                if (!(f.floatValue() >= val)) continue;
                val = f.floatValue();
            }
            return Float.valueOf(val);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void executeTaskInFixedSinglePool(Callable<T> task) throws ExecutionException {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        Future<T> future = pool.submit(task);
        try {
            if (future != null) {
                future.get();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            pool.shutdown();
        }
    }

    public static <T> void executeTaskInFixedPool(List<Callable<T>> tasksList) throws ExecutionException {
        VfrUtil.executeTaskInFixedPool(tasksList, tasksList.size() >= Constants.NTHREDS ? Constants.NTHREDS : tasksList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void executeTaskInFixedPool(List<Callable<T>> tasksList, int tasksNum) throws ExecutionException {
        ExecutorService pool = Executors.newFixedThreadPool(tasksNum);
        ArrayList<Future<T>> futureTasks = new ArrayList<Future<T>>(tasksList.size());
        for (Callable<T> callable : tasksList) {
            futureTasks.add(pool.submit(callable));
        }
        try {
            for (Future future : futureTasks) {
                if (future == null) continue;
                future.get();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            pool.shutdown();
        }
    }

    public static Color getColor(short val, short min, short max, float opacity) {
        short absoluteMin = min;
        if (absoluteMin < 0) {
            absoluteMin = 0;
        }
        short absoluteMax = (short)Math.round((double)max * 0.7);
        int idx = VfrUtil.getColorIndex(val, min, max, absoluteMin, absoluteMax);
        return new Color((float)SettingsBean.getInstance().getColorsPalette()[idx].getRed() / 255.0f, (float)SettingsBean.getInstance().getColorsPalette()[idx].getGreen() / 255.0f, (float)SettingsBean.getInstance().getColorsPalette()[idx].getBlue() / 255.0f, opacity);
    }

    public static int getColorIndex(short val, short terrainElevMin, short terrainElevMax, Short userMin, Short userMax) {
        short min = terrainElevMin;
        short max = terrainElevMax;
        if (userMin != null && min < userMin) {
            min = userMin;
        }
        if (userMax != null && max > userMax) {
            max = userMax;
        }
        if (userMax != null && val > userMax) {
            val = userMax;
        }
        int diff = val - min;
        if (userMin != null && diff < 0) {
            diff = 0;
        }
        return Math.round((float)diff / (float)(max - min) * 511.0f);
    }

    public static Double parseTimeFromString(String str) {
        if (str == null || !str.matches("^([0-9]{2}[:]{1}[0-9]{2})$")) {
            return null;
        }
        Double val = null;
        try {
            val = Double.valueOf(str.substring(0, 2)) + Double.valueOf(str.substring(3, 5)) / 60.0;
        }
        catch (NumberFormatException e) {
            log.error(e, e);
        }
        return val;
    }

    public static String parseStringFromTime(Double hour) {
        if (hour == null) {
            return null;
        }
        int h = (int)Math.floor(hour);
        int m = (int)Math.round((hour - (double)h) * 60.0);
        return String.format("%02d", h %= 24) + ":" + String.format("%02d", m);
    }

    public static void changeLanguage(int lang) {
        Messages.getInstance().loadResources(lang);
        VfrUtil.refreshUI();
    }

    public static void refreshUI() {
        SettingsBean.getInstance().setPlaneProfiles(PlaneProfileUtil.loadProfiles("conf/profiles.xml"));
        PlaneProfileUtil.saveProfiles(SettingsBean.getInstance().getPlaneProfiles(), "conf/profiles.xml");
        int mapZoom = MapFrame.getInstance().getZoom();
        GeoPosition mapCenterPos = MapFrame.getInstance().getCenterPosition();
        TileFactory tileFactory = MapFrame.getInstance().getTileFactiory();
        ColorTheme theme = SettingsBean.getInstance().getColorTheme();
        MapFrame.getInstance().refreshInstance();
        MapObjectsBean.getInstance().setRadialsFromVors(null);
        MapObjectsBean.getInstance().setRadialsFromVorsIntersections(null);
        SettingsBean.getInstance().setDrawRadialsFromVors(false);
        SplashScreenDialog.getInstance().refreshInstance();
        MapFrame.getInstance().getUIPanel().updateData();
        MeteoViewDialog.getInstance().refreshInstance();
        MapFrame.getInstance().setVisible(true);
        SettingsBean.getInstance().setDefaultTrueTrackPrefix();
        MapFrame.getInstance().setZoom(mapZoom);
        MapFrame.getInstance().setCenterPosition(mapCenterPos);
        MapFrame.getInstance().setTileFactory(tileFactory);
        SettingsBean.getInstance().setColorTheme(theme);
        MapFrame.getInstance().getUIPanel().getAirspacesFilterCollapsablePanel().updateAirspacesTypes();
        MapFrame.getInstance().syncUIWithDataInDB();
        VfrUtil.setLayerVisibilityAction(new RefreshAllTask());
    }

    public static void optimizeTaxiNames(Airport airport) {
        if (airport.getTaxiNames().size() > 1) {
            double threshold = airport.getTaxiNames().size() > 50 ? 0.04 : 0.025;
            HashMap<String, ArrayList<TaxiName>> taxiNamesMap = new HashMap<String, ArrayList<TaxiName>>();
            TaxiName[] taxiNames = airport.getTaxiNames().toArray(new TaxiName[airport.getTaxiNames().size()]);
            for (int i = 0; i < taxiNames.length; ++i) {
                GpsPlace from = taxiNames[i].getGpsPlace();
                boolean tooClose = false;
                for (int j = i + 1; j < taxiNames.length; ++j) {
                    double dist = GpsUtil.getDistance(from, taxiNames[j].getGpsPlace());
                    if (!(dist < threshold)) continue;
                    tooClose = true;
                    break;
                }
                if (tooClose) continue;
                ArrayList<TaxiName> tnList = (ArrayList<TaxiName>)taxiNamesMap.get(taxiNames[i].getName());
                if (tnList == null) {
                    tnList = new ArrayList<TaxiName>();
                }
                tnList.add(taxiNames[i]);
                taxiNamesMap.put(taxiNames[i].getName(), tnList);
            }
            ArrayList<TaxiName> finalList = new ArrayList<TaxiName>();
            for (List tnList : taxiNamesMap.values()) {
                for (int i = 0; i < tnList.size(); ++i) {
                    GpsPlace from = ((TaxiName)tnList.get(i)).getGpsPlace();
                    boolean tooClose = false;
                    for (int j = i + 1; j < tnList.size(); ++j) {
                        double dist = GpsUtil.getDistance(from, ((TaxiName)tnList.get(j)).getGpsPlace());
                        if (!(dist < threshold * 3.0)) continue;
                        tooClose = true;
                        break;
                    }
                    if (tooClose) continue;
                    finalList.add((TaxiName)tnList.get(i));
                }
            }
            airport.setTaxiNames(finalList);
        }
    }

    public static String getAirportsKey(String ident) {
        if (ident == null) {
            return null;
        }
        if (ident.length() == 1) {
            return ident;
        }
        return ident.substring(0, 2);
    }

    public static Color[] generateColorsPalette(int n) {
        return VfrUtil.generateColorsPalette(n, 2.25f);
    }

    public static Color[] generateColorsPalette(int n, float modifier) {
        Color[] cols = new Color[n];
        for (int i = 0; i < n; ++i) {
            float v = (float)i / (float)n / modifier;
            cols[n - i - 1] = Color.getHSBColor(v, 1.0f, 0.5f);
        }
        return cols;
    }

    public static Color[] generateGrayPalette(int n) {
        Color[] cols = new Color[n];
        for (int i = 0; i < n; ++i) {
            cols[i] = new Color((float)i / (float)n, (float)i / (float)n, (float)i / (float)n);
        }
        return cols;
    }

    public static String createRandomUuid() {
        return VfrUtil.md5(String.valueOf(new Random().nextLong() + System.currentTimeMillis()));
    }

    public static String md5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static void showErrorsListDialog(Component component, List<String> errors) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (String error : errors) {
            sb.append(error);
            sb.append("<br/>");
        }
        sb.append("</html>");
        JOptionPane.showMessageDialog(component, sb.toString(), Messages.getInstance().get("error"), 0);
    }
}

