/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.core.dto.UserPointDTO;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.xml.userpoint.UserPoints;
import org.apache.log4j.Logger;

public class UserPointsUtil {
    private static final Logger log = Logger.getLogger(UserPointsUtil.class);

    public static List<UserPoint> loadUserPoints(String file) {
        if (IOUtil.hasExtension(file, "upx")) {
            return UserPointsUtil.loadUserPointsFromUpx(file);
        }
        if (IOUtil.hasExtension(file, "csv")) {
            return UserPointsUtil.loadUserPointsFromCsv(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UserPoint> loadUserPointsFromCsv(String filename) {
        log.debug("Loading user points from " + filename);
        ArrayList<UserPoint> resultList = new ArrayList<UserPoint>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] split = StringUtil.splitCsvLine(',', line.replace("\"\"", ""));
                if (split.length < 6) continue;
                try {
                    UserPoint p = new UserPoint();
                    p.setName(StringUtil.isEmpty(split[2]) ? split[1] : split[2]);
                    p.setLat(Double.valueOf(split[3]));
                    p.setLon(Double.valueOf(split[4]));
                    if (!UserPointsUtil.validateUserPoint(p)) continue;
                    resultList.add(p);
                }
                catch (NumberFormatException e) {
                    log.error("Couldn't parse line: " + line);
                }
            }
            log.debug("Finished importing " + resultList.size() + " user points");
        }
        catch (Exception e) {
            try {
                log.error("Couldn't load csv file " + filename, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(br);
                throw throwable;
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return resultList;
    }

    private static boolean validateUserPoint(UserPoint p) {
        if (StringUtil.isEmpty(p.getName())) {
            return false;
        }
        return p.getLat() != null && p.getLon() != null;
    }

    public static List<UserPoint> loadUserPointsFromUpx(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UserPoints.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            UserPoints xml = (UserPoints)jaxbUnmarshaller.unmarshal(new File(file));
            return UserPointsUtil.getUserPointsFromXml(xml);
        }
        catch (Exception e) {
            log.error(e);
            return null;
        }
    }

    private static List<UserPoint> getUserPointsFromXml(UserPoints xml) {
        ArrayList<UserPoint> userpoints = new ArrayList<UserPoint>();
        if (xml != null) {
            for (UserPoints.Point xmlPoint : xml.getPoint()) {
                UserPoint userPoint = new UserPoint();
                userPoint.setLat(xmlPoint.getLat());
                userPoint.setLon(xmlPoint.getLon());
                userPoint.setName(xmlPoint.getName());
                userPoint.setTags(xmlPoint.getTags());
                userpoints.add(userPoint);
            }
        }
        return userpoints;
    }

    public static boolean saveUserPoints(List<UserPoint> userpoints, String file) {
        log.info("saving to " + file);
        UserPoints xml = UserPointsUtil.getXml(userpoints);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UserPoints.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    private static UserPoints getXml(List<UserPoint> userpoints) {
        UserPoints xml = new UserPoints();
        for (UserPoint p : userpoints) {
            UserPoints.Point xmlPoint = new UserPoints.Point();
            xmlPoint.setLat(p.getLat());
            xmlPoint.setLatHem(p.getLatHem());
            xmlPoint.setLon(p.getLon());
            xmlPoint.setLonHem(p.getLonHem());
            xmlPoint.setName(p.getName());
            xmlPoint.setTags(p.getTags());
            xml.getPoint().add(xmlPoint);
        }
        return xml;
    }

    public static Set<String> getCurrentUserPointsTags() {
        HashSet<String> userPointsTags = new HashSet<String>();
        for (UserPointDTO p : MapObjectsBean.getInstance().getUserPoints(null)) {
            if (!StringUtil.isEmpty(p.getTags())) {
                for (String tag : p.getTags().split(";;")) {
                    if (StringUtil.isEmpty(tag)) continue;
                    userPointsTags.add(tag.trim());
                }
                continue;
            }
            userPointsTags.add("");
        }
        return userPointsTags;
    }

    public static String getParsedTags(String tags) {
        if (StringUtil.isEmpty(tags)) {
            return "";
        }
        String t = tags.replaceAll(";;", ", ");
        if (t.startsWith(", ")) {
            t = t.substring(2);
        }
        if (t.endsWith(", ")) {
            t = t.substring(0, t.length() - 2);
        }
        return t;
    }

    public static String parsedTags(String tags) {
        if (StringUtil.isEmpty(tags)) {
            return "";
        }
        String t = tags.replaceAll(",", ";;");
        if (!t.startsWith(";;")) {
            t = ";;" + t;
        }
        if (!t.endsWith(";;")) {
            t = t + ";;";
        }
        return t;
    }
}

