/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class UrlUtil {
    private static final Logger log = Logger.getLogger(UrlUtil.class);

    public static void openWebpage(String file) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.open(new File(file));
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    public static void openUrlInBrowser(String url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(url));
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    public static String readUrl(String url) {
        return UrlUtil.readUrl(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String url, boolean silentMode) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String inputLine;
            URL oracle = new URL(url);
            in = new BufferedReader(new InputStreamReader(oracle.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
        }
        catch (IOException e) {
            if (!silentMode) {
                log.error("Couldn't read url: " + url, e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static boolean saveImage(BufferedImage img, String url) {
        try {
            return ImageIO.write((RenderedImage)img, "png", new File(url));
        }
        catch (IOException e) {
            log.error("Couldn't save png image " + url, e);
            return false;
        }
    }

    public static byte[] cacheInputStream(URL url) throws IOException {
        int n;
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.0.3705; .NET CLR 1.1.4322; .NET CLR 1.2.30703)");
        InputStream ins = connection.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        while ((n = ins.read(buf)) != -1) {
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }

    public static BufferedImage readImageFromDisk(String path) {
        try {
            return ImageIO.read(new File(path));
        }
        catch (MalformedURLException e) {
            log.error("Couldn't read image " + path, e);
        }
        catch (IOException e) {
            log.error("Couldn't read image " + path, e);
        }
        return null;
    }

    public static BufferedImage readImageFromUrl(String url) {
        return UrlUtil.readImageFromUrl(url, false);
    }

    public static BufferedImage readImageFromUrl(String url, boolean silent) {
        block4: {
            try {
                return ImageIO.read(new ByteArrayInputStream(UrlUtil.cacheInputStream(new URL(url))));
            }
            catch (MalformedURLException e) {
                if (!silent) {
                    log.error(e, e);
                }
            }
            catch (IOException e) {
                if (silent) break block4;
                log.error(e, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesUrl(String dest) {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            int n;
            URL url = new URL(dest);
            is = url.openStream();
            byte[] byteChunk = new byte[4096];
            while ((n = is.read(byteChunk)) > 0) {
                bais.write(byteChunk, 0, n);
            }
        }
        catch (IOException e) {
            log.error("Failed while reading bytes from " + dest, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bais.toByteArray();
    }

    public static boolean isOffline() {
        return UrlUtil.readUrl("http://google.com", true) == null;
    }

    public static String getFilenameFromPath(String fullpath) {
        if (fullpath == null) {
            return null;
        }
        int pos = (fullpath = fullpath.replaceAll("\\\\", "/")).lastIndexOf("/");
        if (pos < 0) {
            return fullpath;
        }
        return fullpath.substring(pos + 1);
    }
}

