/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.bean.filter.AirportFilter;
import main.java.guru.vfrflight.bean.filter.AirspaceFilter;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.gps.GpsPlace;

public class UnitUtil {
    private static final Map<String, Double> verticalSpeedRatioTable;
    private static final Map<String, Double> speedRatioTable;
    private static final Map<String, Double> distanceRatioTable;
    private static final Map<String, Double> torqueRatioTable;
    private static final Map<String, Double> windSpeedRatioTable;
    private static final Map<String, Double> altitudeRatioTable;
    private static final Map<String, Double> fuelRatioTable;

    public static Double recalculateWindSpeedIfNeeded(Double value, String unit) {
        if (value == null || unit == null) {
            return null;
        }
        if (!unit.equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
            value = UnitUtil.recalculateWindSpeed(value, SettingsBean.getInstance().getParamUnitsWindSpeed(), unit, false);
        }
        return value;
    }

    public static Double recalculateSpeedIfNeeded(Double value, String unit) {
        if (value == null || unit == null) {
            return null;
        }
        if (!unit.equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            value = UnitUtil.recalculateSpeed(value, SettingsBean.getInstance().getParamUnitsSpeed(), unit, false);
        }
        return value;
    }

    public static Double recalculateAltitudeIfNeeded(Double value, String unit) {
        if (value == null || unit == null) {
            return null;
        }
        if (!unit.equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            value = UnitUtil.recalculateAltitude(value, SettingsBean.getInstance().getParamUnitsAltitude(), unit, false);
        }
        return value;
    }

    public static String getSpeedUnit() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append(SettingsBean.getInstance().getParamUnitsSpeed());
        sb.append("]");
        return sb.toString();
    }

    public static String getWindSpeedUnit() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append(SettingsBean.getInstance().getParamUnitsWindSpeed());
        sb.append("]");
        return sb.toString();
    }

    public static String getFuelUnit(String sufix) {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append(SettingsBean.getInstance().getParamUnitsFuel());
        if (sufix != null) {
            sb.append(sufix);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String getFuelUnit() {
        return UnitUtil.getFuelUnit(null);
    }

    public static String getAltitudeUnit() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append(SettingsBean.getInstance().getParamUnitsAltitude());
        sb.append("]");
        return sb.toString();
    }

    public static String getDistanceUnit() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append(SettingsBean.getInstance().getParamUnitsDistance());
        sb.append("]");
        return sb.toString();
    }

    public static Double calculateTorque(double quantity, String quantityUnit, double arm, String armUnit, String torqueUnit, boolean roundUp) {
        Double torque = null;
        if (quantityUnit != null && armUnit != null) {
            if (!quantityUnit.equals("kg")) {
                quantity = UnitUtil.recalculateFuel(quantity, quantityUnit, "kg", false);
            }
            if (!armUnit.equals("cm")) {
                arm = UnitUtil.recalculateDistance(arm, armUnit, "cm", false);
            }
            torque = quantity * arm / 100.0;
            if (!torqueUnit.equals("kg*mm/1000")) {
                torque = UnitUtil.recalculateTorque(torque, "kg*mm/1000", torqueUnit, false);
            }
            if (roundUp) {
                torque = (double)Math.round(torque * 10.0) / 10.0;
            }
        }
        return torque;
    }

    public static double recalculateTorque(double val, String from, String to, boolean roundUp) {
        if (!from.equals(to)) {
            val = torqueRatioTable.get(from) * val;
            if (!"lbs*in/1000".equals(to)) {
                val /= torqueRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static double recalculateDistance(double val, String from, String to, boolean roundUp) {
        if (!from.equals(to)) {
            val = distanceRatioTable.get(from) * val;
            if (!"km".equals(to)) {
                val /= distanceRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static double recalculateVerticalSpeed(double val, String from, String to, boolean roundUp) {
        if (!from.equals(to)) {
            val = verticalSpeedRatioTable.get(from) * val;
            if (!"fpm".equals(to)) {
                val /= verticalSpeedRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static double recalculateSpeed(double val, String from, String to, boolean roundUp) {
        if (!from.equals(to)) {
            val = speedRatioTable.get(from) * val;
            if (!"km/h".equals(to)) {
                val /= speedRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static double recalculateWindSpeed(double val, String from, String to, boolean roundUp) {
        if (!from.equals(to)) {
            val = windSpeedRatioTable.get(from) * val;
            if (!"kt".equals(to)) {
                val /= windSpeedRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static double recalculateAltitude(double val, String from, String to, boolean roundUp) {
        if (!from.equals(to)) {
            val = altitudeRatioTable.get(from) * val;
            if (!"m".equals(to)) {
                val /= altitudeRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static double recalculateFuel(double val, String from, String to, boolean roundUp) {
        if (from != null && to != null && !from.equals(to)) {
            val = fuelRatioTable.get(from) * val;
            if (!"l".equals(to)) {
                val /= fuelRatioTable.get(to).doubleValue();
            }
        }
        return roundUp ? (double)Math.round(val * 10.0) / 10.0 : val;
    }

    public static void recalculateUnits(Map<String, String> to) {
        String selUnitsWindSpeed;
        String selUnitsFuel;
        String selUnitsAlt;
        String selUnitsSpeed;
        String selUnitsDist = to.get("unitsDistance");
        if (!selUnitsDist.equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            SettingsBean.getInstance().setParamUnitsDistance(selUnitsDist);
        }
        if (!(selUnitsSpeed = to.get("unitsSpeed")).equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            UnitUtil.recalculateSpeeds(SettingsBean.getInstance().getParamUnitsSpeed(), selUnitsSpeed);
            SettingsBean.getInstance().setParamUnitsSpeed(selUnitsSpeed);
        }
        if (!(selUnitsAlt = to.get("unitsAltitude")).equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            UnitUtil.recalculateAltitudes(SettingsBean.getInstance().getParamUnitsAltitude(), selUnitsAlt);
            SettingsBean.getInstance().setParamUnitsAltitude(selUnitsAlt);
        }
        if (!(selUnitsFuel = to.get("unitsFuel")).equals(SettingsBean.getInstance().getParamUnitsFuel())) {
            UnitUtil.recalculateFuels(SettingsBean.getInstance().getParamUnitsFuel(), selUnitsFuel);
            SettingsBean.getInstance().setParamUnitsFuel(selUnitsFuel);
        }
        if (!(selUnitsWindSpeed = to.get("unitsWindSpeed")).equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
            UnitUtil.recalculateWindSpeeds(SettingsBean.getInstance().getParamUnitsWindSpeed(), selUnitsWindSpeed);
            SettingsBean.getInstance().setParamUnitsWindSpeed(selUnitsWindSpeed);
        }
    }

    public static void recalculateSpeeds(String from, String to) {
        if (FlightPlanBean.getInstance().getRoute().getCruiseSpeed() != null) {
            FlightPlanBean.getInstance().getRoute().setCruiseSpeed(UnitUtil.recalculateSpeed(FlightPlanBean.getInstance().getRoute().getCruiseSpeed(), from, to, true));
        }
    }

    public static void recalculateWindSpeeds(String from, String to) {
        if (FlightPlanBean.getInstance().getRoute().getWindSpeed() != null) {
            FlightPlanBean.getInstance().getRoute().setWindSpeed(UnitUtil.recalculateWindSpeed(FlightPlanBean.getInstance().getRoute().getWindSpeed(), from, to, true));
        }
    }

    public static void recalculateFuels(String from, String to) {
        if (FlightPlanBean.getInstance().getRoute().getFuelBurn() != null) {
            FlightPlanBean.getInstance().getRoute().setFuelBurn(UnitUtil.recalculateFuel(FlightPlanBean.getInstance().getRoute().getFuelBurn(), from, to, true));
        }
        if (FlightPlanBean.getInstance().getRoute().getQmax() != null) {
            FlightPlanBean.getInstance().getRoute().setQmax(UnitUtil.recalculateFuel(FlightPlanBean.getInstance().getRoute().getQmax(), from, to, true));
        }
        if (FlightPlanBean.getInstance().getRoute().getQm() != null) {
            FlightPlanBean.getInstance().getRoute().setQm(UnitUtil.recalculateFuel(FlightPlanBean.getInstance().getRoute().getQm(), from, to, true));
        }
    }

    public static void recalculateAltitudes(String from, String to) {
        AirspaceFilter airspaceFilter;
        GpsPlace place;
        int i;
        for (i = 0; i < FlightPlanBean.getInstance().getRoute().getPoints().size(); ++i) {
            place = FlightPlanBean.getInstance().getRoute().getPoints().get(i);
            if (place.getAlt() == null) continue;
            FlightPlanBean.getInstance().getRoute().getPoints().get(i).setAlt(UnitUtil.recalculateAltitude(place.getAlt(), from, to, true));
        }
        for (i = 0; i < FlightPlanBean.getInstance().getRoute().getVors().size(); ++i) {
            place = FlightPlanBean.getInstance().getRoute().getVors().get(i);
            if (place.getAlt() == null) continue;
            FlightPlanBean.getInstance().getRoute().getVors().get(i).setAlt(UnitUtil.recalculateAltitude(place.getAlt(), from, to, true));
        }
        if (FlightPlanBean.getInstance().getRoute().getCruiseAlt() != null) {
            FlightPlanBean.getInstance().getRoute().setCruiseAlt(UnitUtil.recalculateAltitude(FlightPlanBean.getInstance().getRoute().getCruiseAlt(), from, to, true));
        }
        for (i = 0; i < FlightPlanBean.getInstance().getRoute().getAlternateAirports().size(); ++i) {
            AlternateAirport a = FlightPlanBean.getInstance().getRoute().getAlternateAirports().get(i);
            if (a.getElev() == null) continue;
            FlightPlanBean.getInstance().getRoute().getAlternateAirports().get(i).setElev((int)UnitUtil.recalculateAltitude(a.getElev().intValue(), from, to, true));
        }
        AirportFilter airportFilter = MapObjectsBean.getInstance().getAirportFilter();
        if (airportFilter.getElevationFrom() != null) {
            airportFilter.setElevationFrom((int)Math.round(UnitUtil.recalculateAltitude(airportFilter.getElevationFrom().intValue(), from, to, false)));
        }
        if (airportFilter.getElevationTo() != null) {
            airportFilter.setElevationTo((int)Math.round(UnitUtil.recalculateAltitude(airportFilter.getElevationTo().intValue(), from, to, false)));
        }
        if ((airspaceFilter = MapObjectsBean.getInstance().getAirspaceFilter()).getDrawAirspaceRangeFrom() != null) {
            airspaceFilter.setDrawAirspaceRangeFrom((int)Math.round(UnitUtil.recalculateAltitude(airspaceFilter.getDrawAirspaceRangeFrom().intValue(), from, to, false)));
        }
        if (airspaceFilter.getDrawAirspaceRangeTo() != null) {
            airspaceFilter.setDrawAirspaceRangeTo((int)Math.round(UnitUtil.recalculateAltitude(airspaceFilter.getDrawAirspaceRangeTo().intValue(), from, to, false)));
        }
    }

    static {
        HashMap<String, Double> ratioTable = new HashMap<String, Double>();
        ratioTable.put("fpm", Constants.UNITS_CLIMB_FPM_RATIO);
        ratioTable.put("m/s", Constants.UNITS_CLIMB_MPS_RATIO);
        verticalSpeedRatioTable = Collections.unmodifiableMap(ratioTable);
        ratioTable = new HashMap();
        ratioTable.put("kt", Constants.UNITS_SPEED_KT_RATIO);
        ratioTable.put("km/h", Constants.UNITS_SPEED_KPH_RATIO);
        ratioTable.put("mph", Constants.UNITS_SPEED_MPH_RATIO);
        ratioTable.put("mps", Constants.UNITS_SPEED_MPS_RATIO);
        speedRatioTable = Collections.unmodifiableMap(ratioTable);
        ratioTable = new HashMap();
        ratioTable.put("nm", Constants.UNITS_DISTANCE_NM_RATIO);
        ratioTable.put("km", Constants.UNITS_DISTANCE_KM_RATIO);
        ratioTable.put("sm", Constants.UNITS_DISTANCE_SM_RATIO);
        ratioTable.put("yd", Constants.UNITS_DISTANCE_YD_RATIO);
        ratioTable.put("cm", Constants.UNITS_DISTANCE_CM_RATIO);
        ratioTable.put("ft", Constants.UNITS_DISTANCE_FT_RATIO);
        ratioTable.put("m", Constants.UNITS_DISTANCE_M_RATIO);
        ratioTable.put("in", Constants.UNITS_DISTANCE_INCH_RATIO);
        distanceRatioTable = Collections.unmodifiableMap(ratioTable);
        ratioTable = new HashMap();
        ratioTable.put("kg*mm/1000", Constants.UNITS_TORQUE_KG_MM_RATIO);
        ratioTable.put("lbs*in/1000", Constants.UNITS_TORQUE_LBS_INCH_RATIO);
        torqueRatioTable = Collections.unmodifiableMap(ratioTable);
        ratioTable = new HashMap();
        ratioTable.put("kt", Constants.UNITS_WIND_SPEED_KT_RATIO);
        ratioTable.put("m/s", Constants.UNITS_WIND_SPEED_MPS_RATIO);
        windSpeedRatioTable = Collections.unmodifiableMap(ratioTable);
        ratioTable = new HashMap();
        ratioTable.put("m", Constants.UNITS_ALTITUDE_M_RATIO);
        ratioTable.put("ft", Constants.UNITS_ALTITUDE_FT_RATIO);
        ratioTable.put("nm", Constants.UNITS_ALTITUDE_NM_RATIO);
        altitudeRatioTable = Collections.unmodifiableMap(ratioTable);
        ratioTable = new HashMap();
        ratioTable.put("l", Constants.UNITS_FUEL_L_RATIO);
        ratioTable.put("gal", Constants.UNITS_FUEL_US_GAL_RATIO);
        ratioTable.put("impgal", Constants.UNITS_FUEL_UK_GAL_RATIO);
        ratioTable.put("lbs", Constants.UNITS_FUEL_LBS_RATIO);
        ratioTable.put("kg", Constants.UNITS_FUEL_KG_RATIO);
        ratioTable.put("qt", Constants.UNITS_FUEL_US_QUART_RATIO);
        fuelRatioTable = Collections.unmodifiableMap(ratioTable);
    }
}

