/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class Timer {
    private static volatile Timer instance;
    static Logger log;
    private Map<String, Long> times = new HashMap<String, Long>();
    private Map<String, Long> totalTime = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Timer getInstance() {
        if (instance != null) return instance;
        Class<Timer> clazz = Timer.class;
        synchronized (Timer.class) {
            if (instance != null) return instance;
            instance = new Timer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Timer() {
    }

    public void start(String id) {
        if (this.times.containsKey(id)) {
            this.times.remove(id);
        }
        this.times.put(id, System.currentTimeMillis());
    }

    public Long stop(String id) {
        return this.stop(id, true);
    }

    public void pause(String id) {
        Long time = this.stop(id, true, false);
        if (time != null) {
            if (this.totalTime.containsKey(id)) {
                long totalT = this.totalTime.get(id);
                this.totalTime.remove(id);
                this.totalTime.put(id, time + totalT);
            } else {
                this.totalTime.put(id, time);
            }
        }
    }

    public void resume(String id) {
        this.start(id);
    }

    public Long stop(String id, boolean quiet) {
        return this.stop(id, quiet, true);
    }

    public Long stop(String id, boolean quiet, boolean removeTotalTime) {
        Long result = null;
        if (this.times.containsKey(id)) {
            result = System.currentTimeMillis() - this.times.get(id);
            if (!quiet) {
                log.debug("[" + id + "].. " + result + " ms passed");
            }
            this.times.remove(id);
        }
        if (removeTotalTime && this.totalTime.containsKey(id)) {
            this.totalTime.remove(id);
        }
        return result;
    }

    public Long getTime(String id) {
        if (this.times.containsKey(id)) {
            return System.currentTimeMillis() - this.times.get(id);
        }
        return null;
    }

    public Long getTotalTime(String id) {
        if (this.totalTime.containsKey(id)) {
            return this.totalTime.get(id);
        }
        return null;
    }

    public void startOrResume(String id) {
        if (this.totalTime.containsKey(id)) {
            this.resume(id);
        } else {
            this.start(id);
        }
    }

    static {
        log = Logger.getLogger(Timer.class);
    }
}

