/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.FormatUtil;

public class StringUtil {
    private static final String IPADDRESS_PATTERN_REGEX = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final Pattern IPADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public static String shortenString(String txt, int maxLength) {
        if (txt == null || txt.length() < maxLength) {
            return txt;
        }
        return txt.substring(0, maxLength);
    }

    public static boolean isEmpty(String text) {
        if (text == null) {
            return true;
        }
        return (text = text.trim()).length() == 0;
    }

    public static boolean isValidIpAddress(String ip) {
        return IPADDRESS_PATTERN.matcher(ip).matches();
    }

    public static String nullToEmpty(String text) {
        if (StringUtil.isEmpty(text)) {
            return "";
        }
        return text;
    }

    public static String emptyToNull(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return text;
    }

    public static String emptyToZero(String text) {
        if (StringUtil.isEmpty(text)) {
            return "0";
        }
        return text;
    }

    public static String[] splitCsvLine(char delimiter, String line) {
        ArrayList<String> parts = new ArrayList<String>();
        boolean lookForClosingQuote = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == '\"' && lookForClosingQuote) {
                lookForClosingQuote = false;
                parts.add(sb.toString());
                sb = new StringBuilder();
                ++i;
                continue;
            }
            if (line.charAt(i) == '\"' && !lookForClosingQuote) {
                lookForClosingQuote = true;
                continue;
            }
            if (line.charAt(i) == delimiter && !lookForClosingQuote) {
                parts.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(line.charAt(i));
        }
        parts.add(sb.toString());
        return parts.toArray(new String[parts.size()]);
    }

    public static String finishWithSlash(String path) {
        if (path != null && path.length() > 1 && !path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        return path;
    }

    public static void copyToClipboard(String txt) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(txt), null);
    }

    public static String pasteFromClipboard() {
        String data = null;
        try {
            data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (HeadlessException headlessException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    public static String escapeString(String val) {
        return val != null ? "'" + val.replace("'", "''") + "'" : "''";
    }

    public static String createSpaces(int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String formatWind(Double direction, Double speed) {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.getInstance().get("vertical_profile_panel_wind_data_text_info"));
        sb.append(" ");
        if (direction != null) {
            sb.append(FormatUtil.formattedCourse(direction, true));
        } else {
            sb.append("---");
        }
        sb.append(" / ");
        if (speed != null) {
            sb.append((double)Math.round(speed * 10.0) / 10.0);
            sb.append(SettingsBean.getInstance().getParamUnitsWindSpeed());
        } else {
            sb.append("--");
        }
        return sb.toString();
    }
}

