/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.painter.MapFramePainter;
import main.java.guru.vfrflight.gui.map.painter.MapFrameRoutePainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.downloader.StaticMapDownloader;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class StaticMapUtil {
    public static BufferedImage getStaticMap(VfrMapViewer map, GpsArea region, int zoom, int pixelMargin) {
        return StaticMapUtil.getStaticMap(map, region, zoom, pixelMargin, false, false);
    }

    public static BufferedImage getStaticMap(VfrMapViewer map, GpsArea region, int zoom, int pixelMargin, boolean mapOnly, boolean mapWithRouteOnly) {
        map.setStopDrawing(true);
        int prevZoom = map.getZoom();
        map.setZoom(zoom);
        Point2D centerPt = map.getTileFactory().geoToPixel(region.getCenter().geoPosition(), map.getZoom());
        Point2D prevCenter = map.getCenter();
        map.setCenter(centerPt);
        Point2D topLeftPt = map.getTileFactory().geoToPixel(region.getTopLeft().geoPosition(), map.getZoom());
        Point2D bottomRightPt = map.getTileFactory().geoToPixel(region.getBottomRight().geoPosition(), map.getZoom());
        int width = (int)Math.round(bottomRightPt.getX() - topLeftPt.getX()) + pixelMargin * 2;
        int height = (int)Math.round(bottomRightPt.getY() - topLeftPt.getY()) + pixelMargin * 2;
        map.setOverlayViewerBounds(StaticMapUtil.calculateViewportBounds(map, centerPt, width, height));
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        GraphicsUtil.setRenderingHints(g, 3);
        StaticMapDownloader mapDownloader = new StaticMapDownloader(map, g, map.getZoom(), map.getViewportBounds());
        mapDownloader.execute();
        while (mapDownloader.isRunning()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (mapWithRouteOnly) {
            MapFrameRoutePainter painter = new MapFrameRoutePainter(map, region, true);
            painter.paint(g, map, width, height);
        } else if (!mapOnly) {
            MapFramePainter painter = new MapFramePainter(map, region, true);
            painter.paint(g, map, width, height);
        }
        g.dispose();
        map.setCenter(prevCenter);
        map.setZoom(prevZoom);
        map.setOverlayViewerBounds(null);
        map.setStopDrawing(false);
        return img;
    }

    public static Rectangle calculateViewportBounds(JXMapViewer map, Point2D centr, int width, int height) {
        Insets insets = map.getInsets();
        int viewportWidth = width - insets.left - insets.right;
        int viewportHeight = height - insets.top - insets.bottom;
        double viewportX = centr.getX() - (double)(viewportWidth / 2);
        double viewportY = centr.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }
}

