/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import com.google.common.collect.ImmutableList;
import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.SimConnectPeriod;
import flightsim.simconnect.TextType;
import flightsim.simconnect.config.Configuration;
import flightsim.simconnect.config.ConfigurationManager;
import flightsim.simconnect.recv.AbstractDispatcher;
import flightsim.simconnect.recv.RecvPacket;
import flightsim.simconnect.recv.RecvSimObjectData;
import flightsim.simconnect.wrappers.DataWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.FpsEntry;
import main.java.guru.vfrflight.bean.FpsStats;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.bean.SimConnectTraffic;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.task.MergeFpsEntriesTask;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectGetFloatValueTask;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectGetUserDataTask;
import main.java.guru.vfrflight.gui.task.extconnect.simconnect.SimConnectSendEventTask;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GpxUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.KmlUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import org.apache.log4j.Logger;

public class SimConnectUtil {
    private static final Logger log = Logger.getLogger(SimConnectUtil.class);
    private ExtConnectBean extConnectBean;
    public static final String VARIABLE_DEFINITION_MAGVAR = "MAGVAR";
    public static final String VARIABLE_DEFINITION_PLANE_LATITUDE = "PLANE LATITUDE";
    public static final String VARIABLE_DEFINITION_PLANE_LONGITUDE = "PLANE LONGITUDE";
    public static final String VARIABLE_DEFINITION_PLANE_ALTITUDE = "PLANE ALTITUDE";
    public static final String VARIABLE_DEFINITION_GPS_GROUND_SPEED = "GPS GROUND SPEED";
    public static final String VARIABLE_DEFINITION_GROUND_VELOCITY = "GROUND VELOCITY";
    public static final String VARIABLE_DEFINITION_VERTICAL_SPEED = "VERTICAL SPEED";
    public static final String VARIABLE_DEFINITION_AIRSPEED_TRUE = "AIRSPEED TRUE";
    public static final String VARIABLE_DEFINITION_AIRSPEED_INDICATED = "AIRSPEED INDICATED";
    public static final String VARIABLE_DEFINITION_INDICATED_ALTITUDE = "INDICATED ALTITUDE";
    public static final String VARIABLE_DEFINITION_PLANE_HEADING_DEGREES_TRUE = "PLANE HEADING DEGREES TRUE";
    public static final String VARIABLE_DEFINITION_PLANE_HEADING_DEGREES_MAGNETIC = "PLANE HEADING DEGREES MAGNETIC";
    public static final String VARIABLE_DEFINITION_PLANE_ALT_ABOVE_GROUND = "PLANE ALT ABOVE GROUND";
    public static final String VARIABLE_DEFINITION_PLANE_PITCH = "PLANE PITCH DEGREES";
    public static final String VARIABLE_DEFINITION_PLANE_BANK = "PLANE BANK DEGREES";
    public static final String VARIABLE_DEFINITION_G_FORCE = "G FORCE";
    public static final String VARIABLE_DEFINITION_WIND_VELOCITY = "AMBIENT WIND VELOCITY";
    public static final String VARIABLE_DEFINITION_WIND_DIRECTION = "AMBIENT WIND DIRECTION";
    public static final String VARIABLE_DEFINITION_FLAPS_HANDLE_PERCENT = "FLAPS HANDLE PERCENT";
    public static final String VARIABLE_DEFINITION_YOKE_Y_INDICATOR = "YOKE Y INDICATOR";
    public static final String VARIABLE_DEFINITION_YOKE_X_INDICATOR = "YOKE X INDICATOR";
    public static final String VARIABLE_DEFINITION_RUDDER_PEDAL_INDICATOR = "RUDDER PEDAL INDICATOR";
    public static final String VARIABLE_DEFINITION_SIM_ON_GROUND = "SIM ON GROUND";
    public static final String VARIABLE_DEFINITION_TYPE_BOOL = "Bool";
    public static final String VARIABLE_DEFINITION_TYPE_DEGREES = "Degrees";
    public static final String VARIABLE_DEFINITION_TYPE_PERCENT = "Percent";
    public static final String VARIABLE_DEFINITION_TYPE_POSITION = "Position";
    public static final String VARIABLE_DEFINITION_TYPE_FEET = "Feet";
    public static final String VARIABLE_DEFINITION_TYPE_FEET_PER_SECOND = "Feet per second";
    public static final String VARIABLE_DEFINITION_TYPE_METERS_PER_SECOND = "Meters per second";
    public static final String VARIABLE_DEFINITION_TYPE_KNOTS = "Knots";
    public static final String VARIABLE_DEFINITION_TYPE_RADIANS = "Radians";
    public static final String VARIABLE_DEFINITION_TYPE_METERS = "Meters";
    public static final String VARIABLE_DEFINITION_TYPE_GFORCE = "GForce";
    public static final String EVENT_THROTTLE_CUT = "THROTTLE_CUT";
    public static final String EVENT_MIXTURE_LEAN = "MIXTURE_LEAN";
    public static final String EVENT_REFRESH_SCENERY = "REFRESH_SCENERY";
    public static final String VARIABLE_DEFINITION_STRUCT_LATLONALT = "STRUCT LATLONALT";
    public static final String VARIABLE_DEFINITION_ATC_TYPE = "ATC TYPE";
    public static final String VARIABLE_DEFINITION_ATC_MODEL = "ATC MODEL";
    public static final String VARIABLE_DEFINITION_ATC_ID = "ATC ID";
    public static final String VARIABLE_DEFINITION_ATC_AIRLINE = "ATC AIRLINE";
    public static final String VARIABLE_DEFINITION_ATC_FLIGHT_NUMBER = "ATC FLIGHT NUMBER";
    public static final String VARIABLE_DEFINITION_AI_TRAFFIC_FROM_AIRPORT = "AI TRAFFIC FROMAIRPORT";
    public static final String VARIABLE_DEFINITION_AI_TRAFFIC_TO_AIRPORT = "AI TRAFFIC TOAIRPORT";
    private float groundAltitudeOffset = 0.0f;
    private Float variableValue;
    private List<ExtConnectBean> userTrack = new LinkedList<ExtConnectBean>();
    private List<SimConnectTraffic> traffic;
    private List<FpsEntry> fpsEntries;
    private Integer selectedUserTrackPoint = null;
    private Integer selectionStart = null;
    private Integer selectionEnd = null;
    private static volatile SimConnectUtil instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimConnectUtil getInstance() {
        if (instance != null) return instance;
        Class<SimConnectUtil> clazz = SimConnectUtil.class;
        synchronized (SimConnectUtil.class) {
            if (instance != null) return instance;
            instance = new SimConnectUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SimConnectUtil() {
    }

    public static boolean setUserPosition(SimConnect sc, float lat, float lon, float alt) {
        if (sc == null) {
            sc = SimConnectUtil.initConnection();
        }
        if (sc != null) {
            try {
                sc.addToDataDefinition(1, VARIABLE_DEFINITION_PLANE_LATITUDE, VARIABLE_DEFINITION_TYPE_DEGREES, SimConnectDataType.FLOAT32);
                sc.addToDataDefinition(1, VARIABLE_DEFINITION_PLANE_LONGITUDE, VARIABLE_DEFINITION_TYPE_DEGREES, SimConnectDataType.FLOAT32);
                sc.addToDataDefinition(1, VARIABLE_DEFINITION_PLANE_ALTITUDE, VARIABLE_DEFINITION_TYPE_FEET, SimConnectDataType.FLOAT32);
                DataWrapper dataWrapper = new DataWrapper(12);
                dataWrapper.putFloat32(lat);
                dataWrapper.putFloat32(lon);
                dataWrapper.putFloat32(alt);
                sc.setDataOnSimObject(1, 0, false, 1, dataWrapper);
                sc.callDispatch((Dispatcher)new AbstractDispatcher(){

                    public void onDispatch(SimConnect simConnect, RecvPacket recv) {
                        if (SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack()) {
                            SimConnectUtil.getInstance().clearUserTrack();
                            SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
                        }
                        SimConnectUtil.reloadWorld(null);
                        MapFrame.getInstance().updateMap();
                    }
                });
                return true;
            }
            catch (IOException e) {
                log.error(e, e);
            }
        }
        return false;
    }

    public static void reloadWorld(SimConnect sc) {
        if (sc == null) {
            sc = SimConnectUtil.initConnection();
        }
        if (sc != null) {
            SimConnectUtil.sendEvent(sc, EVENT_REFRESH_SCENERY);
        }
    }

    public static boolean sendFlightPlan(SimConnect sc, String fileName) {
        if (sc != null) {
            try {
                sc.flightPlanLoad(fileName);
                return true;
            }
            catch (IOException e) {
                log.error(e, e);
            }
        }
        return false;
    }

    public static boolean displayText(SimConnect sc, String text, int time) {
        SimConnectUtil.initDisplayText(sc, text, time);
        try {
            sc.callDispatch((Dispatcher)new AbstractDispatcher(){

                public void onDispatch(SimConnect simConnect, RecvPacket recv) {
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean sendEvent(SimConnect sc, String eventId) {
        SimConnectSendEventTask sendEventTask = new SimConnectSendEventTask(sc, eventId);
        Thread t = new Thread(sendEventTask);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sendEventTask.isSuccess();
    }

    public boolean getVariableValue(SimConnect sc, String variableId, String unit) {
        this.setVariableValue(null);
        this.initGetVariableValue(sc, variableId, unit);
        try {
            sc.callDispatch((Dispatcher)new AbstractDispatcher(){

                public void onDispatch(SimConnect simConnect, RecvPacket recv) {
                    if (recv instanceof RecvSimObjectData) {
                        RecvSimObjectData data = (RecvSimObjectData)recv;
                        SimConnectUtil.this.setVariableValue(Float.valueOf(data.getDataFloat32()));
                    }
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static Float getMagVar(SimConnect sc) {
        if (sc == null) {
            sc = SimConnectUtil.initConnection();
        }
        SimConnectGetFloatValueTask task = new SimConnectGetFloatValueTask(sc, VARIABLE_DEFINITION_MAGVAR, VARIABLE_DEFINITION_TYPE_DEGREES);
        Thread t = new Thread(task);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return task.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FpsEntry> getFpsEntries() {
        if (this.fpsEntries == null) {
            this.fpsEntries = new LinkedList<FpsEntry>();
        }
        List<FpsEntry> list = this.fpsEntries;
        synchronized (list) {
            return this.fpsEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsEntries(List<FpsEntry> fpsEntries) {
        if (fpsEntries != null) {
            List<FpsEntry> list = fpsEntries;
            synchronized (list) {
                this.fpsEntries = fpsEntries;
            }
        } else {
            this.fpsEntries = fpsEntries;
        }
    }

    public static SimConnectBean getUserData(SimConnect sc) {
        SimConnectGetUserDataTask userDataTask = new SimConnectGetUserDataTask(sc);
        Thread t = new Thread(userDataTask);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return userDataTask.getBean();
    }

    private static boolean initDisplayText(SimConnect sc, String text, int time) {
        try {
            sc.text(TextType.SCROLL_RED, (float)time, 0, text);
            return true;
        }
        catch (IOException e) {
            log.error(e, e);
            return false;
        }
    }

    private boolean initGetVariableValue(SimConnect sc, String variableId, String unit) {
        try {
            sc.addToDataDefinition(1, variableId, unit, SimConnectDataType.FLOAT32);
            sc.requestDataOnSimObject(1, 1, 0, SimConnectPeriod.ONCE);
            return true;
        }
        catch (IOException e) {
            log.error(e, e);
            return false;
        }
    }

    public static SimConnect initConnection(FsxP3DConnectConfigBean configBean) {
        log.debug("SimConnect INIT with " + configBean);
        SimConnect sc = null;
        Configuration cfg = new Configuration();
        cfg.setAddress(configBean.getIp());
        cfg.setPort(configBean.getPort());
        cfg.setProtocol(4);
        log.info("Trying to connect with configuration: " + cfg);
        try {
            sc = new SimConnect("VfrFlight", cfg, 3);
        }
        catch (BindException e) {
            log.error("Couldn't connect", e);
            return null;
        }
        catch (IOException e) {
            log.error("Couldn't connect", e);
            return null;
        }
        log.info("SimConnection successful");
        return sc;
    }

    public static SimConnect initConnection() {
        log.debug("SimConnect INIT");
        SimConnect sc = null;
        Configuration cfg = null;
        try {
            cfg = ConfigurationManager.getConfiguration((int)0);
        }
        catch (Exception e) {
            log.debug("Couldn't read configuration", e);
            cfg = new Configuration();
        }
        int port = cfg.getInt("Port", -1);
        log.debug("Trying with port " + port);
        if (port == -1) {
            port = Configuration.findSimConnectPortIPv4();
            log.debug("Read port " + port);
            if (port <= 0) {
                port = Configuration.findSimConnectPortIPv6();
                cfg.setProtocol(6);
            } else {
                cfg.setProtocol(4);
            }
            cfg.setPort(port);
            log.debug("Found port " + port);
        }
        if (port == -1) {
            log.error("Couldn't bind port");
            return null;
        }
        String host = cfg.get("Address", null);
        if (host == null) {
            String address = null;
            address = cfg.getInt("Protocol", 4) == 6 ? "::1" : "localhost";
            log.error("Autoresolved address to " + address);
            cfg.setAddress(address);
        }
        log.info("Trying to connect with configuration: " + cfg);
        try {
            sc = new SimConnect("VfrFlight", cfg, 3);
        }
        catch (BindException e) {
            log.error("Couldn't connect", e);
            return null;
        }
        catch (IOException e) {
            log.error("Couldn't connect", e);
            return null;
        }
        log.info("SimConnection successful");
        return sc;
    }

    public static void closeQuietly(SimConnect sc) {
        if (sc != null) {
            try {
                sc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportUserTrackToCsv(List<ExtConnectBean> beanList, String fileName) {
        boolean bl;
        PrintWriter out = null;
        try {
            out = new PrintWriter(fileName);
            out.write(SimConnectUtil.exportHeader() + Constants.EOL);
            for (ExtConnectBean bean : beanList) {
                out.write(SimConnectUtil.exportRow(bean) + Constants.EOL);
            }
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            return false;
        }
        IOUtil.closeQuietly(out);
        return bl;
    }

    public static String exportHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp");
        sb.append(";");
        sb.append("userLat");
        sb.append(";");
        sb.append("userLon");
        sb.append(";");
        sb.append("userAlt");
        sb.append(";");
        sb.append("userIndicatedAlt");
        sb.append(";");
        sb.append("userAltAboveTerrain");
        sb.append(";");
        sb.append("onGround");
        sb.append(";");
        sb.append("userIndicatedSpeed");
        sb.append(";");
        sb.append("userGs");
        sb.append(";");
        sb.append("userMagHeading");
        sb.append(";");
        sb.append("userTrueHeading");
        sb.append(";");
        sb.append("userVerticalSpeed");
        sb.append(";");
        sb.append("userBank");
        sb.append(";");
        sb.append("userPitch");
        sb.append(";");
        sb.append("gForce");
        sb.append(";");
        sb.append("windVelocity");
        sb.append(";");
        sb.append("windDirection");
        sb.append(";");
        sb.append("yokeXPosition");
        sb.append(";");
        sb.append("yokeYPosition");
        sb.append(";");
        sb.append("rudderPeddalsPosition");
        sb.append(";");
        sb.append("flapsHandle");
        sb.append(";");
        sb.append("userTas");
        sb.append(";");
        sb.append("fps");
        return sb.toString();
    }

    public static String exportRow(ExtConnectBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getTimestamp() != null ? bean.getTimestamp() : "");
        sb.append(";");
        sb.append(bean.getUserLat() != null ? bean.getUserLat() : "");
        sb.append(";");
        sb.append(bean.getUserLon() != null ? bean.getUserLon() : "");
        sb.append(";");
        sb.append(bean.getUserAlt() != null ? bean.getUserAlt() : "");
        sb.append(";");
        sb.append(bean.getUserIndicatedAlt() != null ? bean.getUserIndicatedAlt() : "");
        sb.append(";");
        sb.append(bean.getUserAltAboveTerrain() != null ? bean.getUserAltAboveTerrain() : "");
        sb.append(";");
        sb.append(bean.isOnGround() ? "1" : "0");
        sb.append(";");
        sb.append(bean.getUserIndicatedSpeed() != null ? bean.getUserIndicatedSpeed() : "");
        sb.append(";");
        sb.append(bean.getUserGs() != null ? bean.getUserGs() : "");
        sb.append(";");
        sb.append(bean.getUserMagHeading() != null ? bean.getUserMagHeading() : "");
        sb.append(";");
        sb.append(bean.getUserTrueHeading() != null ? bean.getUserTrueHeading() : "");
        sb.append(";");
        sb.append(bean.getUserVerticalSpeed() != null ? bean.getUserVerticalSpeed() : "");
        sb.append(";");
        sb.append(bean.getUserBank() != null ? bean.getUserBank() : "");
        sb.append(";");
        sb.append(bean.getUserPitch() != null ? bean.getUserPitch() : "");
        sb.append(";");
        sb.append(bean.getgForce() != null ? bean.getgForce() : "");
        sb.append(";");
        sb.append(bean.getWindVelocity() != null ? bean.getWindVelocity() : "");
        sb.append(";");
        sb.append(bean.getWindDirection() != null ? bean.getWindDirection() : "");
        sb.append(";");
        sb.append(bean.getYokeXPosition() != null ? bean.getYokeXPosition() : "");
        sb.append(";");
        sb.append(bean.getYokeYPosition() != null ? bean.getYokeYPosition() : "");
        sb.append(";");
        sb.append(bean.getRudderPeddalsPosition() != null ? bean.getRudderPeddalsPosition() : "");
        sb.append(";");
        sb.append(bean.getFlapsHandle() != null ? bean.getFlapsHandle() : "");
        sb.append(";");
        sb.append(bean.getUserTas() != null ? bean.getUserTas() : "");
        sb.append(";");
        sb.append(bean.getFps() != null ? bean.getFps() : "");
        return sb.toString();
    }

    public synchronized void centerOnUserTrack() {
        if (this.getUserTrack() != null) {
            ArrayList<GpsPlace> places = new ArrayList<GpsPlace>(this.getUserTrack().size());
            for (ExtConnectBean bean : this.getUserTrack()) {
                GpsPlace place = bean.getGpsPlace();
                if (place == null) continue;
                places.add(place);
            }
            MapFrame.getInstance().centerOnPoint(GpsUtil.getCenter(places));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public synchronized boolean importUserTrackFromCsv(String fileName) {
        boolean bl;
        this.clearUserTrack();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fileName));
            br.readLine();
            String line = null;
            while ((line = br.readLine()) != null) {
                this.userTrack.add(new SimConnectBean(line));
            }
            this.findGroundAltitudeOffset();
            this.centerOnUserTrack();
            bl = true;
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't load file " + fileName, e);
            IOUtil.closeQuietly(br);
        }
        catch (IOException e2) {
            log.error("Couldn't load file " + fileName, e2);
            {
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return bl;
        return false;
    }

    public synchronized void addUserTrack(ExtConnectBean bean) {
        this.userTrack.add(bean);
    }

    public synchronized List<ExtConnectBean> getUserTrack() {
        return ImmutableList.copyOf(this.userTrack);
    }

    public synchronized void clearUserTrack() {
        this.userTrack.clear();
    }

    public Integer getSelectedUserTrackPoint() {
        return this.selectedUserTrackPoint;
    }

    public void setSelectedUserTrackPoint(Integer selectedUserTrackPoint) {
        this.selectedUserTrackPoint = selectedUserTrackPoint;
    }

    public Float getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(Float variableValue) {
        this.variableValue = variableValue;
    }

    public synchronized float findGroundAltitudeOffset() {
        if (this.getUserTrack() != null) {
            for (ExtConnectBean bean : this.getUserTrack()) {
                if (!bean.isOnGround() || bean.getUserAltAboveTerrain() == null) continue;
                return -bean.getUserAltAboveTerrain().floatValue();
            }
        }
        return 0.0f;
    }

    public Integer getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionStart(Integer selectionStart) {
        this.selectionStart = selectionStart;
    }

    public Integer getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(Integer selectionEnd) {
        this.selectionEnd = selectionEnd;
    }

    public static void exportUserTrackToGoogleEarthAction(List<ExtConnectBean> beanList) {
        int returnVal;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("google_earth_export"), Messages.getInstance().get("save"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("kml_files"), new String[]{"KML"}));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".kml"));
        }
        if ((returnVal = chooser.showOpenDialog(MapFrame.getInstance())) == 0) {
            SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "kml");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("google_earth_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                if (KmlUtil.saveKml(beanList, fileName)) {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("google_earth_export_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("google_earth_export_error"), "", 0);
                }
            }
        }
    }

    public static void exportUserTrackToCsvAction(List<ExtConnectBean> beanList) {
        int returnVal;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("csv_export"), Messages.getInstance().get("save"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("csv_files"), new String[]{"CSV"}));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".csv"));
        }
        if ((returnVal = chooser.showOpenDialog(MapFrame.getInstance())) == 0) {
            SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "csv");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("csv_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                if (SimConnectUtil.exportUserTrackToCsv(beanList, fileName)) {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("csv_export_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("csv_export_error"), "", 0);
                }
            }
        }
    }

    public static void exportUserTrackToGpxAction(List<ExtConnectBean> beanList) {
        int returnVal;
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("gpx_export"), Messages.getInstance().get("save"));
        chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("gpx_files"), new String[]{"GPX"}));
        if (!StringUtil.isEmpty(FlightPlanBean.getInstance().getRoute().getName())) {
            chooser.setSelectedFile(new File(FlightPlanBean.getInstance().getRoute().getName() + ".gpx"));
        }
        if ((returnVal = chooser.showOpenDialog(MapFrame.getInstance())) == 0) {
            SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
            String fileName = IOUtil.addExtension(chooser.getSelectedFile(), "gpx");
            if (!new File(fileName).exists() || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("gpx_export"), Messages.getInstance().get("file_saving_dialog_overwrite_question"))) {
                if (GpxUtil.saveGpxFile(beanList, fileName)) {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("gpx_export_success"), "", 1);
                } else {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("gpx_export_error"), "", 0);
                }
            }
        }
    }

    public float getGroundAltitudeOffset() {
        return this.groundAltitudeOffset;
    }

    public void setGroundAltitudeOffset(float groundAltitudeOffset) {
        this.groundAltitudeOffset = groundAltitudeOffset;
    }

    public static void importUserTrackToCsvAction() {
        if (SimConnectUtil.getInstance().getUserTrack().size() == 0 || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("user_track_will_be_lost"))) {
            JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get("import"), Messages.getInstance().get("csv_import"));
            chooser.setFileFilter(new ExtensionFileFilter(Messages.getInstance().get("csv_files"), new String[]{"CSV"}));
            int returnVal = chooser.showOpenDialog(MapFrame.getInstance());
            if (returnVal == 0) {
                SettingsBean.getInstance().setFileOpenPath(chooser.getSelectedFile().getPath());
                SimConnectUtil.getInstance().importUserTrackFromCsv(chooser.getSelectedFile().getPath());
                if (!SettingsBean.getInstance().isDrawUserTrack()) {
                    MapFrame.getInstance().toggleShowUserTrackAction();
                }
                MapFrame.getInstance().updateMap();
            }
        }
    }

    public static List<FpsEntry> generateTestFpsEntries(long timeFrom, long timeTo, int fps) {
        ArrayList<FpsEntry> result = new ArrayList<FpsEntry>();
        int frameInterval = (int)Math.round(1000.0 / (double)fps);
        Random randomGenerator = new Random();
        int i = 0;
        while ((long)i < timeTo - timeFrom) {
            result.add(new FpsEntry(timeFrom + (long)i, Float.valueOf(randomGenerator.nextInt(20) + 10)));
            i += frameInterval;
        }
        return result;
    }

    public void mergeUserTrackWithFpsEntries() {
        Thread t = new Thread(new MergeFpsEntriesTask(this.getFpsEntries()));
        t.start();
    }

    public static FpsStats calculateStatistics(List<ExtConnectBean> userTrack) {
        FpsStats entry = null;
        if (userTrack != null && userTrack.size() > 0) {
            ArrayList<Float> notNullFps = new ArrayList<Float>();
            for (ExtConnectBean extConnectBean : userTrack) {
                SimConnectBean bean;
                if (!(extConnectBean instanceof SimConnectBean) || (bean = (SimConnectBean)extConnectBean).getFps() == null) continue;
                notNullFps.add(bean.getFps());
            }
            if (notNullFps.size() > 0) {
                entry = new FpsStats();
                Collections.sort(notNullFps);
                if (notNullFps.size() % 2 == 0) {
                    int middle_index = (int)Math.ceil(notNullFps.size() / 2) - 1;
                    entry.setMedian(Float.valueOf((((Float)notNullFps.get(middle_index)).floatValue() + ((Float)notNullFps.get(middle_index + 1)).floatValue()) / 2.0f));
                } else {
                    entry.setMedian((Float)notNullFps.get((int)Math.floor((double)notNullFps.size() / 2.0)));
                }
                float avg = 0.0f;
                for (Float e : notNullFps) {
                    avg += e.floatValue();
                }
                entry.setAverage(Float.valueOf(avg /= (float)notNullFps.size()));
                entry.setMin((Float)notNullFps.get(0));
                entry.setMax((Float)notNullFps.get(notNullFps.size() - 1));
                float f = 0.0f;
                for (Float e : notNullFps) {
                    f += (avg - e.floatValue()) * (avg - e.floatValue());
                }
                entry.setStdDev(Float.valueOf((float)Math.sqrt(f /= (float)notNullFps.size())));
            }
        }
        return entry;
    }

    public synchronized List<SimConnectTraffic> getTraffic() {
        if (this.traffic == null) {
            this.traffic = new ArrayList<SimConnectTraffic>();
        }
        return this.traffic;
    }

    public synchronized void setTraffic(List<SimConnectTraffic> traffic) {
        this.traffic = traffic;
    }

    public ExtConnectBean getExtConnectBean() {
        return this.extConnectBean;
    }

    public void setExtConnectBean(ExtConnectBean extConnectBean) {
        this.extConnectBean = extConnectBean;
    }

    public static String getBeanInfo(ExtConnectBean bean) {
        return null;
    }
}

