/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.search.Directory;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.search.SearchParams;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.sql.facade.IfrRouteFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import org.apache.log4j.Logger;

public class SearchUtil {
    static Logger log = Logger.getLogger(SearchUtil.class);

    public static Set<DiskObject> getRootList(String pattern, String path) {
        return SearchUtil.getRootList(new SearchParams(pattern), path);
    }

    public static long countFiles(String path) {
        return SearchUtil.countFiles(new SearchParams(), path);
    }

    public static long countFiles(SearchParams searchParams, String path) {
        path = SearchUtil.normalizePath(path);
        return SearchUtil.count(searchParams, "", path, 0);
    }

    public static Set<DiskObject> getRootList(String path) {
        return SearchUtil.getRootList(new SearchParams(), path);
    }

    public static Set<DiskObject> getRootList(SearchParams searchParams, String path) {
        path = SearchUtil.normalizePath(path);
        return SearchUtil.getList(searchParams, "", path, 0);
    }

    public static String normalizePath(String path) {
        if ((path = path.replace("\\", "/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static long count(SearchParams searchParams, String path, String absolutePath, int depth) {
        Set<DiskObject> files = SearchUtil.getList(searchParams, path, absolutePath, depth);
        return files == null ? 0L : (long)files.size();
    }

    private static Set<DiskObject> getList(SearchParams searchParams, String path, String absolutePath, int depth) {
        HashSet<DiskObject> objs = new HashSet<DiskObject>();
        ++depth;
        File dir = new File(absolutePath + path);
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean isDir = files[i].isDirectory();
                if (isDir) {
                    if (!searchParams.isSkipDirs()) {
                        HashSet<DiskObject> subDirList = new HashSet<DiskObject>();
                        Directory subDir = new Directory();
                        subDir.setDepth(depth - 1);
                        subDir.setPath(path + "/" + files[i].getName());
                        subDir.setSize(files[i].length());
                        if (searchParams.isNoPatterns().booleanValue() || SearchUtil.patternFilterValid(searchParams.getPatternsArray(), files[i].getName())) {
                            subDirList.add(subDir);
                        }
                        if (searchParams.getMaxDepth() == 0 || depth < searchParams.getMaxDepth()) {
                            subDirList.addAll(SearchUtil.getList(searchParams, subDir.getPath(), absolutePath, depth));
                        }
                        objs.addAll(subDirList);
                        continue;
                    }
                    if (searchParams.getMaxDepth() != 0 && depth >= searchParams.getMaxDepth()) continue;
                    objs.addAll(SearchUtil.getList(searchParams, path + "/" + files[i].getName(), absolutePath, depth));
                    continue;
                }
                if (isDir || searchParams.isSkipFiles() || !searchParams.isNoPatterns().booleanValue() && !SearchUtil.patternFilterValid(searchParams.getPatternsArray(), files[i].getName())) continue;
                main.java.guru.vfrflight.core.search.File file = new main.java.guru.vfrflight.core.search.File();
                file.setPath(path + "/" + files[i].getName());
                file.setDepth(depth - 1);
                file.setSize(files[i].length());
                objs.add(file);
            }
        }
        return objs;
    }

    private static boolean patternFilterValid(String[] patterns, String name) {
        name = name.toLowerCase();
        for (int i = 0; i < patterns.length; ++i) {
            if (!name.matches(patterns[i])) continue;
            return true;
        }
        return false;
    }

    public static List<GpsPlace> searchInAirports(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        results.addAll(airportFacade.findAirports(query, false));
        results.addAll(airportFacade.findVfrPoints(query));
        return results;
    }

    public static List<GpsPlace> searchInVfrPoints(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        results.addAll(airportFacade.findVfrPoints(query));
        return results;
    }

    public static List<GpsPlace> searchInIfrPoints(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        IfrRouteFacade ifrRouteFacade = new IfrRouteFacade(DBUtil.getDataSource());
        results.addAll(ifrRouteFacade.findIfrPoints(query, false));
        return results;
    }

    public static List<GpsPlace> searchInCities(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        CityFacade cityFacade = new CityFacade(DBUtil.getDataSource());
        results.addAll(cityFacade.getCities(query, false));
        return results;
    }

    public static List<GpsPlace> searchInNavaids(String query, String type) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        results.addAll(navaidFacade.getNavaids(query, type, true));
        return results;
    }

    public static List<GpsPlace> searchInUserPoints(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
        results.addAll(userPointFacade.getUserPoints(query, false));
        return results;
    }

    public static List<GpsPlace> search(String query) {
        ArrayList<GpsPlace> results = new ArrayList<GpsPlace>();
        results.addAll(SearchUtil.searchInAirports(query));
        results.addAll(SearchUtil.searchInIfrPoints(query));
        results.addAll(SearchUtil.searchInCities(query));
        results.addAll(SearchUtil.searchInNavaids(query, null));
        results.addAll(SearchUtil.searchInUserPoints(query));
        return results;
    }
}

