/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.MapUtil;

public class RouteUtil {
    /*
     * WARNING - void declaration
     */
    public static void findRouteAction(List<GpsPlace> newRoute, boolean vorToVor, Double cruiseSpeed, Double cruiseAlt, boolean autoCruiseAlt) {
        VfrMapViewer map = MapFrame.getInstance().getMapViewer();
        if (vorToVor && newRoute.size() == 2) {
            NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
            LineSegment segment = GpsUtil.getLineSegment(newRoute.get(0), newRoute.get(1));
            ArrayList<GpsVertex> boundaryList = new ArrayList<GpsVertex>(4);
            double correction = Math.min(100.0, segment.getDistance());
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), GpsUtil.normalizeCourse(segment.getCourse() + 90.0), correction));
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(segment.getFrom(), GpsUtil.normalizeCourse(segment.getCourse() + 270.0), correction));
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(segment.getTo(), segment.getCourse() - 90.0, correction));
            boundaryList.add(GpsUtil.getPointPositionByDistanceAndBearing(segment.getTo(), GpsUtil.normalizeCourse(segment.getCourse() + 90.0), correction));
            List<GpsPlace> vors = navaidFacade.getVorsInArea(GpsUtil.getRectangleOverVertices(boundaryList), false, false);
            if (vors != null && vors.size() > 0) {
                ArrayList<GpsPlace> finalVorsList = new ArrayList<GpsPlace>();
                for (GpsPlace gpsPlace : vors) {
                    double d = MapUtil.getDistanceInNmFromSegment(map, gpsPlace, segment);
                    if (!(d <= 50.0)) continue;
                    finalVorsList.add(gpsPlace);
                }
                TreeMap<Double, GpsPlace> orderedVorsMap = new TreeMap<Double, GpsPlace>();
                for (GpsPlace gpsPlace : finalVorsList) {
                    GpsPlace placeOnSegment = GpsUtil.getGpsPlaceOnSegment(map, segment, gpsPlace);
                    double distFromStart = GpsUtil.getDistance(segment.getFrom(), placeOnSegment);
                    orderedVorsMap.put(distFromStart, gpsPlace.clone());
                }
                int n = 50;
                int n2 = 50;
                ArrayList<GpsPlace> finalRoute = new ArrayList<GpsPlace>(orderedVorsMap.size() + 2);
                finalRoute.add(newRoute.get(0).clone());
                Iterator iter = orderedVorsMap.entrySet().iterator();
                ArrayList tempList = new ArrayList();
                while (iter.hasNext()) {
                    void var15_22;
                    Map.Entry pair = iter.next();
                    if ((Double)pair.getKey() > (double)var15_22) {
                        if (tempList.size() > 0) {
                            if (tempList.size() == 1) {
                                finalRoute.add(((GpsPlace)tempList.get(tempList.size() - 1)).clone());
                            } else {
                                double minDist = 0.0;
                                int index = -1;
                                for (int i = 0; i < tempList.size(); ++i) {
                                    double vorDist = GpsUtil.getDistance((GpsPlace)tempList.get(i), segment.getTo());
                                    if (i != 0 && !(vorDist < minDist)) continue;
                                    minDist = vorDist;
                                    index = i;
                                }
                                finalRoute.add(((GpsPlace)tempList.get(index)).clone());
                            }
                            tempList.clear();
                        }
                        var15_22 += 50;
                    }
                    tempList.add(pair.getValue());
                }
                finalRoute.add(newRoute.get(1).clone());
                if (finalRoute.size() >= 3 && GpsUtil.getTotalPointsDistance(finalRoute) >= 150.0) {
                    boolean removal = false;
                    block4: do {
                        removal = false;
                        for (int i = 2; i < finalRoute.size() - 1; ++i) {
                            double distAfterRemoval = GpsUtil.getDistance((GpsPlace)finalRoute.get(i - 1), (GpsPlace)finalRoute.get(i));
                            if (!(distAfterRemoval <= 100.0)) continue;
                            finalRoute.remove(i);
                            removal = true;
                            continue block4;
                        }
                    } while (removal);
                }
                newRoute.clear();
                newRoute.addAll(finalRoute);
            }
        }
        if (cruiseSpeed != null) {
            FlightPlanBean.getInstance().getRoute().setCruiseSpeed(cruiseSpeed);
        }
        if (autoCruiseAlt) {
            ElevationFacade elevationFacade = new ElevationFacade(DBUtil.getDataSource());
            ArrayList<RouteSegment> segments = new ArrayList<RouteSegment>(newRoute.size() - 1);
            for (int i = 1; i < newRoute.size(); ++i) {
                segments.add(new RouteSegment(new LineSegment(newRoute.get(i - 1), newRoute.get(i))));
            }
            Integer msa = elevationFacade.calculateMsa(map, segments);
            if (msa != null) {
                cruiseAlt = (double)msa;
            }
        }
        FlightPlanBean.getInstance().getRoute().setCruiseAlt(cruiseAlt);
        if (cruiseAlt != null && newRoute.size() >= 3) {
            for (int i = 1; i < newRoute.size() - 1; ++i) {
                newRoute.get(i).setAlt(cruiseAlt);
            }
        }
        MapFrame.getInstance().getUIPanel().updateInfoData();
        MapFrame.getInstance().getUIPanel().routePointsClearAllAction();
        for (GpsPlace place : newRoute) {
            MapFrame.getInstance().getUIPanel().addNewPoint(place, null);
        }
        MapFrame.getInstance().centerMap();
    }
}

