/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.PlaneProfile;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.xml.profile.Profiles;
import org.apache.log4j.Logger;

public class PlaneProfileUtil {
    private static final Logger log = Logger.getLogger(PlaneProfileUtil.class);

    public static List<PlaneProfile> loadProfiles(String file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Profiles.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Profiles xml = (Profiles)jaxbUnmarshaller.unmarshal(new File(file));
            return PlaneProfileUtil.getProfilesFromXml(xml);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static List<PlaneProfile> getProfilesFromXml(Profiles xml) {
        ArrayList<PlaneProfile> profiles = new ArrayList<PlaneProfile>();
        if (xml != null) {
            for (Profiles.Profile xmlProfile : xml.getProfile()) {
                PlaneProfile profile = new PlaneProfile(xmlProfile.getName());
                if (xmlProfile.getCruiseAlt() != null && xmlProfile.getCruiseAlt().getValue() != null) {
                    double cruiseAlt = xmlProfile.getCruiseAlt().getValue();
                    if (!xmlProfile.getCruiseAlt().getUnit().equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                        cruiseAlt = UnitUtil.recalculateAltitude(cruiseAlt, xmlProfile.getCruiseAlt().getUnit(), SettingsBean.getInstance().getParamUnitsAltitude(), true);
                    }
                    profile.setCruiseAlt(cruiseAlt);
                }
                if (xmlProfile.getCruiseSpeed() != null && xmlProfile.getCruiseSpeed().getValue() != null) {
                    double cruiseSpeed = xmlProfile.getCruiseSpeed().getValue();
                    if (!xmlProfile.getCruiseSpeed().getUnit().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                        cruiseSpeed = UnitUtil.recalculateSpeed(cruiseSpeed, xmlProfile.getCruiseSpeed().getUnit(), SettingsBean.getInstance().getParamUnitsSpeed(), true);
                    }
                    profile.setCruiseSpeed(cruiseSpeed);
                }
                if (xmlProfile.getClimbingSpeed() != null && xmlProfile.getClimbingSpeed().getValue() != null) {
                    double climbingSpeed = xmlProfile.getClimbingSpeed().getValue();
                    if (!xmlProfile.getClimbingSpeed().getUnit().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                        climbingSpeed = UnitUtil.recalculateSpeed(climbingSpeed, xmlProfile.getClimbingSpeed().getUnit(), SettingsBean.getInstance().getParamUnitsSpeed(), true);
                    }
                    profile.setClimbingSpeed(climbingSpeed);
                }
                if (xmlProfile.getDescendingSpeed() != null && xmlProfile.getDescendingSpeed().getValue() != null) {
                    double descendingSpeed = xmlProfile.getDescendingSpeed().getValue();
                    if (!xmlProfile.getDescendingSpeed().getUnit().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                        descendingSpeed = UnitUtil.recalculateSpeed(descendingSpeed, xmlProfile.getDescendingSpeed().getUnit(), SettingsBean.getInstance().getParamUnitsSpeed(), true);
                    }
                    profile.setDescendingSpeed(descendingSpeed);
                }
                if (xmlProfile.getFuel() != null && xmlProfile.getFuel().getValues() != null) {
                    profile.setNavFuelReserveMin(xmlProfile.getFuel().getNavFuelReserveMin());
                    Double fuelBurn = xmlProfile.getFuel().getValues().getFuelBurn();
                    Double fuelQm = xmlProfile.getFuel().getValues().getFuelQm();
                    Double fuelQmax = xmlProfile.getFuel().getValues().getFuelQmax();
                    if (!xmlProfile.getFuel().getUnit().equals(SettingsBean.getInstance().getParamUnitsFuel())) {
                        if (fuelBurn != null) {
                            fuelBurn = UnitUtil.recalculateFuel(fuelBurn, xmlProfile.getFuel().getUnit(), SettingsBean.getInstance().getParamUnitsFuel(), true);
                        }
                        if (fuelQm != null) {
                            fuelQm = UnitUtil.recalculateFuel(fuelQm, xmlProfile.getFuel().getUnit(), SettingsBean.getInstance().getParamUnitsFuel(), true);
                        }
                        if (fuelQmax != null) {
                            fuelQmax = UnitUtil.recalculateFuel(fuelQmax, xmlProfile.getFuel().getUnit(), SettingsBean.getInstance().getParamUnitsFuel(), true);
                        }
                    }
                    profile.setFuelBurn(fuelBurn);
                    profile.setFuelQm(fuelQm);
                    profile.setFuelQmax(fuelQmax);
                }
                profiles.add(profile);
            }
        }
        return profiles;
    }

    public static boolean saveProfiles(List<PlaneProfile> profiles, String file) {
        Profiles xml = PlaneProfileUtil.getXml(profiles);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Profiles.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)xml, new File(file));
        }
        catch (JAXBException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    private static Profiles getXml(List<PlaneProfile> profiles) {
        Profiles xml = new Profiles();
        for (PlaneProfile profile : profiles) {
            Profiles.Profile xmlProfile = new Profiles.Profile();
            Profiles.Profile.CruiseAlt xmlCruiseAlt = new Profiles.Profile.CruiseAlt();
            if (profile.getCruiseAlt() != null) {
                xmlCruiseAlt.setValue(profile.getCruiseAlt());
            }
            xmlCruiseAlt.setUnit(SettingsBean.getInstance().getParamUnitsAltitude());
            xmlProfile.setCruiseAlt(xmlCruiseAlt);
            Profiles.Profile.CruiseSpeed xmlCruiseSpeed = new Profiles.Profile.CruiseSpeed();
            if (profile.getCruiseSpeed() != null) {
                xmlCruiseSpeed.setValue(profile.getCruiseSpeed());
            }
            xmlCruiseSpeed.setUnit(SettingsBean.getInstance().getParamUnitsSpeed());
            xmlProfile.setCruiseSpeed(xmlCruiseSpeed);
            Profiles.Profile.ClimbingSpeed xmlClimbingSpeed = new Profiles.Profile.ClimbingSpeed();
            if (profile.getClimbingSpeed() != null) {
                xmlClimbingSpeed.setValue(profile.getClimbingSpeed());
            }
            xmlClimbingSpeed.setUnit(SettingsBean.getInstance().getParamUnitsSpeed());
            xmlProfile.setClimbingSpeed(xmlClimbingSpeed);
            Profiles.Profile.DescendingSpeed xmlDescendingSpeed = new Profiles.Profile.DescendingSpeed();
            if (profile.getDescendingSpeed() != null) {
                xmlDescendingSpeed.setValue(profile.getDescendingSpeed());
            }
            xmlDescendingSpeed.setUnit(SettingsBean.getInstance().getParamUnitsSpeed());
            xmlProfile.setDescendingSpeed(xmlDescendingSpeed);
            Profiles.Profile.Fuel xmlFuel = new Profiles.Profile.Fuel();
            xmlFuel.setUnit(SettingsBean.getInstance().getParamUnitsFuel());
            if (profile.getNavFuelReserveMin() != null) {
                xmlFuel.setNavFuelReserveMin(profile.getNavFuelReserveMin());
            }
            Profiles.Profile.Fuel.Values fuelValues = new Profiles.Profile.Fuel.Values();
            if (profile.getFuelBurn() != null) {
                fuelValues.setFuelBurn(profile.getFuelBurn());
            }
            if (profile.getFuelQm() != null) {
                fuelValues.setFuelQm(profile.getFuelQm());
            }
            if (profile.getFuelQmax() != null) {
                fuelValues.setFuelQmax(profile.getFuelQmax());
            }
            xmlFuel.setValues(fuelValues);
            xmlProfile.setFuel(xmlFuel);
            xmlProfile.setName(profile.getName());
            xml.getProfile().add(xmlProfile);
        }
        return xml;
    }
}

