/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.java.guru.vfrflight.core.Position;
import org.apache.log4j.Logger;

public class PathFinder {
    private static final Logger log = Logger.getLogger(PathFinder.class);
    private static int NOT_VISITED = -1;
    private Map<Integer, List<Position>> paths;
    private final boolean[][] area;
    private final int[][] visited;
    private int areaWidth;
    private int areaHeight;
    private Position startPos;
    private Position endPos;

    public PathFinder(boolean[][] area) {
        this.area = area;
        this.areaWidth = area[0].length;
        this.areaHeight = area.length;
        this.visited = new int[this.areaHeight][this.areaWidth];
        for (int y = 0; y < this.areaHeight; ++y) {
            for (int x = 0; x < this.areaHeight; ++x) {
                this.visited[y][x] = NOT_VISITED;
            }
        }
    }

    public List<Position> doPathFinding(Position startPos, Position endPos) {
        this.getPaths().clear();
        this.startPos = startPos;
        this.endPos = endPos;
        this.findPaths(endPos, 0);
        for (int y = 0; y < this.areaHeight; ++y) {
            String s = "";
            for (int x = 0; x < this.areaHeight; ++x) {
                String vis = String.valueOf(this.visited[y][x]);
                if (vis.length() < 2) {
                    s = s + " ";
                }
                s = s + vis;
            }
            log.info(s);
        }
        return this.isVisited(startPos) ? this.getFinalPath(startPos) : null;
    }

    public int getVisited(Position pos) {
        return this.visited[pos.getY()][pos.getX()];
    }

    public List<Position> getFinalPath(Position pos) {
        ArrayList<Position> result = new ArrayList<Position>();
        result.add(pos);
        do {
            int ey;
            int ex;
            int sy;
            int sx;
            if ((sx = pos.getX() - 1) < 0) {
                sx = 0;
            }
            if ((sy = pos.getY() - 1) < 0) {
                sy = 0;
            }
            if ((ex = pos.getX() + 1) > this.areaWidth - 1) {
                ex = this.areaWidth - 1;
            }
            if ((ey = pos.getY() + 1) > this.areaHeight - 1) {
                ey = this.areaHeight - 1;
            }
            int min = Integer.MAX_VALUE;
            int minX = 0;
            int minY = 0;
            for (int y = sy; y <= ey; ++y) {
                for (int x = sx; x <= ex; ++x) {
                    if (this.visited[y][x] == NOT_VISITED || this.visited[y][x] >= min) continue;
                    min = this.visited[y][x];
                    minX = x;
                    minY = y;
                }
            }
            pos = new Position(minX, minY);
            result.add(pos);
        } while (!pos.equals(this.endPos));
        return result;
    }

    public void findPaths(Position pos, int num) {
        this.visited[pos.getY()][pos.getX()] = num;
        if (!this.startPos.equals(pos)) {
            Position newPos;
            if (pos.getX() > 0 && pos.getY() > 0 && !this.isWall(newPos = new Position(pos.getX() - 1, pos.getY() - 1)) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getX() > 0 && pos.getY() < this.areaHeight - 1 && !this.isWall(newPos = new Position(pos.getX() - 1, pos.getY() + 1)) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getX() < this.areaWidth - 1 && pos.getY() < this.areaHeight - 1 && !this.isWall(newPos = new Position(pos.getX() + 1, pos.getY() + 1)) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getX() < this.areaWidth - 1 && pos.getY() > 0 && !this.isWall(newPos = new Position(pos.getX() + 1, pos.getY() - 1)) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getY() > 0 && !this.isWall(newPos = new Position(pos.getX(), pos.getY() - 1)) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getX() > 0 && !this.isWall(newPos = new Position(pos.getX() - 1, pos.getY())) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getY() < this.areaHeight - 1 && !this.isWall(newPos = new Position(pos.getX(), pos.getY() + 1)) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
            if (pos.getX() < this.areaWidth - 1 && !this.isWall(newPos = new Position(pos.getX() + 1, pos.getY())) && !this.isVisited(newPos)) {
                this.findPaths(newPos, num + 1);
            }
        }
    }

    public boolean isWall(Position pos) {
        return this.area[pos.getY()][pos.getX()];
    }

    public boolean isVisited(Position pos) {
        return this.visited[pos.getY()][pos.getX()] != NOT_VISITED;
    }

    public static void test() {
        boolean[][] area = new boolean[][]{{false, false, false, false, false}, {false, true, false, true, false}, {false, false, false, true, true}, {true, false, true, true, false}, {false, false, false, false, false}};
        PathFinder pathFinder = new PathFinder(area);
        List<Position> path = pathFinder.doPathFinding(new Position(0, 0), new Position(4, 1));
        if (path != null) {
            for (int i = 0; i < path.size(); ++i) {
                log.info(path.get(i));
            }
        } else {
            log.info("NO PATH");
        }
    }

    public Map<Integer, List<Position>> getPaths() {
        if (this.paths == null) {
            this.paths = new HashMap<Integer, List<Position>>();
        }
        return this.paths;
    }

    public void setPaths(Map<Integer, List<Position>> paths) {
        this.paths = paths;
    }

    public boolean[][] getArea() {
        return this.area;
    }
}

