/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.util;

import de.micromata.opengis.kml.v_2_2_0.Coordinate;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import de.micromata.opengis.kml.v_2_2_0.Polygon;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.search.DiskObject;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.sql.facade.AirspaceFacade;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.SearchUtil;
import org.apache.log4j.Logger;

public class OrbxKmlUtil {
    private static final Logger log = Logger.getLogger(OrbxKmlUtil.class);

    public static boolean importFromKmzFile(String kmzFilename) {
        String unzipDir = "tmp/" + System.currentTimeMillis();
        try {
            IOUtil.unZipFile(kmzFilename, unzipDir);
        }
        catch (IOException e) {
            log.error(e, e);
            return false;
        }
        Set<DiskObject> results = SearchUtil.getRootList("*.kml", unzipDir);
        if (new File(unzipDir).exists() && results.size() > 0) {
            boolean result = true;
            for (DiskObject o : results) {
                log.info("Importing from ..." + unzipDir + o.getPath());
                result = OrbxKmlUtil.importFromFile(unzipDir + o.getPath());
                IOUtil.deleteFile(unzipDir + o.getPath());
            }
            IOUtil.deleteFile(unzipDir);
            return result;
        }
        return false;
    }

    public static boolean importFromFile(String kmlFilename) {
        OrbxKmlWrapper wrapper = new OrbxKmlWrapper();
        Kml kml = Kml.unmarshal((File)new File(kmlFilename));
        Document doc = (Document)kml.getFeature();
        for (Feature feature : doc.getFeature()) {
            OrbxKmlUtil.extractFeature("", wrapper, feature);
        }
        if (wrapper.getUserPoints().size() == 0 && wrapper.getAirspaceAreas().size() == 0) {
            return false;
        }
        log.info("Importing: " + wrapper.getUserPoints().size() + " points");
        UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
        userPointFacade.addNewUserPoints(wrapper.getUserPoints(), false);
        log.info("Importing: " + wrapper.getAirspaceAreas().size() + " airspaces");
        AirspaceFacade airspaceFacade = new AirspaceFacade(DBUtil.getDataSource());
        airspaceFacade.insertAirspaces(wrapper.getAirspaceAreas(), false);
        log.info("All done.");
        return true;
    }

    private static void extractFeature(String path, OrbxKmlWrapper wrapper, Feature feature) {
        if (feature instanceof Folder) {
            OrbxKmlUtil.extractFolder(path, wrapper, (Folder)feature);
        } else if (feature instanceof Placemark) {
            OrbxKmlUtil.extractPlacemark(path, wrapper, (Placemark)feature);
        } else if (feature instanceof Document) {
            OrbxKmlUtil.extractDocument(path, wrapper, (Document)feature);
        } else {
            log.info("Unknown feature! " + feature.getName());
        }
    }

    private static void extractDocument(String path, OrbxKmlWrapper wrapper, Document document) {
        for (Feature feature : document.getFeature()) {
            OrbxKmlUtil.extractFeature(path + ";;" + document.getName(), wrapper, feature);
        }
    }

    private static void extractFolder(String path, OrbxKmlWrapper wrapper, Folder folder) {
        for (Feature feature : folder.getFeature()) {
            OrbxKmlUtil.extractFeature(path + ";;" + folder.getName(), wrapper, feature);
        }
    }

    private static void extractPlacemark(String path, OrbxKmlWrapper wrapper, Placemark placemark) {
        Polygon polygon;
        if (placemark.getGeometry() instanceof Point) {
            Point point = (Point)placemark.getGeometry();
            for (Coordinate coord : point.getCoordinates()) {
                UserPoint up = new UserPoint();
                up.setName(placemark.getName());
                up.setLat(coord.getLatitude());
                up.setLon(coord.getLongitude());
                up.setTags(path + ";;");
                wrapper.getUserPoints().add(up);
            }
        } else if (placemark.getGeometry() instanceof Polygon && (polygon = (Polygon)placemark.getGeometry()).getOuterBoundaryIs() != null && polygon.getOuterBoundaryIs().getLinearRing() != null && polygon.getOuterBoundaryIs().getLinearRing().getCoordinates() != null) {
            AirspaceArea area = new AirspaceArea();
            area.setName(placemark.getName());
            area.setType(AirspaceType.ORBX_KML);
            for (Coordinate coord : polygon.getOuterBoundaryIs().getLinearRing().getCoordinates()) {
                area.getVertices().add(new AirspaceAreaVertex(new GpsPlace(coord.getLatitude(), coord.getLongitude())));
            }
            wrapper.getAirspaceAreas().add(area);
        }
    }

    private static class OrbxKmlWrapper {
        private List<UserPoint> userPoints;
        private List<AirspaceArea> airspaceAreas;

        public List<UserPoint> getUserPoints() {
            if (this.userPoints == null) {
                this.userPoints = new ArrayList<UserPoint>();
            }
            return this.userPoints;
        }

        public List<AirspaceArea> getAirspaceAreas() {
            if (this.airspaceAreas == null) {
                this.airspaceAreas = new ArrayList<AirspaceArea>();
            }
            return this.airspaceAreas;
        }
    }
}

